/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.entity.WorkFlowMatrix;
import org.egov.infra.workflow.service.SimpleWorkflowService;
import org.egov.pims.commons.Designation;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.masters.service.ScheduleOfRateService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class UpdateAbstractEstimateController
extends GenericWorkFlowController {
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    private CityService cityService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private DesignationService designationService;
    @Autowired
    @Qualifier(value="workflowService")
    private SimpleWorkflowService<AbstractEstimate> abstractEstimateWorkflowService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    @ModelAttribute
    public AbstractEstimate getAbstractEstimate(@PathVariable String abstractEstimateId) {
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(Long.valueOf(Long.parseLong(abstractEstimateId)));
        return abstractEstimate;
    }

    @RequestMapping(value={"/update/{abstractEstimateId}"}, method={RequestMethod.GET})
    public String updateAbstractEstimate(Model model, @PathVariable String abstractEstimateId, HttpServletRequest request, @RequestParam(value="mode", required=false) String mode) throws ApplicationException {
        AbstractEstimate abstractEstimate = this.getAbstractEstimate(abstractEstimateId);
        abstractEstimate.setEstimateValue(abstractEstimate.getEstimateValue().setScale(2, 6));
        this.splitSorAndNonSorActivities(abstractEstimate);
        abstractEstimate.setTempOverheadValues(abstractEstimate.getOverheadValues());
        abstractEstimate.setTempDeductionValues(abstractEstimate.getAbsrtractEstimateDeductions());
        abstractEstimate.setTempAssetValues(abstractEstimate.getAssetValues());
        if (mode != null && mode.equalsIgnoreCase("Save")) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("msg.estimate.saved", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null));
        }
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        return this.loadViewData(model, request, abstractEstimate);
    }

    private void splitSorAndNonSorActivities(AbstractEstimate abstractEstimate) {
        abstractEstimate.setSorActivities((List)abstractEstimate.getSORActivities());
        abstractEstimate.setNonSorActivities((List)abstractEstimate.getNonSORActivities());
    }

    @RequestMapping(value={"/update/{abstractEstimateId}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="abstractEstimate") AbstractEstimate abstractEstimate, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files, @RequestParam String removedActivityIds) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        AbstractEstimate updatedAbstractEstimate = null;
        String additionalRule = "";
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.estimateService.getApprovalPositionByMatrixDesignation(abstractEstimate, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.NEW.toString()) || abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.REJECTED.toString())) && !workFlowAction.equals("Cancel")) {
            this.estimateService.validateMultiYearEstimates(abstractEstimate, errors);
            this.estimateService.validateMandatory(abstractEstimate, errors);
            this.estimateService.validateAssetDetails(abstractEstimate, errors);
            this.estimateService.validateActivities(abstractEstimate, errors);
            this.estimateService.validateOverheads(abstractEstimate, errors);
            this.estimateService.validateBudgetHead(abstractEstimate, errors);
            if (!abstractEstimate.isSpillOverFlag()) {
                this.estimateService.validateWorkflowActionButton(abstractEstimate, errors, additionalRule, workFlowAction);
            }
            if (!this.estimateService.checkForDuplicateAccountCodesInEstimateDeductions(abstractEstimate)) {
                errors.reject("error.abstractestimate.duplicate.accountcodes", "error.abstractestimate.duplicate.accountcodes");
            }
            if (!workFlowAction.equals("Save")) {
                if (abstractEstimate.getSorActivities().isEmpty() && abstractEstimate.getNonSorActivities().isEmpty()) {
                    errors.reject("error.sor.nonsor.required", "error.sor.nonsor.required");
                }
                this.estimateService.validateLocationDetails(abstractEstimate, errors);
            }
        }
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && !this.worksApplicationProperties.lineEstimateRequired().booleanValue() && ("Create And Approve".equals(workFlowAction) || "Approve".equals(workFlowAction))) {
            this.estimateService.validateBudgetAmount(abstractEstimate, errors);
        }
        if (errors.hasErrors()) {
            for (Activity activity : abstractEstimate.getSorActivities()) {
                activity.setSchedule(this.scheduleOfRateService.getScheduleOfRateById(activity.getSchedule().getId()));
            }
            model.addAttribute("removedActivityIds", (Object)removedActivityIds);
            return this.loadViewData(model, request, abstractEstimate);
        }
        if (null != workFlowAction) {
            try {
                updatedAbstractEstimate = this.estimateService.updateAbstractEstimateDetails(abstractEstimate, approvalPosition, approvalComment, additionalRule, workFlowAction, files, removedActivityIds);
            }
            catch (ValidationException e) {
                String errorMessage = this.messageSource.getMessage("error.budgetappropriation.insufficient.amount", (Object[])new String[0], null);
                model.addAttribute("message", (Object)errorMessage);
                return abstractEstimate.isSpillOverFlag() ? "newAbstractEstimate-spilloverform" : "newAbstractEstimate-form";
            }
        }
        redirectAttributes.addFlashAttribute("abstractEstimate", updatedAbstractEstimate);
        if (updatedAbstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.NEW.toString())) {
            return "redirect:/abstractestimate/update/" + updatedAbstractEstimate.getId() + "?mode=save";
        }
        if (approvalPosition == null) {
            return "redirect:/abstractestimate/abstractestimate-success?estimate=" + updatedAbstractEstimate.getId() + "&approvalPosition=";
        }
        return "redirect:/abstractestimate/abstractestimate-success?estimate=" + updatedAbstractEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }

    private String loadViewData(Model model, HttpServletRequest request, AbstractEstimate abstractEstimate) {
        List values;
        AppConfigValues value;
        WorkFlowMatrix wfmatrix = null;
        this.estimateService.setDropDownValues(model);
        model.addAttribute("stateType", (Object)abstractEstimate.getClass().getSimpleName());
        if (abstractEstimate.getCurrentState() != null && !abstractEstimate.getCurrentState().getValue().equals("NEW")) {
            model.addAttribute("currentState", (Object)abstractEstimate.getCurrentState().getValue());
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated() || abstractEstimate.isSpillOverFlag()) {
            ArrayList<Designation> designations = new ArrayList<Designation>();
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "DESIGNATION_TECHSANCTION_AUTHORITY");
            for (AppConfigValues valuesFordesignation : configValues) {
                designations.add(this.designationService.getDesignationByName(valuesFordesignation.getValue()));
            }
            model.addAttribute("designations", designations);
        }
        if (!abstractEstimate.getEstimateTechnicalSanctions().isEmpty() && ((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(0)).getTechnicalSanctionBy() != null) {
            Designation designation = ((Assignment)this.assignmentService.findByEmployeeAndGivenDate(((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(0)).getTechnicalSanctionBy().getId(), new Date()).get(0)).getDesignation();
            model.addAttribute("designation", (Object)designation.getId());
            model.addAttribute("technicalSanctionBy", (Object)((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(0)).getTechnicalSanctionBy().getId());
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        if (abstractEstimate.isSpillOverFlag()) {
            workflowContainer.setAdditionalRule("Spillover");
            model.addAttribute("additionalRule", (Object)"Spillover");
        } else {
            workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        }
        workflowContainer.setAmountRule(abstractEstimate.getEstimateValue());
        workflowContainer.setPendingActions(abstractEstimate.getState().getNextAction());
        if (abstractEstimate.getState() != null && abstractEstimate.getState().getNextAction() != null) {
            model.addAttribute("pendingActions", (Object)abstractEstimate.getState().getNextAction());
            wfmatrix = this.abstractEstimateWorkflowService.getWfMatrix(abstractEstimate.getStateType(), null, abstractEstimate.getEstimateValue(), workflowContainer.getAdditionalRule(), abstractEstimate.getCurrentState().getValue(), abstractEstimate.getCurrentState().getNextAction());
            if (wfmatrix != null && wfmatrix.getNextStatus() != null) {
                model.addAttribute("nextStatus", (Object)wfmatrix.getNextStatus().toUpperCase());
            }
        }
        this.prepareWorkflow(model, (StateAware)abstractEstimate, workflowContainer);
        if (abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.NEW.toString())) {
            List validActions = Collections.emptyList();
            validActions = this.customizedWorkFlowService.getNextValidActions(abstractEstimate.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), abstractEstimate.getCreatedDate());
            model.addAttribute("validActionList", (Object)validActions);
        }
        if ((value = (AppConfigValues)(values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_SERVICE_FIELDS")).get(0)).getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isServiceVATRequired", (Object)true);
        } else {
            model.addAttribute("isServiceVATRequired", (Object)false);
        }
        List showDeductions = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SHOW_DEDUCTION_GRID");
        AppConfigValues showDeduction = (AppConfigValues)showDeductions.get(0);
        if (showDeduction.getValue().equalsIgnoreCase("Yes")) {
            model.addAttribute("isEstimateDeductionGrid", (Object)true);
        } else {
            model.addAttribute("isEstimateDeductionGrid", (Object)false);
        }
        this.estimateService.loadLocationAppConfigValue(model);
        if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            List nominationName;
            List nominationLimit = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_AMOUNT_LIMIT");
            AppConfigValues configValues = (AppConfigValues)nominationLimit.get(0);
            if (!configValues.getValue().isEmpty()) {
                model.addAttribute("nominationLimit", (Object)configValues.getValue());
            }
            model.addAttribute("nominationName", (Object)(!(nominationName = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_NAME")).isEmpty() ? ((AppConfigValues)nominationName.get(0)).getValue() : ""));
        }
        model.addAttribute("workflowHistory", (Object)this.worksUtils.getHistory(abstractEstimate.getState(), abstractEstimate.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        model.addAttribute("exceptionaluoms", (Object)this.worksUtils.getExceptionalUOMS());
        this.getEstimateDocuments(abstractEstimate);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("documentDetails", (Object)abstractEstimate.getDocumentDetails());
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        model.addAttribute("amountRule", (Object)abstractEstimate.getEstimateValue());
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        if (abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.NEW.toString()) || abstractEstimate.getEgwStatus().getCode().equals(AbstractEstimate.EstimateStatus.REJECTED.toString())) {
            model.addAttribute("mode", (Object)"edit");
            return abstractEstimate.isSpillOverFlag() ? "newAbstractEstimate-spilloverform" : "newAbstractEstimate-form";
        }
        model.addAttribute("mode", (Object)"workflowView");
        model.addAttribute("amountRule", (Object)abstractEstimate.getEstimateValue());
        return "abstractestimate-view";
    }

    private void getEstimateDocuments(AbstractEstimate abstractEstimate) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(abstractEstimate.getId(), "AbstractEstimate");
        abstractEstimate.setDocumentDetails(documentDetailsList);
    }
}

