/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.matrix.service.CustomizedWorkFlowService;
import org.egov.pims.commons.Designation;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.EstimateTechnicalSanction;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.entity.EstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.masters.service.ScheduleOfRateService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class CreateAbstractEstimateController
extends GenericWorkFlowController {
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    protected CustomizedWorkFlowService customizedWorkFlowService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showAbstractEstimateForm(@ModelAttribute(value="abstractEstimate") AbstractEstimate abstractEstimate, @RequestParam(required=false) Long lineEstimateDetailId, Model model) {
        LineEstimateDetails lineEstimateDetails = null;
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue() && lineEstimateDetailId == null) {
            return "redirect:/lineestimate/searchlineestimateforabstractestimate-form";
        }
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            lineEstimateDetails = this.lineEstimateDetailService.getById(lineEstimateDetailId);
        }
        model.addAttribute("defaultDepartmentId", (Object)this.worksUtils.getDefaultDepartmentId());
        this.populateDataForAbstractEstimate(lineEstimateDetails, model, abstractEstimate);
        abstractEstimate.setEstimateDate(new Date());
        this.loadViewData(model, abstractEstimate, lineEstimateDetails);
        return "newAbstractEstimate-form";
    }

    @RequestMapping(value={"/createspillover"}, method={RequestMethod.GET})
    public String showSpillOverAbstractEstimateForm(@ModelAttribute(value="abstractEstimate") AbstractEstimate abstractEstimate, @RequestParam(required=false) Long lineEstimateDetailId, Model model) {
        LineEstimateDetails lineEstimateDetails = null;
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue() && lineEstimateDetailId == null) {
            return "redirect:/lineestimate/searchlineestimateforabstractestimate-form";
        }
        if (this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
            lineEstimateDetails = this.lineEstimateDetailService.getById(lineEstimateDetailId);
        }
        abstractEstimate.setSpillOverFlag(true);
        this.populateDataForAbstractEstimate(lineEstimateDetails, model, abstractEstimate);
        abstractEstimate.setEstimateDate(new Date());
        this.loadViewData(model, abstractEstimate, lineEstimateDetails);
        model.addAttribute("cuttOffDate", (Object)this.worksUtils.getCutOffDate());
        model.addAttribute("currFinDate", (Object)this.worksUtils.getFinancialYearByDate(new Date()).getStartingDate());
        return "newAbstractEstimate-spilloverform";
    }

    private void loadViewData(Model model, AbstractEstimate abstractEstimate, LineEstimateDetails lineEstimateDetails) {
        List nominationName;
        this.estimateService.setDropDownValues(model);
        List departments = this.worksUtils.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            abstractEstimate.setExecutingDepartment((Department)departments.get(0));
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated() || abstractEstimate.isSpillOverFlag()) {
            ArrayList<Designation> designations = new ArrayList<Designation>();
            List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "DESIGNATION_TECHSANCTION_AUTHORITY");
            for (AppConfigValues valuesFordesignation : configValues) {
                designations.add(this.designationService.getDesignationByName(valuesFordesignation.getValue()));
            }
            model.addAttribute("designations", designations);
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(abstractEstimate.getEstimateValue() != null ? abstractEstimate.getEstimateValue() : BigDecimal.ZERO);
        if (abstractEstimate.isSpillOverFlag()) {
            workflowContainer.setAdditionalRule("Spillover");
            model.addAttribute("additionalRule", (Object)"Spillover");
        } else {
            workflowContainer.setAdditionalRule((String)this.cityService.cityDataAsMap().get("cityGrade"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
        }
        model.addAttribute("amountRule", (Object)(abstractEstimate.getEstimateValue() != null ? abstractEstimate.getEstimateValue() : BigDecimal.ZERO));
        this.prepareWorkflow(model, (StateAware)abstractEstimate, workflowContainer);
        List validActions = Collections.emptyList();
        validActions = this.customizedWorkFlowService.getNextValidActions(abstractEstimate.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), abstractEstimate.getCreatedDate());
        if (abstractEstimate.getState() != null && abstractEstimate.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)abstractEstimate.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)abstractEstimate.getState().getNextAction());
        }
        model.addAttribute("validActionList", (Object)validActions);
        model.addAttribute("mode", null);
        model.addAttribute("stateType", (Object)abstractEstimate.getClass().getSimpleName());
        model.addAttribute("documentDetails", (Object)abstractEstimate.getDocumentDetails());
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        List nominationLimit = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_AMOUNT_LIMIT");
        AppConfigValues value = (AppConfigValues)nominationLimit.get(0);
        if (!value.getValue().isEmpty()) {
            model.addAttribute("nominationLimit", (Object)value.getValue());
        }
        model.addAttribute("nominationName", (Object)(!(nominationName = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "NOMINATION_NAME")).isEmpty() ? ((AppConfigValues)nominationName.get(0)).getValue() : ""));
    }

    @RequestMapping(value={"/create", "/createspillover"}, method={RequestMethod.POST})
    public String saveAbstractEstimate(@ModelAttribute AbstractEstimate abstractEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult bindErrors, @RequestParam(value="file") MultipartFile[] files, HttpServletRequest request, @RequestParam String workFlowAction) throws IOException {
        AbstractEstimate savedAbstractEstimate;
        Long approvalPosition = 0L;
        String approvalComment = "";
        String additionalRule = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (request.getParameter("additionalRule") != null) {
            additionalRule = request.getParameter("additionalRule");
        }
        this.estimateService.validateMultiYearEstimates(abstractEstimate, bindErrors);
        this.estimateService.validateMandatory(abstractEstimate, bindErrors);
        this.estimateService.validateAssetDetails(abstractEstimate, bindErrors);
        this.estimateService.validateActivities(abstractEstimate, bindErrors);
        this.estimateService.validateOverheads(abstractEstimate, bindErrors);
        this.estimateService.validateBudgetHead(abstractEstimate, bindErrors);
        if (!abstractEstimate.isSpillOverFlag()) {
            this.estimateService.validateWorkflowActionButton(abstractEstimate, bindErrors, additionalRule, workFlowAction);
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            this.estimateService.validateTechnicalSanctionDetail(abstractEstimate, bindErrors);
            if (!this.estimateService.checkForDuplicateAccountCodesInEstimateDeductions(abstractEstimate)) {
                bindErrors.reject("error.abstractestimate.duplicate.accountcodes", "error.abstractestimate.duplicate.accountcodes");
            }
            this.estimateService.setTechnicalSanctionDetails(abstractEstimate);
        }
        if (!"Save".equals(workFlowAction)) {
            if (abstractEstimate.getSorActivities().isEmpty() && abstractEstimate.getNonSorActivities().isEmpty()) {
                bindErrors.reject("error.sor.nonsor.required", "error.sor.nonsor.required");
            }
            this.estimateService.validateLocationDetails(abstractEstimate, bindErrors);
        }
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && !this.worksApplicationProperties.lineEstimateRequired().booleanValue() && "Create And Approve".equals(workFlowAction)) {
            this.estimateService.validateBudgetAmount(abstractEstimate, bindErrors);
        }
        if (bindErrors.hasErrors()) {
            for (Activity activity : abstractEstimate.getSorActivities()) {
                activity.setSchedule(this.scheduleOfRateService.getScheduleOfRateById(activity.getSchedule().getId()));
            }
            this.estimateService.loadModelValues(abstractEstimate.getLineEstimateDetails(), model, abstractEstimate);
            if (abstractEstimate.getLineEstimateDetails() != null) {
                abstractEstimate.setProjectCode(abstractEstimate.getLineEstimateDetails().getProjectCode());
            }
            this.loadViewData(model, abstractEstimate, abstractEstimate.getLineEstimateDetails());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("technicalSanctionBy", (Object)request.getParameter("estimateTechnicalSanctions[0].technicalSanctionBy"));
            model.addAttribute("approvedByValue", (Object)request.getParameter("approvedBy"));
            model.addAttribute("additionalRule", this.cityService.cityDataAsMap().get("cityGrade"));
            return abstractEstimate.isSpillOverFlag() ? "newAbstractEstimate-spilloverform" : "newAbstractEstimate-form";
        }
        if (abstractEstimate.getState() == null) {
            if (WorksConstants.FORWARD_ACTION.equals(workFlowAction)) {
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.CREATED.toString()));
            } else if ("Create And Approve".equalsIgnoreCase(workFlowAction)) {
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.APPROVED.toString()));
                this.estimateService.saveTechnicalSanctionDetails(abstractEstimate);
                this.estimateService.saveAdminSanctionDetails(abstractEstimate);
            } else {
                abstractEstimate.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("AbstractEstimate", AbstractEstimate.EstimateStatus.NEW.toString()));
            }
        }
        try {
            savedAbstractEstimate = this.estimateService.createAbstractEstimate(abstractEstimate, files, approvalPosition, approvalComment, additionalRule, workFlowAction);
        }
        catch (ValidationException e) {
            String errorMessage = this.messageSource.getMessage("error.budgetappropriation.insufficient.amount", (Object[])new String[0], null);
            model.addAttribute("message", (Object)errorMessage);
            return abstractEstimate.isSpillOverFlag() ? "newAbstractEstimate-spilloverform" : "newAbstractEstimate-form";
        }
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(savedAbstractEstimate.getEgwStatus().getCode())) {
            return "redirect:/abstractestimate/update/" + savedAbstractEstimate.getId() + "?mode=save";
        }
        if (abstractEstimate.getLineEstimateDetails() != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isAbstractEstimateCreated()) {
            return "redirect:/abstractestimate/abstractestimate-success?estimate=" + savedAbstractEstimate.getId() + "&approvalPosition=";
        }
        return "redirect:/abstractestimate/abstractestimate-success?estimate=" + savedAbstractEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }

    @RequestMapping(value={"/abstractestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute AbstractEstimate abstractEstimate, @RequestParam(value="estimate") Long id, @RequestParam(value="approvalPosition") Long approvalPosition, HttpServletRequest request, Model model) {
        if (id != null) {
            abstractEstimate = this.estimateService.getAbstractEstimateById(id);
        }
        String pathVars = this.worksUtils.getPathVars(abstractEstimate.getEgwStatus(), abstractEstimate.getState(), abstractEstimate.getId(), approvalPosition);
        String[] keyNameArray = pathVars.split(",");
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1 && keyNameArray[0] != null) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(abstractEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        return new ModelAndView("abstractEstimate-success", "abstractEstimate", (Object)abstractEstimate);
    }

    private String getMessageByStatus(AbstractEstimate abstractEstimate, String approverName, String nextDesign) {
        String message = "";
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(abstractEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.estimate.saved", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.CREATED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.created", (Object[])new String[]{approverName, nextDesign, abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.RESUBMITTED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.resubmitted", (Object[])new String[]{approverName, nextDesign, abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.APPROVED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            if (!this.worksApplicationProperties.lineEstimateRequired().booleanValue()) {
                EstimateAppropriation lea = this.estimateAppropriationService.findLatestByAbstractEstimate(abstractEstimate);
                message = this.messageSource.getMessage("msg.estimate.techsanctioned.budget.appropriation", (Object[])new String[]{abstractEstimate.getEstimateNumber(), ((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(abstractEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionNumber(), lea.getBudgetUsage().getAppropriationnumber()}, null);
            } else {
                message = this.messageSource.getMessage("msg.estimate.techsanctioned", (Object[])new String[]{abstractEstimate.getEstimateNumber(), ((EstimateTechnicalSanction)abstractEstimate.getEstimateTechnicalSanctions().get(abstractEstimate.getEstimateTechnicalSanctions().size() - 1)).getTechnicalSanctionNumber()}, null);
            }
        } else if (abstractEstimate.getState() != null && "Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.estimate.rejected", (Object[])new String[]{abstractEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (AbstractEstimate.EstimateStatus.CANCELLED.toString().equals(abstractEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.estimate.cancelled", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        } else if (AbstractEstimate.EstimateStatus.CHECKED.toString().equals(abstractEstimate.getEgwStatus().getCode()) && !"Rejected".equals(abstractEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.abstractestimate.check.success", (Object[])new String[]{abstractEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        }
        return message;
    }

    public void populateDataForAbstractEstimate(LineEstimateDetails lineEstimateDetails, Model model, AbstractEstimate abstractEstimate) {
        if (lineEstimateDetails != null) {
            LineEstimate lineEstimate = lineEstimateDetails.getLineEstimate();
            abstractEstimate.setLineEstimateDetails(lineEstimateDetails);
            abstractEstimate.setExecutingDepartment(lineEstimate.getExecutingDepartment());
            abstractEstimate.setWorkCategory(lineEstimate.getWorkCategory());
            abstractEstimate.setWard(lineEstimateDetails.getLineEstimate().getWard());
            abstractEstimate.setNatureOfWork(lineEstimate.getNatureOfWork());
            abstractEstimate.setParentCategory(lineEstimate.getTypeOfWork());
            abstractEstimate.setCategory(lineEstimate.getSubTypeOfWork());
            abstractEstimate.setProjectCode(lineEstimateDetails.getProjectCode());
            abstractEstimate.setBeneficiary(lineEstimate.getBeneficiary());
            abstractEstimate.setLocality(lineEstimate.getLocation());
            abstractEstimate.setModeOfAllotment(lineEstimate.getModeOfAllotment());
        }
        abstractEstimate.addMultiYearEstimate(this.estimateService.populateMultiYearEstimate(abstractEstimate));
        abstractEstimate.addFinancialDetails(this.estimateService.populateEstimateFinancialDetails(abstractEstimate));
        this.estimateService.loadModelValues(lineEstimateDetails, model, abstractEstimate);
    }
}

