/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.SearchRequestCancelEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.config.properties.WorksApplicationProperties;
import org.egov.works.lineestimate.service.EstimateAppropriationService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class CancelAbstractEstimateController {
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private WorksApplicationProperties worksApplicationProperties;
    @Autowired
    private EstimateAppropriationService estimateAppropriationService;

    @RequestMapping(value={"/cancel/search"}, method={RequestMethod.GET})
    public String showSearchEstimateForm(@ModelAttribute SearchRequestCancelEstimate searchRequestCancelEstimate, Model model) throws ApplicationException {
        model.addAttribute("searchRequestCancelEstimate", (Object)searchRequestCancelEstimate);
        model.addAttribute("lineEstimateRequired", (Object)this.worksApplicationProperties.lineEstimateRequired());
        return "searchestimates-cancel";
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    public String cancelEstimate(HttpServletRequest request, Model model) throws ApplicationException {
        Long estimateId = Long.parseLong(request.getParameter("id"));
        String cancellationReason = request.getParameter("cancellationReason");
        String cancellationRemarks = request.getParameter("cancellationRemarks");
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(estimateId);
        List workOrderEstimates = this.workOrderEstimateService.getWorkOrderEstimatesToCancelEstimates(abstractEstimate.getEstimateNumber());
        if (!workOrderEstimates.isEmpty()) {
            model.addAttribute("errorMessage", (Object)this.messageSource.getMessage("error.estimate.loa.created", (Object[])new String[]{((WorkOrderEstimate)workOrderEstimates.get(0)).getWorkOrder().getWorkOrderNumber()}, null));
            return "abstractEstimate-success";
        }
        abstractEstimate.setCancellationReason(cancellationReason);
        abstractEstimate.setCancellationRemarks(cancellationRemarks);
        abstractEstimate = this.estimateService.cancel(abstractEstimate);
        String message = this.worksApplicationProperties.lineEstimateRequired() == false ? this.messageSource.getMessage("msg.abstractestimate.cancelled", (Object[])new String[]{abstractEstimate.getEstimateNumber(), this.estimateAppropriationService.findLatestByAbstractEstimate(abstractEstimate.getId()).getBudgetUsage().getAppropriationnumber()}, null) : this.messageSource.getMessage("msg.estimate.cancelled", (Object[])new String[]{abstractEstimate.getEstimateNumber()}, null);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("message", (Object)message);
        return "abstractEstimate-success";
    }
}

