/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.abstractestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateDeduction;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/abstractestimate"})
public class AbstractEstimatePDFController {
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    public static final String ABSTRACTESTIMATEPDF = "abstractEstimatePDF";

    @RequestMapping(value={"/abstractEstimatePDF/{estimateId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateAbstractEstimatePDF(HttpServletRequest request, @PathVariable(value="estimateId") Long id, HttpSession session) throws IOException {
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateById(id);
        return this.generateReport(abstractEstimate, request, session);
    }

    private ResponseEntity<byte[]> generateReport(AbstractEstimate abstractEstimate, HttpServletRequest request, HttpSession session) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        ArrayList activities = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        DecimalFormat df = new DecimalFormat("0.00");
        String cityName = request.getSession().getAttribute("citymunicipalityname").toString();
        reportParams.put("cityName", cityName);
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
        if (abstractEstimate != null) {
            reportParams.put("estimateDate", formatter.format(abstractEstimate.getEstimateDate()));
            if (abstractEstimate.getWard() != null) {
                reportParams.put("ward", abstractEstimate.getWard().getBoundaryType().getName().equalsIgnoreCase("City") ? abstractEstimate.getWard().getName() : abstractEstimate.getWard().getBoundaryNum().toString());
            }
            reportParams.put("abstractEstimate", abstractEstimate);
            double totalEstimateOverheadAmount = 0.0;
            for (Object overheadValue : abstractEstimate.getOverheadValues()) {
                totalEstimateOverheadAmount += overheadValue.getAmount();
            }
            reportParams.put("totalEstimateOverheadAmount", df.format(totalEstimateOverheadAmount));
            BigDecimal totalEstimateDeductionAmount = BigDecimal.ZERO;
            for (AbstractEstimateDeduction deductions : abstractEstimate.getAbsrtractEstimateDeductions()) {
                totalEstimateDeductionAmount = totalEstimateDeductionAmount.add(deductions.getAmount());
            }
            reportParams.put("totalEstimateDeductionAmount", df.format(totalEstimateDeductionAmount));
            activities.addAll(abstractEstimate.getSORActivities());
            activities.addAll(abstractEstimate.getNonSORActivities());
            if (abstractEstimate.getState() != null) {
                reportParams.put("workflowdetails", this.worksUtils.getWorkFlowHistory(abstractEstimate.getState(), abstractEstimate.getStateHistory()));
                reportParams.put("spillOverFlag", Boolean.FALSE);
            } else {
                reportParams.put("spillOverFlag", Boolean.TRUE);
            }
            List measurementSheets = this.measurementSheetService.findMeasurementForEstimateActivities(abstractEstimate.getId());
            if (measurementSheets != null && !measurementSheets.isEmpty()) {
                reportParams.put("measurementExists", Boolean.TRUE);
                reportParams.put("activities", this.estimateService.getMeasurementSheetForEstimate(abstractEstimate));
            } else {
                reportParams.put("measurementExists", Boolean.FALSE);
                reportParams.put("activities", activities);
            }
            reportParams.put("adminSanctionNumber", StringUtils.isNotBlank((String)abstractEstimate.getAdminSanctionNumber()) ? abstractEstimate.getAdminSanctionNumber() : "");
        }
        reportParams.put("currDate", sdf.format(new Date()));
        reportInput = new ReportRequest(ABSTRACTESTIMATEPDF, (Object)abstractEstimate, reportParams);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=Abstract/DetailedEstimate_" + abstractEstimate.getEstimateNumber() + ".pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

