/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.egov.works.web.adaptor.WorksReportJsonAdaptorHelper;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorksSectorReportJsonAdaptor
implements JsonSerializer<WorksMilestoneIndexResponse> {
    @Autowired
    private WorksReportJsonAdaptorHelper worksReportJsonAdaptorHelper;

    public JsonElement serialize(WorksMilestoneIndexResponse response, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (response != null) {
            jsonObject.addProperty("District Name", response.getDistrictname());
            jsonObject.addProperty("ULB Name", response.getUlbname());
            jsonObject.addProperty("Sector", response.getTypeofwork());
            jsonObject.addProperty("Fund", response.getFund());
            if (response.getScheme() != null) {
                jsonObject.addProperty("Scheme", response.getScheme());
            } else {
                jsonObject.addProperty("Scheme", "NA");
            }
            if (response.getSubscheme() != null) {
                jsonObject.addProperty("Sub Scheme", response.getSubscheme());
            } else {
                jsonObject.addProperty("Sub Scheme", "NA");
            }
            jsonObject.addProperty("Ward", response.getWard());
            jsonObject.addProperty("Estimate Number", response.getEstimatenumber());
            jsonObject.addProperty("Work Identification Number", response.getWin());
            jsonObject.addProperty("Name of the work", response.getNameofthework());
            if (response.getTotalestimatedcostinlakhs() != null) {
                jsonObject.addProperty("Estimated cost in lakhs", BigDecimal.valueOf(response.getTotalestimatedcostinlakhs() / 100000.0).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("Estimated cost in lakhs", "0.00");
            }
            jsonObject.addProperty("Agreement Number", response.getAgreementnumber());
            jsonObject.addProperty("Agreement Date", response.getAgreementdate() != null ? DateUtils.getDefaultFormattedDate((Date)response.getAgreementdate()) : "");
            jsonObject.addProperty("Contractor Name and code", response.getContractornamecode());
            jsonObject.addProperty("Contract Period(in days)", (Number)response.getContractperiod());
            if (response.getTotalworkordervalueinlakhs() != null) {
                jsonObject.addProperty("Work order value in lakhs", BigDecimal.valueOf(response.getTotalworkordervalueinlakhs() / 100000.0).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("Work order value in lakhs", "0.00");
            }
            if (response.getTotalbillamountinlakhs() != null) {
                jsonObject.addProperty("Total bill amount in lakhs", BigDecimal.valueOf(response.getTotalbillamountinlakhs() / 100000.0).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("Total bill amount in lakhs", "0.00");
            }
            if (response.getTotalpaidamountinlakhs() != null) {
                jsonObject.addProperty("Total paid amount in lakhs", BigDecimal.valueOf(response.getTotalpaidamountinlakhs() / 100000.0).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("Total paid amount in lakhs", "0.00");
            }
            jsonObject.addProperty("Is Milestone created", response.getIsmilestonecreated());
            DateTime currentDate = new DateTime();
            switch (currentDate.getMonthOfYear()) {
                case 1: {
                    this.worksReportJsonAdaptorHelper.showJanuaryData(response, jsonObject, currentDate);
                    break;
                }
                case 2: {
                    this.worksReportJsonAdaptorHelper.showFebruaryData(response, jsonObject, currentDate);
                    break;
                }
                case 3: {
                    this.worksReportJsonAdaptorHelper.showMarchData(response, jsonObject, currentDate);
                    break;
                }
                case 4: {
                    this.worksReportJsonAdaptorHelper.showAprilData(response, jsonObject, currentDate);
                    break;
                }
                case 5: {
                    this.worksReportJsonAdaptorHelper.showMayData(response, jsonObject, currentDate);
                    break;
                }
                case 6: {
                    this.worksReportJsonAdaptorHelper.showJuneData(response, jsonObject, currentDate);
                    break;
                }
                case 7: {
                    this.worksReportJsonAdaptorHelper.showJulyData(response, jsonObject, currentDate);
                    break;
                }
                case 8: {
                    this.worksReportJsonAdaptorHelper.showAugustData(response, jsonObject, currentDate);
                    break;
                }
                case 9: {
                    this.worksReportJsonAdaptorHelper.showSeptemberData(response, jsonObject, currentDate);
                    break;
                }
                case 10: {
                    this.worksReportJsonAdaptorHelper.showOctoberData(response, jsonObject, currentDate);
                    break;
                }
                case 11: {
                    this.worksReportJsonAdaptorHelper.showNovemberData(response, jsonObject, currentDate);
                    break;
                }
                case 12: {
                    this.worksReportJsonAdaptorHelper.showDecemberData(response, jsonObject, currentDate);
                    break;
                }
            }
            jsonObject.addProperty("Financial progress %", BigDecimal.valueOf(response.getFinancialprogress()).setScale(2, 6).toString());
            jsonObject.addProperty("Latest updated time stamp", response.getLatestupdatedtimestamp());
        }
        return jsonObject;
    }
}

