/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ViewAbstractEstimatePhotographJsonAdaptor
implements JsonSerializer<AbstractEstimate> {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private TrackMilestoneService trackMilestoneService;

    public JsonElement serialize(AbstractEstimate abstractEstimate, Type type, JsonSerializationContext jsc) {
        String na = "NA";
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(abstractEstimate.getEstimateNumber());
        JsonObject jsonObject = new JsonObject();
        if (abstractEstimate.getProjectCode() != null) {
            jsonObject.addProperty("winCode", abstractEstimate.getProjectCode().getCode());
        } else {
            jsonObject.addProperty("winCode", "NA");
        }
        jsonObject.addProperty("nameOfWork", abstractEstimate.getName());
        jsonObject.addProperty("estimateAmount", (Number)abstractEstimate.getEstimateValue());
        if (workOrderEstimate != null) {
            jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
            jsonObject.addProperty("contractorName", workOrderEstimate.getWorkOrder().getContractor().getName());
        } else {
            jsonObject.addProperty("workOrderNumber", "NA");
            jsonObject.addProperty("contractorName", "NA");
        }
        if (workOrderEstimate != null) {
            TrackMilestone trackMilestone = this.trackMilestoneService.getTrackMilestoneTotalPercentage(workOrderEstimate.getId());
            if (trackMilestone != null) {
                jsonObject.addProperty("workCompletion", (Number)trackMilestone.getTotalPercentage());
            } else {
                jsonObject.addProperty("workCompletion", "NA");
            }
        }
        jsonObject.addProperty("abstractEstimateId", (Number)abstractEstimate.getId());
        return jsonObject;
    }
}

