/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.entity.TrackMilestoneActivity;
import org.egov.works.workorder.entity.WorkOrder;
import org.springframework.stereotype.Component;

@Component
public class TrackMilestoneJsonAdaptor
implements JsonSerializer<Milestone> {
    public JsonElement serialize(Milestone milestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("0.00");
        if (milestone != null) {
            this.setMileStoneJsonAdaptorValues(milestone, jsonObject, sdf, sdf2, df);
        }
        return jsonObject;
    }

    private void setMileStoneJsonAdaptorValues(Milestone milestone, JsonObject jsonObject, SimpleDateFormat sdf, SimpleDateFormat sdf2, DecimalFormat df) {
        AbstractEstimate ae = milestone.getWorkOrderEstimate().getEstimate();
        LineEstimateDetails led = ae.getLineEstimateDetails();
        WorkOrder workOrder = milestone.getWorkOrderEstimate().getWorkOrder();
        jsonObject.addProperty("estimateNumber", ae.getEstimateNumber());
        if (led != null) {
            jsonObject.addProperty("lineEstimateDate", sdf.format(led.getLineEstimate().getLineEstimateDate()));
        }
        jsonObject.addProperty("nameOfWork", ae.getName());
        jsonObject.addProperty("projectCode", ae.getProjectCode().getCode());
        jsonObject.addProperty("typeOfWork", ae.getParentCategory().getName());
        if (ae.getCategory() != null) {
            jsonObject.addProperty("subTypeOfWork", ae.getCategory().getName());
        } else {
            jsonObject.addProperty("subTypeOfWork", "");
        }
        jsonObject.addProperty("lineEstimateCreatedBy", led != null ? led.getLineEstimate().getCreatedBy().getName() : "");
        jsonObject.addProperty("department", ae.getExecutingDepartment().getName());
        if (workOrder != null) {
            jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            jsonObject.addProperty("workOrderId", workOrder.getId().toString());
            jsonObject.addProperty("workOrderAmount", df.format(workOrder.getWorkOrderAmount()));
            jsonObject.addProperty("workOrderDate", sdf.format(workOrder.getWorkOrderDate()));
            jsonObject.addProperty("contractorName", workOrder.getContractor().getName());
        } else {
            jsonObject.addProperty("workOrderNumber", "");
            jsonObject.addProperty("workOrderId", "");
            jsonObject.addProperty("workOrderAmount", "");
            jsonObject.addProperty("workOrderDate", "");
            jsonObject.addProperty("contractorName", "");
        }
        jsonObject.add("activities", (JsonElement)(!milestone.getActivities().isEmpty() ? this.getMileStoneActivities(milestone, sdf, sdf2) : new JsonArray()));
        this.setTrackMilestoneActivities(milestone, jsonObject, sdf);
        jsonObject.addProperty("id", (Number)milestone.getId());
    }

    private void setTrackMilestoneActivities(Milestone milestone, JsonObject jsonObject, SimpleDateFormat sdf) {
        if (!milestone.getTrackMilestone().isEmpty()) {
            jsonObject.addProperty("mode", "update");
            jsonObject.add("trackMilestoneActivities", (JsonElement)this.getTrackMileStoneActivities(milestone, sdf));
        } else {
            jsonObject.addProperty("mode", "create");
            jsonObject.add("trackMilestoneActivities", (JsonElement)new JsonArray());
        }
    }

    private JsonArray getTrackMileStoneActivities(Milestone milestone, SimpleDateFormat sdf) {
        JsonArray jsonArray = new JsonArray();
        for (TrackMilestone ma : milestone.getTrackMilestone()) {
            for (TrackMilestoneActivity tma : ma.getActivities()) {
                JsonObject child = new JsonObject();
                child.addProperty("currentStatus", tma.getStatus());
                child.addProperty("completedPercentage", (Number)tma.getCompletedPercentage());
                if (tma.getCompletionDate() != null) {
                    child.addProperty("completionDate", sdf.format(tma.getCompletionDate()));
                }
                child.addProperty("reasonForDelay", tma.getRemarks());
                jsonArray.add((JsonElement)child);
            }
        }
        return jsonArray;
    }

    private JsonArray getMileStoneActivities(Milestone milestone, SimpleDateFormat sdf, SimpleDateFormat sdf2) {
        JsonArray jsonArray = new JsonArray();
        for (MilestoneActivity ma : milestone.getActivities()) {
            JsonObject child = new JsonObject();
            child.addProperty("stageOrderNumber", (Number)ma.getStageOrderNo());
            child.addProperty("description", ma.getDescription());
            child.addProperty("percentage", (Number)ma.getPercentage());
            child.addProperty("scheduleStartDate", sdf.format(ma.getScheduleStartDate()));
            child.addProperty("scheduleEndDate", sdf.format(ma.getScheduleEndDate()));
            child.addProperty("hiddenScheduleStartDate", sdf2.format(ma.getScheduleStartDate()));
            child.addProperty("hiddenScheduleEndDate", sdf2.format(ma.getScheduleEndDate()));
            jsonArray.add((JsonElement)child);
        }
        return jsonArray;
    }
}

