/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.commons.EgwStatus;
import org.egov.commons.EgwTypeOfWork;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.stereotype.Component;

@Component
public class SearchTrackMilestoneJsonAdaptor
implements JsonSerializer<TrackMilestone> {
    public JsonElement serialize(TrackMilestone trackMilestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (trackMilestone != null) {
            Milestone ms = trackMilestone.getMilestone();
            WorkOrderEstimate woe = ms.getWorkOrderEstimate();
            WorkOrder wo = woe.getWorkOrder();
            AbstractEstimate ae = woe.getEstimate();
            EgwStatus status = trackMilestone.getStatus();
            this.setAbstractEstimateJsonValues(jsonObject, ae);
            jsonObject.addProperty("agreementAmount", wo != null ? Double.toString(wo.getWorkOrderAmount()) : "");
            jsonObject.addProperty("workOrderNumber", wo != null ? wo.getWorkOrderNumber() : "");
            jsonObject.addProperty("workOrderId", wo != null ? wo.getId().toString() : "");
            jsonObject.addProperty("status", status != null ? status.getCode() : "");
            jsonObject.addProperty("id", (Number)trackMilestone.getMilestone().getId());
            jsonObject.addProperty("total", (Number)trackMilestone.getTotalPercentage());
        }
        return jsonObject;
    }

    private void setAbstractEstimateJsonValues(JsonObject jsonObject, AbstractEstimate ae) {
        if (ae != null) {
            EgwTypeOfWork typeOfWork = ae.getParentCategory();
            EgwTypeOfWork subTypeOfWork = ae.getCategory();
            LineEstimateDetails led = ae.getLineEstimateDetails();
            jsonObject.addProperty("typeOfWork", typeOfWork != null ? typeOfWork.getName() : "");
            jsonObject.addProperty("subTypeOfWork", subTypeOfWork != null ? subTypeOfWork.getName() : "");
            jsonObject.addProperty("lineEstimateId", led != null ? led.getLineEstimate().getId().toString() : "");
            jsonObject.addProperty("abstractEstimateId", ae.getId().toString());
            jsonObject.addProperty("estimateNumber", ae.getEstimateNumber());
            jsonObject.addProperty("workIdentificationNumber", ae.getProjectCode().getCode());
            jsonObject.addProperty("nameOfWork", ae.getName());
            jsonObject.addProperty("department", ae.getExecutingDepartment().getName());
        } else {
            jsonObject.addProperty("estimateNumber", "");
            jsonObject.addProperty("workIdentificationNumber", "");
            jsonObject.addProperty("nameOfWork", "");
            jsonObject.addProperty("department", "");
        }
    }
}

