/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.commons.EgwTypeOfWork;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.stereotype.Component;

@Component
public class SearchMilestoneJsonAdaptor
implements JsonSerializer<Milestone> {
    public JsonElement serialize(Milestone milestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (milestone != null) {
            WorkOrderEstimate woe = milestone.getWorkOrderEstimate();
            if (woe != null) {
                AbstractEstimate ae = woe.getEstimate();
                this.setAbstractEstimateJsonValues(jsonObject, ae);
                this.setWorkOrderJsonValues(jsonObject, woe);
            }
            jsonObject.addProperty("status", milestone.getStatus() != null ? milestone.getStatus().getCode() : "");
            jsonObject.addProperty("id", (Number)milestone.getId());
        }
        return jsonObject;
    }

    private void setWorkOrderJsonValues(JsonObject jsonObject, WorkOrderEstimate woe) {
        WorkOrder wo = woe.getWorkOrder();
        if (wo != null) {
            jsonObject.addProperty("agreementAmount", Double.toString(wo.getWorkOrderAmount()));
            jsonObject.addProperty("workOrderNumber", wo.getWorkOrderNumber());
            jsonObject.addProperty("workOrderId", wo.getId().toString());
        } else {
            jsonObject.addProperty("agreementAmount", "");
            jsonObject.addProperty("workOrderNumber", "");
            jsonObject.addProperty("workOrderId", "");
        }
    }

    private void setAbstractEstimateJsonValues(JsonObject jsonObject, AbstractEstimate ae) {
        if (ae != null) {
            EgwTypeOfWork typeOfWork = ae.getParentCategory();
            EgwTypeOfWork subTypeOfWork = ae.getCategory();
            LineEstimateDetails led = ae.getLineEstimateDetails();
            jsonObject.addProperty("typeOfWork", typeOfWork != null ? typeOfWork.getName() : "");
            jsonObject.addProperty("subTypeOfWork", subTypeOfWork != null ? subTypeOfWork.getName() : "");
            jsonObject.addProperty("lineEstimateId", led != null ? led.getLineEstimate().getId().toString() : "");
            jsonObject.addProperty("estimateNumber", ae.getEstimateNumber());
            jsonObject.addProperty("workIdentificationNumber", ae.getProjectCode().getCode());
            jsonObject.addProperty("nameOfWork", ae.getName());
            jsonObject.addProperty("department", ae.getExecutingDepartment().getName());
            jsonObject.addProperty("abstractEstimateId", ae.getId().toString());
        } else {
            jsonObject.addProperty("estimateNumber", "");
            jsonObject.addProperty("workIdentificationNumber", "");
            jsonObject.addProperty("nameOfWork", "");
            jsonObject.addProperty("department", "");
            jsonObject.addProperty("abstractEstimateId", "");
        }
    }
}

