/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.mb.entity.MBHeader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchMBToCancelJson
implements JsonSerializer<MBHeader> {
    final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;

    public JsonElement serialize(MBHeader mbHeader, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (mbHeader != null) {
            if (mbHeader.getWorkOrderEstimate() != null) {
                jsonObject.addProperty("workOrderNumber", mbHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
                jsonObject.addProperty("workOrderId", (Number)mbHeader.getWorkOrderEstimate().getWorkOrder().getId());
                jsonObject.addProperty("contractor", mbHeader.getWorkOrderEstimate().getWorkOrder().getContractor().getName());
                jsonObject.addProperty("contractorcode", mbHeader.getWorkOrderEstimate().getWorkOrder().getContractor().getCode());
                jsonObject.addProperty("estimateNumber", mbHeader.getWorkOrderEstimate().getEstimate().getEstimateNumber());
                jsonObject.addProperty("estimateId", (Number)mbHeader.getWorkOrderEstimate().getEstimate().getId());
                jsonObject.addProperty("workIdNumber", mbHeader.getWorkOrderEstimate().getEstimate().getProjectCode().getCode());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderId", "");
                jsonObject.addProperty("contractor", "");
                jsonObject.addProperty("contractorcode", "");
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("estimateId", "");
                jsonObject.addProperty("workIdNumber", "");
            }
            if (mbHeader.getMbRefNo() != null) {
                jsonObject.addProperty("mbRefNo", mbHeader.getMbRefNo());
            } else {
                jsonObject.addProperty("mbRefNo", "");
            }
            if (mbHeader.getMbAmount() != null) {
                jsonObject.addProperty("mbAmount", (Number)mbHeader.getMbAmount());
            } else {
                jsonObject.addProperty("mbAmount", "");
            }
            if (mbHeader.getMbDate() != null) {
                jsonObject.addProperty("mbDate", this.sdf.format(mbHeader.getMbDate()));
            } else {
                jsonObject.addProperty("mbDate", "");
            }
            ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContratorBillForWorkOrder(mbHeader.getWorkOrderEstimate(), ContractorBillRegister.BillStatus.CANCELLED.toString(), BillTypes.Final_Bill.toString());
            if (contractorBillRegister != null) {
                jsonObject.addProperty("billNumber", contractorBillRegister.getBillnumber());
            } else {
                jsonObject.addProperty("billNumber", "");
            }
            jsonObject.addProperty("id", (Number)mbHeader.getId());
        }
        return jsonObject;
    }
}

