/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchMBHeaderJsonAdaptor
implements JsonSerializer<MBHeader> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(MBHeader mBHeader, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        WorkOrderEstimate workOrderEstimate = mBHeader.getWorkOrderEstimate();
        jsonObject.addProperty("mbheaderId", (Number)mBHeader.getId());
        jsonObject.addProperty("workOrderId", (Number)workOrderEstimate.getWorkOrder().getId());
        jsonObject.addProperty("estimateId", (Number)workOrderEstimate.getEstimate().getId());
        jsonObject.addProperty("estimateNumber", workOrderEstimate.getEstimate().getEstimateNumber());
        jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
        jsonObject.addProperty("department", workOrderEstimate.getEstimate().getExecutingDepartment().getName());
        jsonObject.addProperty("contractor", workOrderEstimate.getWorkOrder().getContractor().getName());
        jsonObject.addProperty("agreemantAmount", (Number)workOrderEstimate.getWorkOrder().getWorkOrderAmount());
        jsonObject.addProperty("mbRefNo", mBHeader.getMbRefNo());
        jsonObject.addProperty("mbDate", sdf.format(mBHeader.getMbDate()));
        jsonObject.addProperty("mbrefnumberdate", mBHeader.getMbRefNo() + "--" + sdf.format(mBHeader.getMbDate()));
        jsonObject.addProperty("mbamount", (Number)mBHeader.getMbAmount());
        jsonObject.addProperty("mbpageno", mBHeader.getFromPageNo() + "-" + mBHeader.getToPageNo());
        jsonObject.addProperty("status", mBHeader.getEgwStatus().getDescription());
        jsonObject.addProperty("createdBy", mBHeader.getCreatedBy().getName());
        if (mBHeader.getState() != null && mBHeader.getState().getOwnerPosition() != null) {
            jsonObject.addProperty("currentOwner", this.worksUtils.getApproverName(mBHeader.getState().getOwnerPosition().getId()));
        } else {
            jsonObject.addProperty("currentOwner", "N/A");
        }
        return jsonObject;
    }
}

