/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.springframework.stereotype.Component;

@Component
public class SearchLineEstimateToCancelJSONAdaptor
implements JsonSerializer<LineEstimate> {
    public JsonElement serialize(LineEstimate lineEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        String estimateNumbers = "";
        String winCodes = "";
        Double adminSanctionAmount = 0.0;
        if (lineEstimate != null) {
            if (lineEstimate.getLineEstimateNumber() != null) {
                jsonObject.addProperty("lineEstimateNumber", lineEstimate.getLineEstimateNumber());
            } else {
                jsonObject.addProperty("lineEstimateNumber", "");
            }
            if (lineEstimate.getExecutingDepartment() != null) {
                jsonObject.addProperty("department", lineEstimate.getExecutingDepartment().getName());
            } else {
                jsonObject.addProperty("department", "");
            }
            if (lineEstimate.getCreatedBy() != null) {
                jsonObject.addProperty("createdBy", lineEstimate.getCreatedBy().getName());
            } else {
                jsonObject.addProperty("createdBy", "");
            }
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                estimateNumbers = estimateNumbers + led.getEstimateNumber() + ",";
                winCodes = winCodes + led.getProjectCode().getCode() + ",";
                adminSanctionAmount = adminSanctionAmount + led.getEstimateAmount().doubleValue();
            }
            jsonObject.addProperty("estimateNumber", estimateNumbers);
            jsonObject.addProperty("workIdentificationNumber", winCodes);
            jsonObject.addProperty("amount", (Number)adminSanctionAmount);
            jsonObject.addProperty("lineEstimateStatus", lineEstimate.getStatus().getCode());
            jsonObject.addProperty("id", (Number)lineEstimate.getId());
        }
        return jsonObject;
    }
}

