/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.List;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceForOfflineStatusJsonAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    @Autowired
    private OfflineStatusService offlineStatusService;

    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrderEstimate != null) {
            WorkOrder wo = workOrderEstimate.getWorkOrder();
            LineEstimateDetails led = workOrderEstimate.getEstimate().getLineEstimateDetails();
            this.setWorkOrderJsonValues(jsonObject, wo);
            jsonObject.addProperty("estimateNumber", workOrderEstimate.getEstimate().getEstimateNumber());
            jsonObject.addProperty("nameOfWork", workOrderEstimate.getEstimate().getName());
            jsonObject.addProperty("lineEstimateId", led != null ? led.getLineEstimate().getId().toString() : "");
            jsonObject.addProperty("abstractEstimateId", (Number)workOrderEstimate.getEstimate().getId());
        }
        return jsonObject;
    }

    private void setWorkOrderJsonValues(JsonObject jsonObject, WorkOrder wo) {
        if (wo != null) {
            if (wo.getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", wo.getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (wo.getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", wo.getWorkOrderDate().toString());
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (wo.getContractor() != null) {
                jsonObject.addProperty("contractor", wo.getContractor().getName());
            } else {
                jsonObject.addProperty("contractor", "");
            }
            jsonObject.addProperty("workOrderAmount", (Number)wo.getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)wo.getId());
            this.setStatusJsonValues(jsonObject, wo);
        }
    }

    private void setStatusJsonValues(JsonObject jsonObject, WorkOrder wo) {
        List offlinestatusses = this.offlineStatusService.getOfflineStatusByObjectIdAndType(wo.getId(), "WorkOrder");
        jsonObject.addProperty("statusSize", (Number)offlinestatusses.size());
        if (wo.getEgwStatus() != null) {
            OfflineStatus offlineStatusses = this.offlineStatusService.getLastOfflineStatusByObjectIdAndObjectType(wo.getId(), "WorkOrder");
            jsonObject.addProperty("status", offlineStatusses != null ? offlineStatusses.getEgwStatus().getDescription() : wo.getEgwStatus().getDescription());
        } else {
            jsonObject.addProperty("status", "");
        }
    }
}

