/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchContractorBillJsonAdaptor
implements JsonSerializer<ContractorBillRegister> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(ContractorBillRegister contractorBillRegister, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (contractorBillRegister != null) {
            WorkOrderEstimate woe = contractorBillRegister.getWorkOrderEstimate();
            WorkOrder wo = woe.getWorkOrder();
            AbstractEstimate ae = woe.getEstimate();
            LineEstimateDetails led = ae.getLineEstimateDetails();
            this.setContractorBillRegisterJsonValues(contractorBillRegister, jsonObject, ae);
            jsonObject.addProperty("workIdentificationNumber", ae.getProjectCode() != null ? ae.getProjectCode().getCode() : "");
            this.setWorkOrderJsonValues(jsonObject, wo);
            jsonObject.addProperty("lineEstimateId", led != null ? led.getLineEstimate().getId().toString() : "");
            jsonObject.addProperty("workActivitySize", (Number)woe.getWorkOrderActivities().size());
            jsonObject.addProperty("abstractEstimateId", (Number)ae.getId());
        }
        return jsonObject;
    }

    private void setContractorBillRegisterJsonValues(ContractorBillRegister contractorBillRegister, JsonObject jsonObject, AbstractEstimate ae) {
        jsonObject.addProperty("id", (Number)contractorBillRegister.getId());
        if (contractorBillRegister.getBillnumber() != null) {
            jsonObject.addProperty("billNumber", contractorBillRegister.getBillnumber());
        } else {
            jsonObject.addProperty("billNumber", "");
        }
        if (contractorBillRegister.getBilldate() != null) {
            jsonObject.addProperty("billDate", contractorBillRegister.getBilldate().toString());
        } else {
            jsonObject.addProperty("billDate", "");
        }
        if (contractorBillRegister.getBilltype() != null) {
            jsonObject.addProperty("billType", contractorBillRegister.getBilltype());
        } else {
            jsonObject.addProperty("billType", "");
        }
        if (contractorBillRegister.getBillamount() != null) {
            jsonObject.addProperty("billValue", contractorBillRegister.getBillamount().toString());
        } else {
            jsonObject.addProperty("billValue", "");
        }
        if (contractorBillRegister.getBillstatus() != null) {
            jsonObject.addProperty("billStatus", contractorBillRegister.getBillstatus());
        } else {
            jsonObject.addProperty("billStatus", "");
        }
        if (contractorBillRegister.getState().getOwnerPosition() != null) {
            jsonObject.addProperty("owner", this.worksUtils.getApproverName(contractorBillRegister.getState().getOwnerPosition().getId()));
        } else {
            jsonObject.addProperty("owner", "");
        }
        jsonObject.addProperty("adminSanctionNumber", ae != null ? ae.getEstimateNumber() : "");
    }

    private void setWorkOrderJsonValues(JsonObject jsonObject, WorkOrder wo) {
        jsonObject.addProperty("workOrderNumber", wo != null ? wo.getWorkOrderNumber() : "");
        if (wo != null) {
            jsonObject.addProperty("contractorName", wo.getContractor() != null ? wo.getContractor().getName() : "");
            jsonObject.addProperty("contractorCode", wo.getContractor() != null ? wo.getContractor().getCode() : "");
            jsonObject.addProperty("workOrderId", (Number)wo.getId());
        }
    }
}

