/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.contractoradvance.entity.ContractorAdvanceRequisition;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchContractorAdvanceJsonAdaptor
implements JsonSerializer<ContractorAdvanceRequisition> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(ContractorAdvanceRequisition contractorAdvanceRequisition, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("workOrderNumber", contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
        jsonObject.addProperty("advanceRequisitionNumber", contractorAdvanceRequisition.getAdvanceRequisitionNumber());
        jsonObject.addProperty("nameOfWork", contractorAdvanceRequisition.getWorkOrderEstimate().getEstimate().getName());
        jsonObject.addProperty("contractorName", contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getName() + " - " + contractorAdvanceRequisition.getWorkOrderEstimate().getWorkOrder().getContractor().getCode());
        jsonObject.addProperty("requisitionAmount", (Number)contractorAdvanceRequisition.getAdvanceRequisitionAmount());
        jsonObject.addProperty("status", contractorAdvanceRequisition.getStatus().getDescription());
        if (contractorAdvanceRequisition.getState() != null) {
            if (contractorAdvanceRequisition.getStatus() != null && (contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase("APPROVED") || contractorAdvanceRequisition.getStatus().getCode().equalsIgnoreCase("CANCELLED"))) {
                jsonObject.addProperty("currentowner", "NA");
            } else {
                jsonObject.addProperty("currentowner", this.worksUtils.getApproverName(contractorAdvanceRequisition.getState().getOwnerPosition().getId()));
            }
        } else {
            jsonObject.addProperty("currentowner", "NA");
        }
        jsonObject.addProperty("advanceBillNumber", contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister() != null ? contractorAdvanceRequisition.getEgAdvanceReqMises().getEgBillregister().getBillnumber() : "NA");
        jsonObject.addProperty("contractorRequisitionId", (Number)contractorAdvanceRequisition.getId());
        return jsonObject;
    }
}

