/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MeasurementBookJsonAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private MeasurementSheetService measurementSheetService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private CityService cityService;

    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        jsonObject.addProperty("showHistory", Boolean.valueOf(false));
        if (workOrderEstimate != null) {
            this.setMBJsonValues(workOrderEstimate, jsonObject, sdf);
            List previousMBHeaders = this.mbHeaderService.getPreviousMBHeaders(Long.valueOf(-1L), workOrderEstimate.getId());
            jsonObject.addProperty("previousMBDate", !previousMBHeaders.isEmpty() ? sdf.format(((MBHeader)previousMBHeaders.get(previousMBHeaders.size() - 1)).getMbDate()) : "");
            jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
            AbstractEstimate ae = workOrderEstimate.getEstimate();
            if (ae != null && ae.isSpillOverFlag()) {
                jsonObject.addProperty("spillOverFlag", Boolean.valueOf(ae.isSpillOverFlag()));
            }
        }
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "MB_QUANTITY_TOLERANCE_LEVEL");
        AppConfigValues value = (AppConfigValues)values.get(0);
        jsonObject.addProperty("quantityTolerance", value.getValue());
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy");
        Date cutOffDate = this.worksUtils.getCutOffDate();
        if (cutOffDate != null) {
            jsonObject.addProperty("cutOffDate", sdf.format(this.worksUtils.getCutOffDate()));
            jsonObject.addProperty("cutOffDateDisplay", fmt.format(this.worksUtils.getCutOffDate()));
        } else {
            jsonObject.addProperty("cutOffDate", "");
            jsonObject.addProperty("cutOffDateDisplay", "");
        }
        jsonObject.addProperty("additionalRule", (String)this.cityService.cityDataAsMap().get("cityGrade"));
        return jsonObject;
    }

    private void setMBJsonValues(WorkOrderEstimate workOrderEstimate, JsonObject jsonObject, SimpleDateFormat sdf) {
        AbstractEstimate estimate = workOrderEstimate.getEstimate();
        WorkOrder workOrder = workOrderEstimate.getWorkOrder();
        Double totalMBAmountOfMBs = this.mbHeaderService.getTotalMBAmountOfMBs(null, workOrderEstimate.getId(), MBHeader.MeasurementBookStatus.CANCELLED.toString());
        jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
        if (estimate != null) {
            jsonObject.addProperty("estimateNumber", estimate.getEstimateNumber());
            jsonObject.addProperty("estimateId", estimate.getId().toString());
            jsonObject.addProperty("projectCode", estimate.getProjectCode().getCode());
            jsonObject.addProperty("nameOfWork", estimate.getName());
            jsonObject.addProperty("isMeasurementsExist", this.measurementSheetService.existsByEstimate(estimate.getId()));
        } else {
            jsonObject.addProperty("estimateNumber", "");
            jsonObject.addProperty("estimateId", "");
            jsonObject.addProperty("projectCode", "");
            jsonObject.addProperty("nameOfWork", "");
        }
        this.setWorkOrderJsonValues(jsonObject, sdf, workOrder);
        jsonObject.addProperty("totalMBAmountOfMBs", totalMBAmountOfMBs != null ? Double.toString(totalMBAmountOfMBs) : "");
    }

    private void setWorkOrderJsonValues(JsonObject jsonObject, SimpleDateFormat sdf, WorkOrder workOrder) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (workOrder != null) {
            jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            jsonObject.addProperty("workOrderId", workOrder.getId().toString());
            jsonObject.addProperty("workOrderAmount", df.format(workOrder.getWorkOrderAmount()));
            jsonObject.addProperty("contractorName", workOrder.getContractor().getName());
            jsonObject.addProperty("workOrderAssignedTo", workOrder.getEngineerIncharge().getName());
            jsonObject.addProperty("tenderFinalisedPercentage", Double.toString(workOrder.getTenderFinalizedPercentage()));
            OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrder.getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            jsonObject.addProperty("workCommencedDate", offlineStatus != null ? sdf.format(offlineStatus.getStatusDate()) : "");
        } else {
            jsonObject.addProperty("workOrderNumber", "");
            jsonObject.addProperty("workOrderId", "");
            jsonObject.addProperty("workOrderAmount", "");
            jsonObject.addProperty("contractorName", "");
            jsonObject.addProperty("workOrderAssignedTo", "");
            jsonObject.addProperty("tenderFinalisedPercentage", "");
        }
    }
}

