/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.stereotype.Component;

@Component
public class LetterOfAcceptanceForMilestoneJSONAdaptor
implements JsonSerializer<WorkOrderEstimate> {
    public JsonElement serialize(WorkOrderEstimate workOrderEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrderEstimate != null) {
            AbstractEstimate ae = workOrderEstimate.getEstimate();
            LineEstimateDetails led = ae.getLineEstimateDetails();
            jsonObject.addProperty("estimateNumber", ae.getEstimateNumber());
            jsonObject.addProperty("typeOfWork", ae.getParentCategory().getName());
            jsonObject.addProperty("subTypeOfWork", ae.getCategory() != null ? ae.getCategory().getName() : "");
            if (led != null) {
                jsonObject.addProperty("estimateDate", led.getLineEstimate().getLineEstimateDate().toString());
            }
            jsonObject.addProperty("nameOfTheWork", ae.getName());
            jsonObject.addProperty("workIdentificationNumber", ae.getProjectCode().getCode());
            jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
            jsonObject.addProperty("workOrderAmount", (Number)workOrderEstimate.getWorkOrder().getWorkOrderAmount());
            jsonObject.addProperty("workOrderDate", workOrderEstimate.getWorkOrder().getWorkOrderDate().toString());
            jsonObject.addProperty("workOrderId", (Number)workOrderEstimate.getWorkOrder().getId());
            jsonObject.addProperty("workOrderEstimateId", (Number)workOrderEstimate.getId());
        }
        return jsonObject;
    }
}

