/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.masters.entity.EstimateTemplate;
import org.springframework.stereotype.Component;

@Component
public class EstimateTemplateJsonAdaptor
implements JsonSerializer<EstimateTemplate> {
    public JsonElement serialize(EstimateTemplate estimateTemplate, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (estimateTemplate != null) {
            jsonObject.addProperty("id", (Number)estimateTemplate.getId());
            jsonObject.addProperty("code", estimateTemplate.getCode());
            jsonObject.addProperty("description", estimateTemplate.getDescription());
            jsonObject.addProperty("name", estimateTemplate.getName());
            jsonObject.addProperty("typeOfWork", estimateTemplate.getWorkType().getName());
            if (estimateTemplate.getSubType() != null) {
                jsonObject.addProperty("subTypeOfWork", estimateTemplate.getSubType().getName());
            } else {
                jsonObject.addProperty("subTypeOfWork", "");
            }
            if (estimateTemplate.getStatus() == 0) {
                jsonObject.addProperty("status", "INACTIVE");
            } else {
                jsonObject.addProperty("status", "ACTIVE");
            }
        }
        return jsonObject;
    }
}

