/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.MeasurementSheet;
import org.egov.works.abstractestimate.entity.NonSor;
import org.egov.works.masters.entity.ScheduleOfRate;
import org.springframework.stereotype.Component;

@Component
public class EstimateActivityJsonAdaptor
implements JsonSerializer<Activity> {
    public JsonElement serialize(Activity activity, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        if (activity != null) {
            if (activity.getSchedule() != null) {
                ScheduleOfRate schedule = activity.getSchedule();
                jsonObject.addProperty("scheduleId", (Number)schedule.getId());
                jsonObject.addProperty("scheduleCategoryCode", schedule.getScheduleCategory().getCode());
                jsonObject.addProperty("scheduleCode", schedule.getCode());
                jsonObject.addProperty("scheduleSummary", schedule.getSummary());
                jsonObject.addProperty("scheduleDescription", schedule.getSummary());
                jsonObject.addProperty("scheduleUom", schedule.getUom().getUom());
                jsonObject.addProperty("scheduleUomId", (Number)schedule.getUom().getId());
                try {
                    schedule.setSorRateValue(Double.valueOf(schedule.getRateOn(activity.getEstimateDate()).getRate().getValue()));
                }
                catch (ApplicationRuntimeException e) {
                    schedule.setSorRateValue(Double.valueOf(0.0));
                }
                jsonObject.addProperty("scheduleRate", schedule.getSorRate());
                jsonObject.addProperty("scheduleQuantity", (Number)activity.getQuantity());
            } else {
                NonSor nonSor = activity.getNonSor();
                jsonObject.addProperty("nonSorDescription", nonSor.getDescription());
                jsonObject.addProperty("nonSorUomId", (Number)activity.getUom().getId());
                jsonObject.addProperty("nonSorUom", activity.getUom().getUom());
                jsonObject.addProperty("nonSorRate", (Number)activity.getEstimateRate());
                jsonObject.addProperty("nonSorQuantity", (Number)activity.getQuantity());
            }
        }
        if (!activity.getMeasurementSheetList().isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (MeasurementSheet ms : activity.getMeasurementSheetList()) {
                JsonObject child = new JsonObject();
                child.addProperty("slNo", (Number)ms.getSlNo());
                child.addProperty("remarks", ms.getRemarks());
                child.addProperty("no", (Number)ms.getNo());
                child.addProperty("length", (Number)ms.getLength());
                child.addProperty("width", (Number)ms.getWidth());
                child.addProperty("depthOrHeight", (Number)ms.getDepthOrHeight());
                child.addProperty("quantity", (Number)ms.getQuantity());
                child.addProperty("identifier", Character.valueOf(ms.getIdentifier()));
                jsonArray.add((JsonElement)child);
            }
            jsonObject.add("ms", (JsonElement)jsonArray);
        } else {
            jsonObject.add("ms", (JsonElement)new JsonArray());
        }
        return jsonObject;
    }
}

