/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EstimateAbstractReportJsonAdaptor
implements JsonSerializer<EstimateAbstractReport> {
    final SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;

    public JsonElement serialize(EstimateAbstractReport estimateAbstractReport, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (estimateAbstractReport != null) {
            if (estimateAbstractReport.getDepartmentName() != null) {
                jsonObject.addProperty("departmentName", estimateAbstractReport.getDepartmentName());
            } else {
                jsonObject.addProperty("departmentName", "");
            }
            if (estimateAbstractReport.getTypeOfWorkName() != null) {
                jsonObject.addProperty("typeOfWorkName", estimateAbstractReport.getTypeOfWorkName());
            } else {
                jsonObject.addProperty("typeOfWorkName", "");
            }
            if (estimateAbstractReport.getSubTypeOfWorkName() != null) {
                jsonObject.addProperty("subTypeOfWorkName", estimateAbstractReport.getSubTypeOfWorkName());
            } else {
                jsonObject.addProperty("subTypeOfWorkName", "");
            }
            if (estimateAbstractReport.getLineEstimates() != null) {
                jsonObject.addProperty("lineEstimates", estimateAbstractReport.getLineEstimates());
            } else {
                jsonObject.addProperty("lineEstimates", "");
            }
            if (estimateAbstractReport.getAdminSanctionedEstimates() != null) {
                jsonObject.addProperty("adminSanctionedEstimates", estimateAbstractReport.getAdminSanctionedEstimates());
            } else {
                jsonObject.addProperty("adminSanctionedEstimates", "");
            }
            if (estimateAbstractReport.getLeAdminSanctionedAmountInCrores() != null) {
                jsonObject.addProperty("leAdminSanctionedAmountInCrores", new BigDecimal(estimateAbstractReport.getLeAdminSanctionedAmountInCrores()).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("leAdminSanctionedAmountInCrores", "");
            }
            if (estimateAbstractReport.getAeAdminSanctionedAmountInCrores() != null) {
                jsonObject.addProperty("aeAdminSanctionedAmountInCrores", new BigDecimal(estimateAbstractReport.getAeAdminSanctionedAmountInCrores()).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("aeAdminSanctionedAmountInCrores", "");
            }
            if (estimateAbstractReport.getWorkValueOfAdminSanctionedAEInCrores() != null) {
                jsonObject.addProperty("workValueOfAdminSanctionedAEInCrores", new BigDecimal(estimateAbstractReport.getWorkValueOfAdminSanctionedAEInCrores()).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("aeAdminSanctionedAmountInCrores", "");
            }
            if (estimateAbstractReport.getTechnicalSanctionedEstimates() != null) {
                jsonObject.addProperty("technicalSanctionedEstimates", estimateAbstractReport.getTechnicalSanctionedEstimates());
            } else {
                jsonObject.addProperty("technicalSanctionedEstimates", "");
            }
            if (estimateAbstractReport.getLoaCreated() != null) {
                jsonObject.addProperty("loaCreated", estimateAbstractReport.getLoaCreated());
            } else {
                jsonObject.addProperty("loaCreated", "");
            }
            if (estimateAbstractReport.getLoaNotCreated() != null) {
                jsonObject.addProperty("loaNotCreated", estimateAbstractReport.getLoaNotCreated());
            } else {
                jsonObject.addProperty("loaNotCreated", "");
            }
            if (estimateAbstractReport.getWorkNotCommenced() != null) {
                jsonObject.addProperty("workNotCommenced", estimateAbstractReport.getWorkNotCommenced());
            } else {
                jsonObject.addProperty("workNotCommenced", "");
            }
            if (estimateAbstractReport.getAgreementValueInCrores() != null) {
                jsonObject.addProperty("agreementValueInCrores", new BigDecimal(estimateAbstractReport.getAgreementValueInCrores()).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("agreementValueInCrores", "");
            }
            if (estimateAbstractReport.getWorkInProgress() != null) {
                jsonObject.addProperty("workInProgress", estimateAbstractReport.getWorkInProgress());
            } else {
                jsonObject.addProperty("workInProgress", "");
            }
            if (estimateAbstractReport.getWorkCompleted() != null) {
                jsonObject.addProperty("workCompleted", estimateAbstractReport.getWorkCompleted());
            } else {
                jsonObject.addProperty("workCompleted", "");
            }
            if (estimateAbstractReport.getBillsCreated() != null) {
                jsonObject.addProperty("billsCreated", estimateAbstractReport.getBillsCreated());
            } else {
                jsonObject.addProperty("billsCreated", "");
            }
            if (estimateAbstractReport.getBillValueInCrores() != null) {
                jsonObject.addProperty("billValueInCrores", new BigDecimal(estimateAbstractReport.getBillValueInCrores()).setScale(2, 6).toString());
            } else {
                jsonObject.addProperty("billValueInCrores", "");
            }
            jsonObject.addProperty("createdDate", this.formatter.format(this.workProgressRegisterService.getReportSchedulerRunDate()));
        }
        return jsonObject;
    }
}

