/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.service.TypeOfWorkService;
import org.egov.commons.service.UOMService;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.models.BaseModel;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.masters.entity.EstimateTemplate;
import org.egov.works.masters.entity.EstimateTemplateActivity;
import org.egov.works.masters.entity.ScheduleOfRate;
import org.egov.works.masters.service.EstimateTemplateService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateTemplateAction;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"new"}, location="estimateTemplate-new.jsp"), @Result(name={"search"}, location="estimateTemplate-search.jsp"), @Result(name={"success"}, location="estimateTemplate-success.jsp"), @Result(name={"edit"}, location="estimateTemplate-edit.jsp")})
public class EstimateTemplateAction
extends SearchFormAction {
    private static final long serialVersionUID = 3610026596221473556L;
    private EstimateTemplate estimateTemplate = new EstimateTemplate();
    private List<EstimateTemplateActivity> sorActivities = new LinkedList();
    private List<EstimateTemplateActivity> nonSorActivities = new LinkedList();
    private WorksService worksService;
    @Autowired
    private EstimateTemplateService estimateTemplateService;
    private String mode = null;
    private Long id;
    private String sourcePage = null;
    private Long typeOfWork;
    private String estimateTemplateCode;
    private Long subTypeOfWork;
    public static final String SEARCH = "search";
    public static final String EDIT = "edit";
    public static final String SUCCESS = "success";
    @Autowired
    private UOMService uomService;
    @Autowired
    private TypeOfWorkService typeOfWorkService;

    public EstimateTemplateAction() {
        this.addRelatedEntity("workType", EgwTypeOfWork.class);
        this.addRelatedEntity("subType", EgwTypeOfWork.class);
    }

    public Object getModel() {
        return this.estimateTemplate;
    }

    protected void setModel(EstimateTemplate estimateTemplate) {
        this.estimateTemplate = estimateTemplate;
    }

    @Action(value="/estimate/estimateTemplate-edit")
    public String edit() {
        return EDIT;
    }

    @Action(value="/estimate/estimateTemplate-view")
    public String view() {
        this.mode = "view";
        return SUCCESS;
    }

    public void prepare() {
        if (this.id != null) {
            this.estimateTemplate = this.estimateTemplateService.getEstimateTemplateById(this.id);
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"workType", "subType"});
        if (!StringUtils.isBlank((String)this.mode) && this.mode.equals("view")) {
            this.addDropdownData("parentCategoryList", this.typeOfWorkService.getTypeOfWorkByPartyType("Contractor"));
        } else {
            this.addDropdownData("parentCategoryList", this.typeOfWorkService.getActiveTypeOfWorksByPartyType("Contractor"));
        }
        this.addDropdownData("uomList", this.uomService.findAll());
        this.addDropdownData("scheduleCategoryList", this.getPersistenceService().findAllBy("from ScheduleCategory order by upper(code)", new Object[0]));
        this.populateCategoryList(this.estimateTemplate.getWorkType() != null);
    }

    @Action(value="/estimate/estimateTemplate-newform")
    public String newform() {
        return "new";
    }

    @SkipValidation
    @Action(value="/estimate/estimateTemplate-search")
    public String search() {
        return SEARCH;
    }

    @Action(value="/estimate/estimateTemplate-save")
    public String save() {
        EstimateTemplate template;
        this.estimateTemplate.getEstimateTemplateActivities().clear();
        this.populateSorActivities();
        this.populateNonSorActivities();
        this.populateActivities();
        if (this.estimateTemplate.getId() == null) {
            this.estimateTemplate.setStatus(1);
        } else {
            this.setMode(EDIT);
        }
        if (this.estimateTemplate != null && (template = this.estimateTemplateService.getEstimateTemplateByCode(this.estimateTemplate.getCode())) != null && this.estimateTemplate.getId() != template.getId()) {
            this.addActionMessage(this.getText("estimateTemplate.code.isunique"));
            return "new";
        }
        this.estimateTemplateService.create(this.estimateTemplate);
        if (StringUtils.isBlank((String)this.mode)) {
            this.addActionMessage(this.getText("estimate.template.success.save", new String[]{this.estimateTemplate.getCode(), this.estimateTemplate.getName()}));
        } else {
            this.addActionMessage(this.getText("estimate.template.success.modify"));
        }
        return SUCCESS;
    }

    protected void populateSorActivities() {
        for (EstimateTemplateActivity activity : this.sorActivities) {
            if (!this.validSorActivity(activity)) continue;
            activity.setSchedule((ScheduleOfRate)this.getPersistenceService().find("from ScheduleOfRate where id = ?", new Object[]{activity.getSchedule().getId()}));
            activity.setUom(activity.getSchedule().getUom());
            this.estimateTemplate.addActivity(activity);
        }
    }

    protected boolean validSorActivity(EstimateTemplateActivity activity) {
        return activity != null && activity.getSchedule() != null && activity.getSchedule().getId() != null;
    }

    protected void populateNonSorActivities() {
        for (EstimateTemplateActivity activity : this.nonSorActivities) {
            if (activity == null) continue;
            activity.setUom(this.uomService.findOne(activity.getNonSor().getUom().getId()));
            activity.getNonSor().setUom(activity.getUom());
            activity.getNonSor().setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setCreatedDate(new Date());
            activity.getNonSor().setLastModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.getNonSor().setLastModifiedDate(new Date());
            this.estimateTemplate.addActivity(activity);
        }
    }

    private void populateActivities() {
        for (EstimateTemplateActivity activity : this.estimateTemplate.getEstimateTemplateActivities()) {
            activity.setEstimateTemplate(this.estimateTemplate);
            activity.setCreatedBy(this.worksService.getCurrentLoggedInUser());
            activity.setCreatedDate(new Date());
            activity.setModifiedBy(this.worksService.getCurrentLoggedInUser());
            activity.setModifiedDate(new Date());
        }
        this.persistenceService.applyAuditing((BaseModel)this.estimateTemplate);
    }

    protected void populateCategoryList(boolean categoryPopulated) {
        if (categoryPopulated) {
            this.addDropdownData("categoryList", this.typeOfWorkService.getActiveSubTypeOfWorksByParentIdAndPartyType(this.estimateTemplate.getWorkType().getId(), "Contractor"));
        } else {
            this.addDropdownData("categoryList", Collections.emptyList());
        }
    }

    public boolean validCode() {
        boolean status = false;
        if (this.estimateTemplate != null && this.estimateTemplate.getCode() != null) {
            AjaxEstimateTemplateAction ajaxEstimateTemplateAction = new AjaxEstimateTemplateAction();
            ajaxEstimateTemplateAction.setCode(this.estimateTemplate.getCode());
            ajaxEstimateTemplateAction.setPersistenceService(this.persistenceService);
            if (ajaxEstimateTemplateAction.getCodeCheck()) {
                status = true;
            }
        }
        return status;
    }

    @Action(value="/estimate/estimateTemplate-searchDetails")
    public String searchDetails() {
        this.setPageSize(30);
        super.search();
        return SEARCH;
    }

    public List<EstimateTemplateActivity> getSorActivities() {
        return this.sorActivities;
    }

    public void setSorActivities(List<EstimateTemplateActivity> sorActivities) {
        this.sorActivities = sorActivities;
    }

    public List<EstimateTemplateActivity> getNonSorActivities() {
        return this.nonSorActivities;
    }

    public void setNonSorActivities(List<EstimateTemplateActivity> nonSorActivities) {
        this.nonSorActivities = nonSorActivities;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String dynQuery = " from EstimateTemplate et where et.id is not null ";
        ArrayList<Number> paramList = new ArrayList<Number>();
        dynQuery = dynQuery + " and et.status = ?";
        paramList.add(this.estimateTemplate.getStatus());
        if (this.estimateTemplate.getWorkType() != null && this.estimateTemplate.getWorkType().getId() != -1L) {
            dynQuery = dynQuery + " and et.workType.id = ? ";
            paramList.add(this.estimateTemplate.getWorkType().getId());
        }
        if (this.estimateTemplate.getSubType() != null && this.estimateTemplate.getSubType().getId() != -1L) {
            dynQuery = dynQuery + " and et.subType.id = ? ";
            paramList.add(this.estimateTemplate.getSubType().getId());
        }
        if (StringUtils.isNotBlank((String)this.estimateTemplate.getCode().trim())) {
            dynQuery = dynQuery + " and UPPER(et.code) like '%" + this.estimateTemplate.getCode().trim().toUpperCase() + "%'";
        }
        if (StringUtils.isNotBlank((String)this.estimateTemplate.getName().trim())) {
            dynQuery = dynQuery + " and UPPER(et.name) like '%" + this.estimateTemplate.getName().trim().toUpperCase() + "%'";
        }
        String countQuery = "select distinct count(et) " + dynQuery;
        return new SearchQueryHQL(dynQuery, countQuery, paramList);
    }

    public String getSourcePage() {
        return this.sourcePage;
    }

    public void setSourcePage(String sourcePage) {
        this.sourcePage = sourcePage;
    }

    public Long getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(Long typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public String getEstimateTemplateCode() {
        return this.estimateTemplateCode;
    }

    public void setEstimateTemplateCode(String estimateTemplateCode) {
        this.estimateTemplateCode = estimateTemplateCode;
    }

    public Long getSubTypeOfWork() {
        return this.subTypeOfWork;
    }

    public void setSubTypeOfWork(Long subTypeOfWork) {
        this.subTypeOfWork = subTypeOfWork;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }
}

