/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class UpdateLetterOfAcceptanceController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;

    @ModelAttribute
    public WorkOrder getWorkOrder(@PathVariable String id) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        return workOrder;
    }

    @RequestMapping(value={"/modify/{id}"}, method={RequestMethod.GET})
    public String viewLOA(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        WorkOrder newWorkOrder = this.getWorkOrderDocuments(workOrder);
        model.addAttribute("workOrder", (Object)newWorkOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
        model.addAttribute("mode", (Object)"modify");
        return "letterOfAcceptance-modify";
    }

    @RequestMapping(value={"/modify/{id}"}, method={RequestMethod.POST})
    public String modify(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, BindingResult resultBinder, HttpServletRequest request) throws ApplicationException {
        List workOrderNumbers = this.letterOfAcceptanceService.getApprovedWorkOrdersForCreateContractorBill(workOrder.getWorkOrderNumber());
        if (workOrderNumbers.isEmpty()) {
            resultBinder.rejectValue("", "error.modify.loa.finalbill.exists");
        }
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        Double revisedWorkOrderAmount = Double.valueOf(request.getParameter("revisedWorkOrderAmount"));
        Double revisedValue = Double.valueOf(request.getParameter("revisedValue"));
        Double balanceAmount = 0.0;
        Double grossBillAmount = 0.0;
        DecimalFormat df = new DecimalFormat("0.00");
        grossBillAmount = this.letterOfAcceptanceService.getGrossBillAmountOfBillsCreated(workOrder.getWorkOrderNumber(), "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString());
        if (grossBillAmount == null) {
            grossBillAmount = 0.0;
        }
        BigDecimal ledGrossBillAmount = lineEstimateDetails.getGrossAmountBilled();
        if (revisedWorkOrderAmount >= 0.0 && "-".equals(workOrder.getPercentageSign())) {
            balanceAmount = lineEstimateDetails.getLineEstimate().isSpillOverFlag() ? Double.valueOf(ledGrossBillAmount != null ? workOrder.getWorkOrderAmount() - grossBillAmount - revisedValue - ledGrossBillAmount.doubleValue() : workOrder.getWorkOrderAmount() - grossBillAmount - revisedValue) : Double.valueOf(workOrder.getWorkOrderAmount() - grossBillAmount - revisedValue);
            if (balanceAmount < 0.0) {
                if (lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
                    grossBillAmount = grossBillAmount + lineEstimateDetails.getGrossAmountBilled().doubleValue();
                }
                resultBinder.rejectValue("", "error.modify.loa.appropriation.amount", (Object[])new String[]{df.format(grossBillAmount), df.format(revisedWorkOrderAmount)}, null);
            }
        } else if (revisedWorkOrderAmount >= 0.0 && "+".equals(workOrder.getPercentageSign())) {
            balanceAmount = revisedWorkOrderAmount - workOrder.getWorkOrderAmount();
        }
        if (revisedWorkOrderAmount == 0.0) {
            resultBinder.rejectValue("", "error.modify.loa.agreement.amount");
        }
        if (resultBinder.hasErrors()) {
            model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
            model.addAttribute("mode", (Object)"modify");
            model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
            model.addAttribute("revisedValue", (Object)request.getParameter("revisedValue"));
            return "letterOfAcceptance-modify";
        }
        WorkOrder savedWorkOrder = null;
        try {
            savedWorkOrder = this.letterOfAcceptanceService.update(workOrder, lineEstimateDetails, revisedValue, revisedWorkOrderAmount);
        }
        catch (ValidationException e) {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            budgetheadid.add(lineEstimateDetails.getLineEstimate().getBudgetHead().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.lineEstimateService.getCurrentFinancialYear(new Date()).getId(), Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getExecutingDepartment().getId().toString())), lineEstimateDetails.getLineEstimate().getFunction().getId(), null, lineEstimateDetails.getLineEstimate().getScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getScheme().getId().toString())), lineEstimateDetails.getLineEstimate().getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(lineEstimateDetails.getLineEstimate().getFund().getId().toString())));
                String errorMessage = this.messageSource.getMessage("error.budgetappropriation.amount", (Object[])new String[]{budgetAvailable.toString(), df.format(balanceAmount)}, null);
                model.addAttribute("message", (Object)errorMessage);
            }
            catch (ValidationException v) {
                model.addAttribute("errorMessage", (Object)((ValidationError)v.getErrors().get(0)).getMessage());
            }
            return "lineestimate-success";
        }
        return "redirect:/letterofacceptance/loa-success?loaNumber=" + savedWorkOrder.getWorkOrderNumber() + "&isModify=true";
    }

    private WorkOrder getWorkOrderDocuments(WorkOrder workOrder) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }
}

