/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LineEstimateJsonAdaptor
implements JsonSerializer<LineEstimate> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(LineEstimate lineEstimate, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (lineEstimate != null) {
            if (lineEstimate.getLineEstimateNumber() != null) {
                jsonObject.addProperty("adminSanctionNumber", lineEstimate.getAdminSanctionNumber());
            } else {
                jsonObject.addProperty("adminSanctionNumber", "");
            }
            if (lineEstimate.getLineEstimateNumber() != null) {
                jsonObject.addProperty("lineEstimateNumber", lineEstimate.getLineEstimateNumber());
            } else {
                jsonObject.addProperty("lineEstimateNumber", "");
            }
            if (lineEstimate.getFund() != null) {
                jsonObject.addProperty("fund", lineEstimate.getFund().getName());
            } else {
                jsonObject.addProperty("fund", "");
            }
            if (lineEstimate.getFunction() != null) {
                jsonObject.addProperty("function", lineEstimate.getFunction().getName());
            } else {
                jsonObject.addProperty("function", "");
            }
            if (lineEstimate.getBudgetHead() != null) {
                jsonObject.addProperty("budgetHead", lineEstimate.getBudgetHead().getName());
            } else {
                jsonObject.addProperty("budgetHead", "");
            }
            if (lineEstimate.getExecutingDepartment() != null) {
                jsonObject.addProperty("executingDepartment", lineEstimate.getExecutingDepartment().getName());
            } else {
                jsonObject.addProperty("executingDepartment", "");
            }
            if (lineEstimate.getCreatedBy() != null) {
                jsonObject.addProperty("createdBy", lineEstimate.getCreatedBy().getName());
            } else {
                jsonObject.addProperty("createdBy", "");
            }
            if (lineEstimate.getAdminSanctionBy() != null) {
                jsonObject.addProperty("approvedBy", lineEstimate.getAdminSanctionBy());
            } else {
                jsonObject.addProperty("approvedBy", "");
            }
            if (lineEstimate.getStatus() != null) {
                jsonObject.addProperty("status", lineEstimate.getStatus().getDescription());
            } else {
                jsonObject.addProperty("status", "");
            }
            if (lineEstimate.getState() != null && lineEstimate.getState().getOwnerPosition() != null) {
                jsonObject.addProperty("owner", this.worksUtils.getApproverName(lineEstimate.getState().getOwnerPosition().getId()));
            } else {
                jsonObject.addProperty("owner", "");
            }
            Long totalAmount = 0L;
            for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                totalAmount = totalAmount + led.getEstimateAmount().longValue();
            }
            jsonObject.addProperty("totalAmount", (Number)totalAmount);
            jsonObject.addProperty("id", (Number)lineEstimate.getId());
        }
        return jsonObject;
    }
}

