/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.common.entity.UOM;
import org.egov.infra.persistence.entity.component.Period;
import org.egov.infra.persistence.validator.annotation.Required;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.master.service.ScheduleCategoryService;
import org.egov.works.master.service.ScheduleOfRateService;
import org.egov.works.master.service.UOMService;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.masters.SORRate;
import org.egov.works.models.masters.ScheduleCategory;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
@Results(value={@Result(name={"new"}, location="scheduleOfRate-new.jsp"), @Result(name={"search"}, location="scheduleOfRate-search.jsp"), @Result(name={"edit"}, location="scheduleOfRate-edit.jsp"), @Result(name={"success"}, location="scheduleOfRate-success.jsp"), @Result(name={"view"}, location="scheduleOfRate-view.jsp")})
@ParentPackage(value="egov")
public class ScheduleOfRateAction
extends SearchFormAction {
    private static final long serialVersionUID = -5496042432775969286L;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;
    @Autowired
    private UOMService uomService;
    private ScheduleOfRate scheduleOfRate = new ScheduleOfRate();
    private List<ScheduleOfRate> scheduleOfRateList = null;
    private List<ScheduleCategory> scheduleCategoryList = null;
    private Long id;
    private String mode;
    private String displData;
    @Required(message="sor.category.not.null")
    private Long scheduleCategoryId = -1L;
    private String code;
    private String description;
    private Map<Long, String> deletFlagMap = new HashMap();
    private Map<Long, String> deleteFlagMap2 = new HashMap();
    private String estimateDtFlag = "no";
    private Date estimateDate;
    public static final String flagValue = "yes";
    private List<SORRate> actionRates = new LinkedList();
    private List<MarketRate> actionMarketRates = new LinkedList();
    private List abstractEstimateList = null;
    private List woeList = null;
    private Date woDate;
    private String woDateFlag = "no";
    private List<SORRate> editableRateList = new ArrayList();
    public static final String SEARCH = "search";

    public ScheduleOfRateAction() {
        this.addRelatedEntity("scheduleCategory", ScheduleCategory.class);
        this.addRelatedEntity("uom", UOM.class);
    }

    public String execute() {
        return this.list();
    }

    @Action(value="/masters/scheduleOfRate-newform")
    public String newform() {
        return "new";
    }

    @SkipValidation
    @Action(value="/masters/scheduleOfRate-search")
    public String search() {
        return "search";
    }

    @Action(value="/masters/scheduleOfRate-searchList")
    public String searchList() {
        this.setDisplData("no");
        this.scheduleCategoryList = this.scheduleCategoryService.getAllScheduleCategories();
        return "search";
    }

    public String list() {
        this.scheduleOfRateList = this.scheduleOfRateService.getAllScheduleOfRates();
        return "success";
    }

    @Action(value="/masters/scheduleOfRate-edit")
    public String edit() {
        this.scheduleOfRate = this.scheduleOfRateService.getScheduleOfRateById(this.id);
        if (StringUtils.isNotBlank((CharSequence)this.mode) && this.mode.equalsIgnoreCase("view")) {
            return "view";
        }
        this.getRateDetailsForSORId(false);
        this.getRateDetailsForSORIdForREValidation(false);
        return "edit";
    }

    @Action(value="/masters/scheduleOfRate-save")
    public String save() {
        this.populateRates();
        this.populateMarketRates();
        this.getPersistedRateDetails(this.scheduleOfRate);
        if (this.mode != null && this.mode.equals("edit")) {
            this.getRateDetailsForSORId(true);
            this.getRateDetailsForSORIdForREValidation(true);
        }
        this.scheduleOfRateService.persist((Object)this.scheduleOfRate);
        this.scheduleOfRate = (ScheduleOfRate)this.scheduleOfRateService.findById((Serializable)this.scheduleOfRate.getId(), false);
        this.scheduleOfRateList = new ArrayList();
        this.scheduleOfRateList.add(this.scheduleOfRate);
        if (StringUtils.isBlank((CharSequence)this.mode)) {
            this.addActionMessage(this.getText("sor.save.success"));
        } else {
            this.addActionMessage(this.getText("sor.modified.success", new String[]{this.code}));
        }
        return "success";
    }

    protected void populateRates() {
        for (SORRate rate : this.actionRates) {
            if (!this.validRate(rate)) continue;
            this.scheduleOfRate.addSorRate(rate);
        }
    }

    protected boolean validRate(SORRate rate) {
        return rate != null;
    }

    protected void populateMarketRates() {
        for (MarketRate marketRate : this.actionMarketRates) {
            if (!this.validMarketRate(marketRate)) continue;
            this.scheduleOfRate.addMarketRate(marketRate);
        }
    }

    protected boolean validMarketRate(MarketRate marketRate) {
        return marketRate != null;
    }

    public Object getModel() {
        return this.scheduleOfRate;
    }

    public Collection<ScheduleOfRate> getScheduleOfRateList() {
        return this.scheduleOfRateList;
    }

    public void prepare() {
        if (this.id != null) {
            this.scheduleOfRate = (ScheduleOfRate)this.scheduleOfRateService.findById((Serializable)this.id, false);
        }
        super.prepare();
        this.scheduleCategoryList = this.scheduleCategoryService.getAllScheduleCategories();
        this.addDropdownData("scheduleCategoryList", this.scheduleCategoryList);
        this.addDropdownData("uomlist", this.uomService.getAllUOMs());
    }

    private void getPersistedRateDetails(ScheduleOfRate sor) {
        List rateList = null;
        rateList = this.scheduleOfRate.getSorRates();
        for (SORRate rt : rateList) {
            if (rt.getId() == null) continue;
            this.editableRateList.add(rt);
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public ScheduleOfRate getScheduleOfRate() {
        return this.scheduleOfRate;
    }

    public void setScheduleOfRate(ScheduleOfRate scheduleOfRate) {
        this.scheduleOfRate = scheduleOfRate;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getDisplData() {
        return this.displData;
    }

    public void setDisplData(String displData) {
        this.displData = displData;
    }

    public Long getScheduleCategoryId() {
        return this.scheduleCategoryId;
    }

    public void setScheduleCategoryId(Long scheduleCategoryId) {
        this.scheduleCategoryId = scheduleCategoryId;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Action(value="/masters/scheduleOfRate-searchSorDetails")
    public String searchSorDetails() {
        if (this.scheduleCategoryId == -1L) {
            this.addActionError(this.getText("sor.category.not.null"));
            return "search";
        }
        this.setPageSize(30);
        super.search();
        if (this.searchResult.getFullListSize() == 0) {
            this.setDisplData("noData");
        } else {
            this.setDisplData("yes");
        }
        return "search";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void getRateDetailsForSORId(boolean validationMessageRequired) {
        if (this.scheduleOfRate.getId() != null && validationMessageRequired && !this.editableRateList.isEmpty()) {
            this.iterateRateList(this.editableRateList, validationMessageRequired);
        }
    }

    public void getRateDetailsForSORIdForREValidation(boolean validationMessageFlag) {
        if (this.scheduleOfRate.getId() != null && validationMessageFlag && !this.editableRateList.isEmpty()) {
            this.iterateRateListForRE(this.editableRateList, validationMessageFlag);
        }
    }

    public void iterateRateList(List<SORRate> rateList, boolean validationMessageRequired) {
        this.abstractEstimateList = this.scheduleOfRateService.getAllAbstractEstimateByScheduleOrRateId(this.scheduleOfRate.getId());
        SORRate rate = rateList.get(rateList.size() - 1);
        if (!this.abstractEstimateList.isEmpty()) {
            this.iterateAbstractList(this.abstractEstimateList, rate, validationMessageRequired);
        }
    }

    public void iterateRateListForRE(List<SORRate> rateList, boolean validationMessageFlag) {
        this.woeList = this.scheduleOfRateService.getAllWorkOrderEstimateByScheduleOfRateId(this.scheduleOfRate.getId());
        SORRate rate = rateList.get(rateList.size() - 1);
        if (!this.woeList.isEmpty()) {
            this.iterateWOList(this.woeList, rate, validationMessageFlag);
        }
    }

    public void iterateAbstractList(List abstractEstimateList, SORRate rate, boolean validationMessageRequired) {
        AbstractEstimate abstractEstimate = null;
        HashMap<Integer, String> trackFlagMap = new HashMap<Integer, String>();
        for (int i = 0; i < abstractEstimateList.size(); ++i) {
            String value;
            abstractEstimate = (AbstractEstimate)abstractEstimateList.get(i);
            if (abstractEstimate == null) continue;
            this.estimateDate = abstractEstimate.getEstimateDate();
            if (rate == null) continue;
            Period validity = rate.getValidity();
            Date startDate = validity.getStartDate();
            Date endDate = null;
            if (validity.getEndDate() != null) {
                endDate = validity.getEndDate();
            }
            boolean flag = false;
            if (startDate != null && rate.getId() != null) {
                flag = this.checkGivenDateWithinRange(this.estimateDate, startDate, endDate);
            }
            if (flag) {
                this.deletFlagMap.put(rate.getId(), "yes");
                this.setEstimateDtFlag("yes");
                trackFlagMap.put(0, "yes");
                if (!validationMessageRequired) continue;
                throw new ValidationException(Arrays.asList(new ValidationError("sor.estimateDate.overlap.error", this.getText("sor.estimateDate.overlap.error"))));
            }
            if (trackFlagMap.isEmpty() || (value = (String)trackFlagMap.get(0)) == null || value.equalsIgnoreCase("yes")) continue;
            this.deletFlagMap.put(rate.getId(), "no");
        }
    }

    public void iterateWOList(List woeList, SORRate rate, boolean validationMessageFlag) {
        WorkOrder revisionWO = null;
        WorkOrder parentWO = null;
        WorkOrderEstimate woe = null;
        HashMap<Integer, String> trackFlagMap = new HashMap<Integer, String>();
        for (int i = 0; i < woeList.size(); ++i) {
            String value;
            woe = (WorkOrderEstimate)woeList.get(i);
            revisionWO = woe.getWorkOrder();
            parentWO = revisionWO.getParent();
            if (parentWO == null) continue;
            this.woDate = parentWO.getWorkOrderDate();
            if (rate != null) {
                Period validity = rate.getValidity();
                Date startDate = validity.getStartDate();
                Date endDate = null;
                if (validity.getEndDate() != null) {
                    endDate = validity.getEndDate();
                }
                boolean flag = false;
                if (startDate != null && rate.getId() != null) {
                    flag = this.checkGivenDateWithinRangeWO(this.woDate, startDate, endDate);
                }
                if (!flag) continue;
                this.deleteFlagMap2.put(rate.getId(), "yes");
                this.setWoDateFlag("yes");
                trackFlagMap.put(0, "yes");
                if (!validationMessageFlag) continue;
                this.validateWODate(flag, woeList);
                continue;
            }
            if (trackFlagMap.isEmpty() || (value = (String)trackFlagMap.get(0)) == null || value.equalsIgnoreCase("yes")) continue;
            this.deleteFlagMap2.put(rate.getId(), "no");
        }
    }

    public void validateWODate(boolean flag, List woList) {
        WorkOrderEstimate woe1 = (WorkOrderEstimate)woList.get(0);
        if (flag) {
            if (woList.size() == 1) {
                throw new ValidationException(Arrays.asList(new ValidationError("sor.RE.woDate.overlap", this.getText("sor.RE.woDate.overlap", new String[]{woe1.getEstimate().getEstimateNumber()}))));
            }
            throw new ValidationException(Arrays.asList(new ValidationError("sor.multipleRE.woDate.overlap", this.getText("sor.multipleRE.woDate.overlap"))));
        }
    }

    private static boolean isWithinDateRangeOfEstimateOrWO(Date dateToSearch, Date startdate, Date enddate) {
        return enddate == null ? startdate.before(dateToSearch) : startdate.before(dateToSearch) && dateToSearch.after(enddate);
    }

    public Map<Long, String> getDeletFlagMap() {
        return this.deletFlagMap;
    }

    public void setDeletFlagMap(Map<Long, String> deletFlagMap) {
        this.deletFlagMap = deletFlagMap;
    }

    public String getEstimateDtFlag() {
        return this.estimateDtFlag;
    }

    public void setEstimateDtFlag(String estimateDtFlag) {
        this.estimateDtFlag = estimateDtFlag;
    }

    public Date getEstimateDate() {
        return this.estimateDate;
    }

    public void setEstimateDate(Date estimateDate) {
        this.estimateDate = estimateDate;
    }

    public boolean checkGivenDateWithinRange(Date estimateDate, Date startDate, Date endDate) {
        if (estimateDate == null) {
            return false;
        }
        return ScheduleOfRateAction.isWithinDateRangeOfEstimateOrWO((Date)estimateDate, (Date)startDate, (Date)endDate);
    }

    public boolean checkGivenDateWithinRangeWO(Date woDate, Date startDate, Date endDate) {
        if (woDate == null) {
            return false;
        }
        return ScheduleOfRateAction.isWithinDateRangeOfEstimateOrWO((Date)woDate, (Date)startDate, (Date)endDate);
    }

    public List<SORRate> getActionRates() {
        return this.actionRates;
    }

    public void setActionRates(List<SORRate> actionRates) {
        this.actionRates = actionRates;
    }

    public List<MarketRate> getActionMarketRates() {
        return this.actionMarketRates;
    }

    public void setActionMarketRates(List<MarketRate> actionMarketRates) {
        this.actionMarketRates = actionMarketRates;
    }

    public List getAbstractEstimateList() {
        return this.abstractEstimateList;
    }

    public void setAbstractEstimateList(List abstractEstimateList) {
        this.abstractEstimateList = abstractEstimateList;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        return this.scheduleOfRateService.prepareSearchQuery(this.scheduleCategoryId, this.code, this.description);
    }

    public Map<Long, String> getDeleteFlagMap2() {
        return this.deleteFlagMap2;
    }

    public void setDeleteFlagMap2(Map<Long, String> deleteFlagMap2) {
        this.deleteFlagMap2 = deleteFlagMap2;
    }

    public Date getWoDate() {
        return this.woDate;
    }

    public void setWoDate(Date woDate) {
        this.woDate = woDate;
    }

    public String getWoDateFlag() {
        return this.woDateFlag;
    }

    public void setWoDateFlag(String woDateFlag) {
        this.woDateFlag = woDateFlag;
    }

    public List getWoeList() {
        return this.woeList;
    }

    public void setWoeList(List woeList) {
        this.woeList = woeList;
    }

    public List<SORRate> getEditableRateList() {
        return this.editableRateList;
    }

    public void setEditableRateList(List<SORRate> editableRateList) {
        this.editableRateList = editableRateList;
    }

    public List<ScheduleCategory> getScheduleCategoryList() {
        return this.scheduleCategoryList;
    }

    public void setScheduleCategoryList(List<ScheduleCategory> scheduleCategoryList) {
        this.scheduleCategoryList = scheduleCategoryList;
    }

    public void setScheduleOfRateList(List<ScheduleOfRate> scheduleOfRateList) {
        this.scheduleOfRateList = scheduleOfRateList;
    }
}

