/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.milestone;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.service.MilestoneService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.workorderestimate.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/milestone"})
public class CreateMilestoneController {
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private MilestoneService milestoneService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private EstimateService estimateService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewMilestoneForm(Model model, HttpServletRequest request) throws ApplicationException {
        String estimateNumber = request.getParameter("estimateNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(estimateNumber);
        if (this.milestoneService.checkMilestoneCreated(workOrder.getId())) {
            String message = this.messageSource.getMessage("error.milestonecreated.validate", (Object[])new String[]{workOrder.getWorkOrderNumber()}, null);
            model.addAttribute("errorMessage", (Object)message);
            return "milestone-success";
        }
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(estimateNumber);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("milestone", (Object)new Milestone());
        return "newMilestone-form";
    }

    @RequestMapping(value={"/milestone-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="milestone") Milestone milestone, Model model, BindingResult errors, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException, IOException {
        Long workOrderId = Long.valueOf(request.getParameter("workOrderId"));
        String estimateNumber = request.getParameter("estimateNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(workOrderId);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(estimateNumber);
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(lineEstimateDetails.getEstimateNumber());
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getEstimateByWorkOrderAndEstimateAndStatus(workOrder.getId(), abstractEstimate.getId());
        milestone.setWorkOrderEstimate(workOrderEstimate);
        Milestone newMilestone = this.milestoneService.create(milestone);
        model.addAttribute("milestone", (Object)newMilestone);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.milestone.create.success", (Object[])new String[]{estimateNumber}, null));
        return "milestone-success";
    }
}

