/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.io.IOException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceNumberGenerator;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.master.service.ContractorGradeService;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class CreateLetterOfAcceptanceController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LetterOfAcceptanceNumberGenerator letterOfAcceptanceNumberGenerator;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ContractorGradeService contractorGradeService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, HttpServletRequest request) {
        String estimateNumber = request.getParameter("estimateNumber");
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(estimateNumber);
        this.setDropDownValues(model, lineEstimateDetails);
        workOrder.setWorkOrderDate(new Date());
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
        return "createLetterOfAcceptance-form";
    }

    private void setDropDownValues(Model model, LineEstimateDetails lineEstimateDetails) {
        model.addAttribute("engineerInchargeList", (Object)this.letterOfAcceptanceService.getEngineerInchargeList(lineEstimateDetails.getLineEstimate().getExecutingDepartment().getId(), this.letterOfAcceptanceService.getEngineerInchargeDesignationId()));
    }

    @RequestMapping(value={"/loa-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        WorkOrder existingWorkOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(workOrder.getEstimateNumber());
        if (existingWorkOrder != null) {
            resultBinder.reject("error.loa.exists.for.estimate", (Object[])new String[]{existingWorkOrder.getWorkOrderNumber(), workOrder.getEstimateNumber()}, "error.loa.exists.for.estimate");
        }
        this.validateInput(workOrder, resultBinder);
        if (lineEstimateDetails.getLineEstimate().isSpillOverFlag() && lineEstimateDetails.getLineEstimate().isWorkOrderCreated()) {
            this.validateSpillOverInput(workOrder, resultBinder, lineEstimateDetails);
        }
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model, lineEstimateDetails);
            model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
            model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
            model.addAttribute("contractorSearch", (Object)request.getParameter("contractorSearch"));
            model.addAttribute("contractorCode", (Object)request.getParameter("contractorCode"));
            model.addAttribute("engineerIncharge", (Object)request.getParameter("engineerIncharge"));
            return "createLetterOfAcceptance-form";
        }
        if (lineEstimateDetails.getLineEstimate().isSpillOverFlag() && !lineEstimateDetails.getLineEstimate().isWorkOrderCreated() || !lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            workOrder.setWorkOrderNumber(this.letterOfAcceptanceNumberGenerator.generateLetterOfAcceptanceNumber(lineEstimateDetails.getProjectCode().getCode()));
        }
        WorkOrder savedWorkOrder = this.letterOfAcceptanceService.create(workOrder, files);
        return "redirect:/letterofacceptance/loa-success?loaNumber=" + savedWorkOrder.getWorkOrderNumber();
    }

    @RequestMapping(value={"/loa-success"}, method={RequestMethod.GET})
    public String showLetterOfAcceptanceSuccessPage(@RequestParam(value="loaNumber") String loaNumber, Model model, @RequestParam(value="isModify", required=false) boolean isModify) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderByWorkOrderNumber(loaNumber);
        model.addAttribute("workOrder", (Object)workOrder);
        if (isModify) {
            model.addAttribute("mode", (Object)"modify");
        }
        return "letterofacceptance-success";
    }

    private void validateInput(WorkOrder workOrder, BindingResult resultBinder) {
        if (StringUtils.isBlank((String)workOrder.getFileNumber())) {
            resultBinder.rejectValue("fileNumber", "error.fileno.required");
        }
        if (workOrder.getFileDate() == null) {
            resultBinder.rejectValue("fileDate", "error.filedate.required");
        }
        if (workOrder.getWorkOrderAmount() <= 0.0) {
            resultBinder.rejectValue("workOrderAmount", "error.workorderamount.required");
        }
        if (workOrder.getContractor() == null || workOrder.getContractor().getId() == null) {
            resultBinder.rejectValue("contractor", "error.contractor.required");
        }
        if (workOrder.getContractPeriod() == null || workOrder.getContractPeriod() <= 0) {
            resultBinder.rejectValue("contractPeriod", "error.contractorperiod.required");
        }
        if (workOrder.getDefectLiabilityPeriod() <= 0.0) {
            resultBinder.rejectValue("defectLiabilityPeriod", "error.defectliabilityperiod.required");
        }
        if (workOrder.getEngineerIncharge() == null || workOrder.getEngineerIncharge().getId() == null) {
            resultBinder.rejectValue("engineerIncharge", "error.engineerincharge.required");
        }
    }

    private void validateSpillOverInput(WorkOrder workOrder, BindingResult resultBinder, LineEstimateDetails lineEstimateDetails) {
        WorkOrder wo;
        if (StringUtils.isBlank((String)workOrder.getWorkOrderNumber())) {
            resultBinder.rejectValue("workOrderNumber", "error.workordernumber.required");
        }
        if ((wo = this.letterOfAcceptanceService.getWorkOrderByWorkOrderNumber(workOrder.getWorkOrderNumber())) != null) {
            resultBinder.rejectValue("workOrderNumber", "error.workordernumber.unique");
        }
        if (workOrder.getFileDate().before(lineEstimateDetails.getLineEstimate().getTechnicalSanctionDate())) {
            resultBinder.rejectValue("fileDate", "error.loa.filedate");
        }
        if (workOrder.getWorkOrderDate().before(workOrder.getFileDate())) {
            resultBinder.rejectValue("fileDate", "error.loa.workorderdate");
        }
    }

    @RequestMapping(value={"/contractorsearchform"}, method={RequestMethod.GET})
    public String showSearchContractorForm(@ModelAttribute SearchRequestContractor searchRequestContractor, Model model) throws ApplicationException {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("contractorClasses", (Object)this.contractorGradeService.getAllContractorGrades());
        model.addAttribute("searchRequestContractor", (Object)searchRequestContractor);
        return "contractor-search";
    }
}

