/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/contractorbill"})
public class UpdateContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private MBHeaderService mbHeaderService;

    @ModelAttribute
    public ContractorBillRegister getContractorBillRegister(@PathVariable String contractorBillRegisterId) {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(Long.valueOf(Long.parseLong(contractorBillRegisterId)));
        return contractorBillRegister;
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String updateContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        this.setDropDownValues(model);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        return this.loadViewData(model, request, contractorBillRegister);
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        ContractorBillRegister updatedContractorBillRegister = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.contractorBillRegisterService.getApprovalPositionByMatrixDesignation(contractorBillRegister, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        try {
            if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                this.contractorBillRegisterService.checkBudgetAndGenerateBANumber(contractorBillRegister);
            }
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
            WorkOrder workOrder = contractorBillRegister.getWorkOrder();
            LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
            this.validateInput(contractorBillRegister, lineEstimateDetails, errors, request);
            contractorBillRegister.getEgBilldetailes().clear();
            contractorBillRegister = this.addBillDetails(contractorBillRegister, lineEstimateDetails, errors, request);
            contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
        }
        if (!this.checkForDuplicateAccountCodes(contractorBillRegister)) {
            errors.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
        }
        this.validateTotalDebitAndCreditAmount(contractorBillRegister, errors);
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            return this.loadViewData(model, request, contractorBillRegister);
        }
        if (null != workFlowAction) {
            updatedContractorBillRegister = this.contractorBillRegisterService.updateContractorBillRegister(contractorBillRegister, approvalPosition, approvalComment, null, workFlowAction, mode, files);
        }
        redirectAttributes.addFlashAttribute("contractorBillRegister", updatedContractorBillRegister);
        String pathVars = this.worksUtils.getPathVars(updatedContractorBillRegister.getStatus(), updatedContractorBillRegister.getState(), updatedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + updatedContractorBillRegister.getBillnumber();
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrderAndNotContractorBillRegister(contractorBillRegister.getWorkOrder(), contractorBillRegister.getId());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (lineEstimateDetails.getLineEstimate().isBillsCreated() && lineEstimateDetails.getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(lineEstimateDetails.getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > contractorBillRegister.getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(contractorBillRegister.getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((CharSequence)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((CharSequence)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) < 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
    }

    private void validateTotalDebitAndCreditAmount(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        BigDecimal totalDebitAmount = BigDecimal.ZERO;
        BigDecimal totalCreditAmount = BigDecimal.ZERO;
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
                totalDebitAmount = totalDebitAmount.add(egBilldetails.getDebitamount());
            }
            if (egBilldetails.getCreditamount() == null || BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) == 0) continue;
            totalCreditAmount = totalCreditAmount.add(egBilldetails.getCreditamount());
        }
        if (totalDebitAmount.compareTo(totalCreditAmount) != 0) {
            resultBinder.reject("error.total.debitamount.creditamount.notequal", "error.total.debitamount.creditamount.notequal");
        }
    }

    private boolean checkForDuplicateAccountCodes(ContractorBillRegister contractorBillRegister) {
        HashSet<Long> glCodeIdSet = new HashSet<Long>();
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getGlcodeid() == null) continue;
            if (glCodeIdSet.contains(egBilldetails.getGlcodeid().longValue())) {
                return false;
            }
            glCodeIdSet.add(egBilldetails.getGlcodeid().longValue());
        }
        return true;
    }

    private void setDropDownValues(Model model) {
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
    }

    private String loadViewData(Model model, HttpServletRequest request, ContractorBillRegister contractorBillRegister) {
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        if (contractorBillRegister.getState() != null) {
            model.addAttribute("currentState", (Object)contractorBillRegister.getState().getValue());
        }
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
        if (contractorBillRegister.getState() != null && contractorBillRegister.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        model.addAttribute("billDetailsMap", (Object)this.getBillDetailsMap(contractorBillRegister, model));
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(contractorBillRegister.getState(), contractorBillRegister.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        WorkOrder workOrder = contractorBillRegister.getWorkOrder();
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("workOrder", (Object)workOrder);
        ContractorBillRegister newcontractorBillRegister = this.getContractorBillDocuments(contractorBillRegister);
        model.addAttribute("contractorBillRegister", (Object)newcontractorBillRegister);
        List mbHeaders = this.mbHeaderService.getMBHeadersByContractorBill(newcontractorBillRegister);
        if (mbHeaders != null && !mbHeaders.isEmpty()) {
            newcontractorBillRegister.setMbHeader((MBHeader)mbHeaders.get(0));
        }
        return "contractorBill-update";
    }

    private ContractorBillRegister getContractorBillDocuments(ContractorBillRegister contractorBillRegister) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorBillRegister.getId(), "CONTRACTORBILL");
        contractorBillRegister.setDocumentDetails(documentDetailsList);
        return contractorBillRegister;
    }

    @RequestMapping(value={"/view/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String viewContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        String responsePage = this.loadViewData(model, request, contractorBillRegister);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        model.addAttribute("mode", (Object)"readOnly");
        return responsePage;
    }

    public List<Map<String, Object>> getBillDetailsMap(ContractorBillRegister contractorBillRegister, Model model) {
        ArrayList<Map<String, Object>> billDetailsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> billDetails = new HashMap<String, Object>();
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            CChartOfAccounts coa;
            if (egBilldetails.getDebitamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("id", egBilldetails.getId());
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getDebitamount());
                billDetails.put("isDebit", true);
                billDetails.put("isNetPayable", false);
            } else if (egBilldetails.getCreditamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("id", egBilldetails.getId());
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getCreditamount());
                billDetails.put("isDebit", false);
                if (contractorPayableAccountList != null && !contractorPayableAccountList.isEmpty() && contractorPayableAccountList.contains(coa)) {
                    billDetails.put("isNetPayable", true);
                    model.addAttribute("netPayableAccountId", (Object)egBilldetails.getId());
                    model.addAttribute("netPayableAccountCode", (Object)coa.getId());
                    model.addAttribute("netPayableAmount", (Object)egBilldetails.getCreditamount());
                } else {
                    billDetails.put("isNetPayable", false);
                }
            }
            billDetailsList.add(billDetails);
        }
        return billDetailsList;
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
        }
        String netPayableAccountId = request.getParameter("netPayableAccountId");
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setId(new Integer(netPayableAccountId));
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.getBillDetails(contractorBillRegister, billdetails, lineEstimateDetails, resultBinder, request));
        }
        return contractorBillRegister;
    }

    private EgBilldetails getBillDetails(ContractorBillRegister billregister, EgBilldetails egBilldetails, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        egBilldetails.setFunctionid(new BigDecimal(lineEstimateDetails.getLineEstimate().getFunction().getId()));
        boolean isDebit = false;
        CChartOfAccounts coa = null;
        if (BigDecimal.ZERO.compareTo(egBilldetails.getGlcodeid()) != 0) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
        }
        if (coa != null && coa.getId() != null) {
            egBilldetails.setGlcodeid(BigDecimal.valueOf(coa.getId()));
        }
        if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
            egBilldetails.setDebitamount(egBilldetails.getDebitamount());
            isDebit = true;
        } else if (egBilldetails.getCreditamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) != 0) {
            egBilldetails.setCreditamount(egBilldetails.getCreditamount());
        } else if (!StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode")) && request.getParameter("netPayableAccountCode").toString().equals(egBilldetails.getGlcodeid())) {
            resultBinder.reject("error.contractorbill.accountdetails.amount.required", "error.contractorbill.accountdetails.amount.required");
        }
        egBilldetails.setEgBillregister((EgBillregister)billregister);
        if (coa != null && coa.getGlcode() != null) {
            List detailCode;
            Accountdetailtype projectCodeAccountDetailType = null;
            Accountdetailtype contractorAccountDetailType = null;
            if (isDebit && (projectCodeAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "PROJECTCODE")) == null) {
                resultBinder.reject("error.contractorBill.validate.glcode.for.projectcode.subledger", (Object[])new String[]{coa.getGlcode()}, null);
            }
            if ((detailCode = this.chartOfAccountsHibernateDAO.getAccountdetailtypeListByGLCode(coa.getGlcode())) != null && !detailCode.isEmpty()) {
                if (isDebit) {
                    if (projectCodeAccountDetailType != null) {
                        egBilldetails.addEgBillPayeedetail(this.getEgPayeeDetails(egBilldetails, projectCodeAccountDetailType.getId(), egBilldetails.getDebitamount(), isDebit, Integer.valueOf(lineEstimateDetails.getProjectCode().getId().toString())));
                    }
                } else {
                    contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
                    if (contractorAccountDetailType != null) {
                        egBilldetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(egBilldetails, contractorAccountDetailType.getId(), egBilldetails.getCreditamount(), isDebit, Integer.valueOf(billregister.getWorkOrder().getContractor().getId().toString())));
                    }
                }
                if (projectCodeAccountDetailType == null && contractorAccountDetailType == null) {
                    resultBinder.reject("error.contractorbill.validate.glcode.for.subledger", (Object[])new String[]{coa.getGlcode()}, null);
                }
            }
        }
        egBilldetails.setLastupdatedtime(new Date());
        return egBilldetails;
    }

    private EgBillPayeedetails getEgPayeeDetails(EgBilldetails billDetails, Integer accountsDetailTypeId, BigDecimal amount, boolean isDebit, Integer accountsDetailKeyId) {
        EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
        egBillPaydetail.setAccountDetailKeyId(accountsDetailKeyId);
        egBillPaydetail.setAccountDetailTypeId(accountsDetailTypeId);
        if (isDebit) {
            egBillPaydetail.setDebitAmount(amount);
        } else {
            egBillPaydetail.setCreditAmount(amount);
        }
        egBillPaydetail.setEgBilldetailsId(billDetails);
        egBillPaydetail.setLastUpdatedTime(new Date());
        return egBillPaydetail;
    }
}

