/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBillPayeedetails;
import org.egov.model.bills.EgBilldetails;
import org.egov.model.bills.EgBillregister;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillNumberGenerator;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorderestimate.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/contractorbill"})
public class CreateContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ContractorBillNumberGenerator contractorBillNumberGenerator;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private EstimateService estimateService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showNewForm(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, HttpServletRequest request) {
        String loaNumber = request.getParameter("loaNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(loaNumber);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        this.setDropDownValues(model);
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
        model.addAttribute("mode", (Object)"edit");
        if (!lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            contractorBillRegister.setBilldate(new Date());
        }
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        return "contractorBill-form";
    }

    private void setDropDownValues(Model model) {
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
    }

    @RequestMapping(value={"/contractorbill-save"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, Model model, BindingResult resultBinder, HttpServletRequest request, @RequestParam String workFlowAction, @RequestParam(value="file") MultipartFile[] files) throws IOException {
        Integer partBillCount;
        String loaNumber = request.getParameter("loaNumber");
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(loaNumber);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumberAndStatus(lineEstimateDetails.getEstimateNumber());
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getEstimateByWorkOrderAndEstimateAndStatus(workOrder.getId(), abstractEstimate.getId());
        contractorBillRegister.setWorkOrder(workOrder);
        contractorBillRegister.setWorkOrderEstimate(workOrderEstimate);
        this.validateInput(contractorBillRegister, lineEstimateDetails, resultBinder, request);
        contractorBillRegister = this.addBillDetails(contractorBillRegister, lineEstimateDetails, resultBinder, request);
        if (!this.checkForDuplicateAccountCodes(contractorBillRegister)) {
            resultBinder.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
        }
        this.validateTotalDebitAndCreditAmount(contractorBillRegister, resultBinder);
        if (resultBinder.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
            model.addAttribute("workOrder", (Object)workOrder);
            model.addAttribute("netPayableAmount", (Object)request.getParameter("netPayableAmount"));
            model.addAttribute("netPayableAccountCode", (Object)request.getParameter("netPayableAccountCode"));
            model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            this.prepareWorkflow(model, (StateAware)contractorBillRegister, new WorkflowContainer());
            model.addAttribute("mode", (Object)"edit");
            model.addAttribute("billDetailsMap", (Object)this.getBillDetailsMap(contractorBillRegister));
            return "contractorBill-form";
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if ((partBillCount = this.contractorBillRegisterService.getMaxSequenceNumberByWorkOrder(workOrderEstimate)) == null || partBillCount == 0) {
            partBillCount = 1;
        } else {
            Integer n = partBillCount;
            Integer n2 = partBillCount = Integer.valueOf(partBillCount + 1);
        }
        contractorBillRegister.setBillSequenceNumber(partBillCount);
        contractorBillRegister.setBillnumber(this.contractorBillNumberGenerator.generateContractorBillNumber(contractorBillRegister));
        contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
        ContractorBillRegister savedContractorBillRegister = null;
        try {
            savedContractorBillRegister = this.contractorBillRegisterService.create(contractorBillRegister, lineEstimateDetails, files, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        String pathVars = this.worksUtils.getPathVars(savedContractorBillRegister.getStatus(), savedContractorBillRegister.getState(), savedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + savedContractorBillRegister.getBillnumber();
    }

    @RequestMapping(value={"/contractorbill-success"}, method={RequestMethod.GET})
    public String showContractorBillSuccessPage(@RequestParam(value="billNumber") String billNumber, Model model, HttpServletRequest request) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        Long id = 0L;
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                id = Long.parseLong(keyNameArray[0]);
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (id != null) {
            model.addAttribute("approverName", (Object)approverName);
        }
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillByBillNumber(billNumber);
        String message = this.getMessageByStatus(contractorBillRegister, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        model.addAttribute("contractorBillRegister", (Object)contractorBillRegister);
        return "contractorBill-success";
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        boolean validateBillInWorkflow = this.letterOfAcceptanceService.validateContractorBillInWorkflowForWorkorder(contractorBillRegister.getWorkOrder().getId());
        if (!validateBillInWorkflow) {
            resultBinder.reject("error.contractorbill.in.workflow.for.workorder", (Object[])new String[]{contractorBillRegister.getWorkOrder().getWorkOrderNumber()}, null);
        }
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrder(contractorBillRegister.getWorkOrder());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (lineEstimateDetails.getLineEstimate().isBillsCreated() && lineEstimateDetails.getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(lineEstimateDetails.getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > contractorBillRegister.getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(contractorBillRegister.getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((CharSequence)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((CharSequence)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) < 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().after(contractorBillRegister.getBilldate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.partybilldate.billdate");
        }
        if (lineEstimateDetails.getLineEstimate().isSpillOverFlag()) {
            Date currentDate = new Date();
            Date currentFinYear = this.lineEstimateService.getCurrentFinancialYear(currentDate).getStartingDate();
            if (contractorBillRegister.getBilldate().after(currentDate)) {
                resultBinder.rejectValue("billdate", "error.billdate.futuredate");
            }
            if (contractorBillRegister.getBilldate().before(contractorBillRegister.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("billdate", "error.billdate.workorderdate");
            }
            if (contractorBillRegister.getBilldate().before(currentFinYear)) {
                resultBinder.rejectValue("billdate", "error.billdate.finyear");
            }
        }
    }

    private void validateTotalDebitAndCreditAmount(ContractorBillRegister contractorBillRegister, BindingResult resultBinder) {
        BigDecimal totalDebitAmount = BigDecimal.ZERO;
        BigDecimal totalCreditAmount = BigDecimal.ZERO;
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
                totalDebitAmount = totalDebitAmount.add(egBilldetails.getDebitamount());
            }
            if (egBilldetails.getCreditamount() == null || BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) == 0) continue;
            totalCreditAmount = totalCreditAmount.add(egBilldetails.getCreditamount());
        }
        if (totalDebitAmount.compareTo(totalCreditAmount) != 0) {
            resultBinder.reject("error.total.debitamount.creditamount.notequal", "error.total.debitamount.creditamount.notequal");
        }
    }

    private boolean checkForDuplicateAccountCodes(ContractorBillRegister contractorBillRegister) {
        HashSet<Long> glCodeIdSet = new HashSet<Long>();
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            if (egBilldetails.getGlcodeid() == null) continue;
            if (glCodeIdSet.contains(egBilldetails.getGlcodeid().longValue())) {
                return false;
            }
            glCodeIdSet.add(egBilldetails.getGlcodeid().longValue());
        }
        return true;
    }

    private String getMessageByStatus(ContractorBillRegister contractorBillRegister, String approverName, String nextDesign) {
        String message = "";
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.CREATED.toString())) {
            message = StringUtils.isNotBlank((CharSequence)contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()) ? this.messageSource.getMessage("msg.contractorbill.create.success.with.budgetappropriation", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign, contractorBillRegister.getEgBillregistermis().getBudgetaryAppnumber()}, null) : this.messageSource.getMessage("msg.contractorbill.create.success", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.APPROVED.toString())) {
            message = this.messageSource.getMessage("msg.contractorbill.approved.success", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        } else if (contractorBillRegister.getState().getValue().equals("Rejected")) {
            message = this.messageSource.getMessage("msg.contractorbill.reject", (Object[])new String[]{contractorBillRegister.getBillnumber(), approverName, nextDesign}, null);
        } else if (contractorBillRegister.getState().getValue().equals("Cancelled")) {
            message = this.messageSource.getMessage("msg.contractorbill.cancel", (Object[])new String[]{contractorBillRegister.getBillnumber()}, null);
        }
        return message;
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.getBillDetails(contractorBillRegister, egBilldetails, lineEstimateDetails, resultBinder, request));
        }
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.getBillDetails(contractorBillRegister, billdetails, lineEstimateDetails, resultBinder, request));
        }
        return contractorBillRegister;
    }

    private EgBilldetails getBillDetails(ContractorBillRegister billregister, EgBilldetails egBilldetails, LineEstimateDetails lineEstimateDetails, BindingResult resultBinder, HttpServletRequest request) {
        egBilldetails.setFunctionid(new BigDecimal(lineEstimateDetails.getLineEstimate().getFunction().getId()));
        boolean isDebit = false;
        CChartOfAccounts coa = null;
        if (BigDecimal.ZERO.compareTo(egBilldetails.getGlcodeid()) != 0) {
            coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
        }
        if (coa != null && coa.getId() != null) {
            egBilldetails.setGlcodeid(BigDecimal.valueOf(coa.getId()));
        }
        if (egBilldetails.getDebitamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getDebitamount()) != 0) {
            egBilldetails.setDebitamount(egBilldetails.getDebitamount());
            isDebit = true;
        } else if (egBilldetails.getCreditamount() != null && BigDecimal.ZERO.compareTo(egBilldetails.getCreditamount()) != 0) {
            egBilldetails.setCreditamount(egBilldetails.getCreditamount());
        } else if (!StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode")) && request.getParameter("netPayableAccountCode").toString().equals(egBilldetails.getGlcodeid())) {
            resultBinder.reject("error.contractorbill.accountdetails.amount.required", "error.contractorbill.accountdetails.amount.required");
        }
        egBilldetails.setEgBillregister((EgBillregister)billregister);
        if (coa != null && coa.getGlcode() != null) {
            List detailCode;
            Accountdetailtype projectCodeAccountDetailType = null;
            Accountdetailtype contractorAccountDetailType = null;
            if (isDebit && (projectCodeAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "PROJECTCODE")) == null) {
                resultBinder.reject("error.contractorBill.validate.glcode.for.projectcode.subledger", (Object[])new String[]{coa.getGlcode()}, null);
            }
            if ((detailCode = this.chartOfAccountsHibernateDAO.getAccountdetailtypeListByGLCode(coa.getGlcode())) != null && !detailCode.isEmpty()) {
                if (isDebit) {
                    if (projectCodeAccountDetailType != null) {
                        egBilldetails.addEgBillPayeedetail(this.getEgPayeeDetails(egBilldetails, projectCodeAccountDetailType.getId(), egBilldetails.getDebitamount(), isDebit, Integer.valueOf(lineEstimateDetails.getProjectCode().getId().toString())));
                    }
                } else {
                    contractorAccountDetailType = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coa.getGlcode(), "contractor");
                    if (contractorAccountDetailType != null) {
                        egBilldetails.getEgBillPaydetailes().add(this.getEgPayeeDetails(egBilldetails, contractorAccountDetailType.getId(), egBilldetails.getCreditamount(), isDebit, Integer.valueOf(billregister.getWorkOrder().getContractor().getId().toString())));
                    }
                }
                if (projectCodeAccountDetailType == null && contractorAccountDetailType == null) {
                    resultBinder.reject("error.contractorbill.validate.glcode.for.subledger", (Object[])new String[]{coa.getGlcode()}, null);
                }
            }
        }
        egBilldetails.setLastupdatedtime(new Date());
        return egBilldetails;
    }

    private EgBillPayeedetails getEgPayeeDetails(EgBilldetails billDetails, Integer accountsDetailTypeId, BigDecimal amount, boolean isDebit, Integer accountsDetailKeyId) {
        EgBillPayeedetails egBillPaydetail = new EgBillPayeedetails();
        egBillPaydetail.setAccountDetailKeyId(accountsDetailKeyId);
        egBillPaydetail.setAccountDetailTypeId(accountsDetailTypeId);
        if (isDebit) {
            egBillPaydetail.setDebitAmount(amount);
        } else {
            egBillPaydetail.setCreditAmount(amount);
        }
        egBillPaydetail.setEgBilldetailsId(billDetails);
        egBillPaydetail.setLastUpdatedTime(new Date());
        return egBillPaydetail;
    }

    public List<Map<String, Object>> getBillDetailsMap(ContractorBillRegister contractorBillRegister) {
        ArrayList<Map<String, Object>> billDetailsList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> billDetails = new HashMap<String, Object>();
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        for (EgBilldetails egBilldetails : contractorBillRegister.getEgBilldetailes()) {
            CChartOfAccounts coa;
            if (egBilldetails.getDebitamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getDebitamount());
                billDetails.put("isDebit", true);
                billDetails.put("isNetPayable", false);
            } else if (egBilldetails.getCreditamount() != null) {
                billDetails = new HashMap();
                coa = this.chartOfAccountsHibernateDAO.findById((Number)egBilldetails.getGlcodeid().longValue(), false);
                billDetails.put("glcodeId", coa.getId());
                billDetails.put("glcode", coa.getGlcode());
                billDetails.put("accountHead", coa.getName());
                billDetails.put("amount", egBilldetails.getCreditamount());
                billDetails.put("isDebit", false);
                if (contractorPayableAccountList != null && !contractorPayableAccountList.isEmpty() && contractorPayableAccountList.contains(coa)) {
                    billDetails.put("isNetPayable", true);
                } else {
                    billDetails.put("isNetPayable", false);
                }
            }
            billDetailsList.add(billDetails);
        }
        return billDetailsList;
    }
}

