/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.SearchRequestContractorBill;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.web.adaptor.SearchContractorBillJsonAdaptor;
import org.egov.works.web.adaptor.SearchContractorBillsToCancelJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/contractorbill"})
public class AjaxContractorBillController {
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private SearchContractorBillJsonAdaptor searchContractorBillJsonAdaptor;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private SearchContractorBillsToCancelJsonAdaptor searchContractorBillsToCancelJsonAdaptor;

    @RequestMapping(value={"/ajaxsearch-contractorbill"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchContractorBill(Model model, @ModelAttribute SearchRequestContractorBill searchRequestContractorBill) {
        List searchContractorBillList = this.contractorBillRegisterService.searchContractorBill(searchRequestContractorBill);
        String result = "{ \"data\":" + this.toSearchContractorBillJson((Object)searchContractorBillList) + "}";
        return result;
    }

    public Object toSearchContractorBillJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ContractorBillRegister.class, (Object)this.searchContractorBillJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxworkidentificationnumber-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersForLoa(@RequestParam String code) {
        return this.contractorBillRegisterService.findWorkIdentificationNumbersToSearchContractorBill(code);
    }

    @RequestMapping(value={"/ajaxsearchcontractors-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaContractor(@RequestParam String contractorname) {
        return this.contractorBillRegisterService.getApprovedContractorsForCreateContractorBill(contractorname);
    }

    @RequestMapping(value={"/ajaxdeduction-coa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<CChartOfAccounts> findDetailedAccountCodesByGlcodeLike(@RequestParam String searchQuery) {
        return this.chartOfAccountsHibernateDAO.findDetailedAccountCodesByGlcodeOrNameLike(searchQuery);
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchContractorBillsToCancel(Model model, @ModelAttribute SearchRequestContractorBill searchRequestContractorBill) {
        List searchContractorBillList = this.contractorBillRegisterService.searchContractorBillsToCancel(searchRequestContractorBill);
        String result = "{ \"data\":" + this.toSearchContractorBillsToCancelJson((Object)searchContractorBillList) + "}";
        return result;
    }

    public Object toSearchContractorBillsToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(ContractorBillRegister.class, (Object)this.searchContractorBillsToCancelJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxworkidentificationnumbers-contractorbilltocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersToCancelContractorBill(@RequestParam String code) {
        return this.contractorBillRegisterService.findWorkIdentificationNumbersToSearchContractorBillToCancel(code);
    }

    @RequestMapping(value={"/ajaxbillnumbers-contractorbilltocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findBillNumbersToCancelContractorBill(@RequestParam String billNumber) {
        return this.contractorBillRegisterService.findBillNumbersToSearchContractorBillToCancel(billNumber);
    }
}

