/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LetterOfAcceptanceForMilestoneJSONAdaptor
implements JsonSerializer<WorkOrder> {
    @Autowired
    private LineEstimateService lineEstimateService;

    public JsonElement serialize(WorkOrder workOrder, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrder != null && workOrder.getEstimateNumber() != null) {
            jsonObject.addProperty("estimateNumber", workOrder.getEstimateNumber());
            LineEstimateDetails led = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
            jsonObject.addProperty("typeOfWork", led.getLineEstimate().getTypeOfWork().getDescription());
            if (led.getLineEstimate().getSubTypeOfWork() != null) {
                jsonObject.addProperty("subTypeOfWork", led.getLineEstimate().getSubTypeOfWork().getDescription());
            } else {
                jsonObject.addProperty("subTypeOfWork", "");
            }
            jsonObject.addProperty("estimateDate", led.getLineEstimate().getLineEstimateDate().toString());
            jsonObject.addProperty("nameOfTheWork", led.getNameOfWork());
            jsonObject.addProperty("workIdentificationNumber", led.getProjectCode().getCode());
            jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            jsonObject.addProperty("workOrderAmount", (Number)workOrder.getWorkOrderAmount());
            jsonObject.addProperty("workOrderDate", workOrder.getWorkOrderDate().toString());
            jsonObject.addProperty("id", (Number)workOrder.getId());
        }
        return jsonObject;
    }
}

