/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.mobile;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.services.AbstractEstimateService;

@Result(name="search", location="uploadEstimatePhotos-search.jsp")
public class UploadEstimatePhotosAction
extends BaseFormAction {
    private static final long serialVersionUID = -8691126456751483363L;
    public static final String SEARCH = "search";
    private final String SEARCH_LIST = "searchList";
    private AbstractEstimate abstractEstimate = new AbstractEstimate();
    private String fromDate;
    private String toDate;
    private Integer execDeptId;
    private List<AbstractEstimate> estimateList = new ArrayList();
    private Long estId;
    private AbstractEstimateService abstractEstimateService;
    private String latitude;
    private String longitude;
    private final String UPLOAD = "upload";
    private final String SUCCESS = "success";
    private String successMessage;
    private static final Logger LOGGER = Logger.getLogger(UploadEstimatePhotosAction.class);

    public void prepare() {
        this.addDropdownData("typeList", this.getPersistenceService().findAllBy("from NatureOfWork ", new Object[0]));
        this.addDropdownData("execDeptList", this.getPersistenceService().findAllBy("from Department ", new Object[0]));
    }

    @Action(value="/mobile/uploadEstimatePhotos-newform")
    public String search() {
        return SEARCH;
    }

    public String searchList() {
        StringBuffer query = new StringBuffer();
        query.append(" from AbstractEstimate where id is not null and upper(egwStatus.code) not in ('NEW','CANCELLED') and parent is null ");
        if (StringUtils.isNotBlank((String)this.abstractEstimate.getEstimateNumber())) {
            query.append(" and upper(estimateNumber) like '%" + this.abstractEstimate.getEstimateNumber().toUpperCase() + "%' ");
        }
        if (StringUtils.isNotBlank((String)this.fromDate) && StringUtils.isNotBlank((String)this.toDate)) {
            query.append(" and estimateDate between TO_DATE('" + this.fromDate + "','dd/mm/yyyy') and TO_DATE('" + this.toDate + "','dd/mm/yyyy')");
        } else if (StringUtils.isNotBlank((String)this.fromDate) && StringUtils.isBlank((String)this.toDate)) {
            query.append(" and estimateDate >= TO_DATE('" + this.fromDate + "','dd/mm/yyyy')");
        } else if (StringUtils.isNotBlank((String)this.toDate) && StringUtils.isBlank((String)this.fromDate)) {
            query.append(" and estimateDate <=  TO_DATE('" + this.toDate + "','dd/mm/yyyy')");
        }
        if (this.execDeptId != null && this.execDeptId != -1) {
            query.append(" and executingDepartment.id= " + this.execDeptId);
        }
        if (this.abstractEstimate.getNatureOfWork() != null && this.abstractEstimate.getNatureOfWork().getId() != null && this.abstractEstimate.getNatureOfWork().getId() != -1L) {
            query.append(" and natureOfWork.id= " + this.abstractEstimate.getNatureOfWork().getId());
        }
        query.append(" order by id desc ");
        this.estimateList = this.persistenceService.getSession().createQuery(query.toString()).setMaxResults(100).list();
        return "searchList";
    }

    public String upload() {
        return "upload";
    }

    public String savePhotos() {
        AbstractEstimate ae = (AbstractEstimate)this.abstractEstimateService.find(" from AbstractEstimate where id = ?", new Object[]{this.estId});
        if (this.abstractEstimate != null && this.abstractEstimate.getEstimatePhotographsList() != null && this.abstractEstimate.getEstimatePhotographsList().size() > 0) {
            for (EstimatePhotographs estPic : this.abstractEstimate.getEstimatePhotographsList()) {
                estPic.setLatitude(Double.parseDouble(this.latitude));
                estPic.setLongitude(Double.parseDouble(this.longitude));
                estPic.setDateOfCapture(new Date());
                if (estPic.getFileUpload() == null) continue;
                byte[] bFile = new byte[(int)estPic.getFileUpload().length()];
                try {
                    FileInputStream fileInputStream = new FileInputStream(estPic.getFileUpload());
                    fileInputStream.read(bFile);
                    fileInputStream.close();
                    estPic.setImage(bFile);
                    estPic.setAbstractEstimate(ae);
                }
                catch (IOException e) {
                    LOGGER.error((Object)("Error while uploading file - " + e.getMessage()));
                }
            }
            ae.getEstimatePhotographsList().addAll(this.abstractEstimate.getEstimatePhotographsList());
            this.abstractEstimateService.merge((Object)ae);
            this.successMessage = this.abstractEstimate.getEstimatePhotographsList().size() + " Photo(s) uploaded successfully";
        }
        return "success";
    }

    public Object getModel() {
        return this.abstractEstimate;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public void setFromDate(String fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(String toDate) {
        this.toDate = toDate;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public Integer getExecDeptId() {
        return this.execDeptId;
    }

    public void setExecDeptId(Integer execDeptId) {
        this.execDeptId = execDeptId;
    }

    public Long getEstId() {
        return this.estId;
    }

    public void setEstId(Long estId) {
        this.estId = estId;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public String getLatitude() {
        return this.latitude;
    }

    public String getLongitude() {
        return this.longitude;
    }

    public void setLatitude(String latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(String longitude) {
        this.longitude = longitude;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }
}

