/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.measurementbook;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.EgwStatus;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.measurementbook.ApprovalDetails;
import org.egov.works.models.measurementbook.MBDetails;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.measurementbook.MeasurementBookPDF;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.WorkOrderService;
import org.springframework.beans.factory.annotation.Autowired;

@Result(name="success", type="stream", location="measurementBookPDF", params={"inputName", "measurementBookPDF", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=MeasurementBook.pdf"})
@ParentPackage(value="egov")
public class MeasurementBookPDFAction
extends BaseFormAction {
    private static final long serialVersionUID = 3881748750533287264L;
    private static final Logger logger = Logger.getLogger(MeasurementBookPDFAction.class);
    private Long measurementBookId;
    private InputStream measurementBookPDF;
    private MeasurementBookService measurementBookService;
    private WorkOrderService workOrderService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private ReportService reportService;

    public String execute() {
        if (this.measurementBookId != null) {
            MBHeader mbHeader = this.getMBHeader();
            ReportRequest reportRequest = null;
            reportRequest = this.areNTOrLSItemsPresent(mbHeader) ? new ReportRequest("mbWithRevisionType", (Collection)this.createMbData(mbHeader), this.getParamMap(mbHeader)) : new ReportRequest("measurementBook", (Collection)this.createMbData(mbHeader), this.getParamMap(mbHeader));
            ReportOutput reportOutput = this.reportService.createReport(reportRequest);
            if (reportOutput != null && reportOutput.getReportOutputData() != null) {
                this.measurementBookPDF = new ByteArrayInputStream(reportOutput.getReportOutputData());
            }
        }
        return "success";
    }

    private Map<String, Object> getParamMap(MBHeader mbHeader) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("mbNumber", mbHeader.getMbRefNo());
        reportParams.put("pageNumber", mbHeader.getFromPageNo() + (mbHeader.getToPageNo() == null ? "" : " to " + mbHeader.getToPageNo()));
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        reportParams.put("mbDate", dateFormatter.format(mbHeader.getMbDate()));
        reportParams.put("reportTitle", this.getText("page.title.measurement.book"));
        reportParams.put("approvalDetails", this.createApprovalDetailsTable(mbHeader));
        return reportParams;
    }

    private List<Object> createMbData(MBHeader mbHeader) {
        double uomFactor = 0.0;
        ArrayList<Object> mbPDFList = new ArrayList<Object>();
        for (MBDetails mbDetails : mbHeader.getMbDetails()) {
            MeasurementBookPDF mbPDF = new MeasurementBookPDF();
            String description = "";
            String per = "";
            String schNo = "";
            double currentMeasurement = 0.0;
            currentMeasurement = mbDetails.getQuantity();
            WorkOrderActivity workOrderActivity = mbDetails.getWorkOrderActivity();
            Activity activity = workOrderActivity.getActivity();
            if (activity != null) {
                if (activity.getSchedule() != null && activity.getSchedule().getCode() != null) {
                    schNo = activity.getSchedule().getCode();
                }
                mbPDF.setScheduleNo(schNo);
                if (activity.getSchedule() != null && activity.getSchedule().getDescription() != null) {
                    description = activity.getSchedule().getDescription();
                }
                if (activity.getNonSor() != null && activity.getNonSor().getDescription() != null) {
                    description = activity.getNonSor().getDescription();
                }
                mbPDF.setWorkDescription(description);
                if (activity.getRevisionType() != null && activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.NON_TENDERED_ITEM.toString())) {
                    mbPDF.setRevisionType("Non Tendered");
                }
                if (activity.getRevisionType() != null && activity.getRevisionType().toString().equalsIgnoreCase(RevisionType.LUMP_SUM_ITEM.toString())) {
                    mbPDF.setRevisionType("Lump Sum");
                }
            }
            double completedMeasurement = 0.0;
            double cumlPrevMb = 0.0;
            try {
                long woaId = 0L;
                if (workOrderActivity.getId() != null) {
                    woaId = workOrderActivity.getId();
                }
                cumlPrevMb = this.measurementBookService.prevCumulativeQuantityIncludingCQ(Long.valueOf(woaId), mbHeader.getId(), workOrderActivity.getActivity().getId(), mbHeader.getWorkOrder());
            }
            catch (Exception e) {
                cumlPrevMb = 0.0;
            }
            completedMeasurement = cumlPrevMb + currentMeasurement;
            mbPDF.setCompletedMeasurement(Double.valueOf(completedMeasurement));
            double approveRateWo = 0.0;
            approveRateWo = workOrderActivity.getApprovedRate();
            mbPDF.setUnitRate(Double.valueOf(approveRateWo));
            if (activity != null) {
                uomFactor = workOrderActivity.getConversionFactor();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("----------uomFactor------------" + uomFactor));
                }
                if (activity.getSchedule() != null && activity.getSchedule().getUom() != null && activity.getSchedule().getUom().getUom() != null) {
                    per = activity.getSchedule().getUom().getUom();
                }
                if (activity.getNonSor() != null && activity.getNonSor().getUom() != null && activity.getNonSor().getUom().getUom() != null) {
                    per = activity.getNonSor().getUom().getUom();
                }
                mbPDF.setUom(per);
            }
            double workCompleted = completedMeasurement * approveRateWo * uomFactor;
            mbPDF.setCompletedCost(Double.valueOf(workCompleted));
            Integer frompageNo = null;
            Integer topageNo = null;
            MBHeader resultHeader = this.workOrderService.findLastMBPageNoForLineItem(workOrderActivity, mbHeader.getId());
            if (resultHeader != null) {
                frompageNo = resultHeader.getFromPageNo();
                topageNo = resultHeader.getToPageNo();
            }
            String pageNoInfo = "";
            if (frompageNo != null) {
                pageNoInfo = resultHeader.getMbRefNo() + "/" + frompageNo.toString();
            }
            if (topageNo != null) {
                pageNoInfo = pageNoInfo + "-" + topageNo;
            }
            mbPDF.setPageNo(pageNoInfo);
            mbPDF.setPrevMeasurement(Double.valueOf(cumlPrevMb));
            mbPDF.setCurrentMeasurement(Double.valueOf(currentMeasurement));
            double currentCost = 0.0;
            currentCost = currentMeasurement * approveRateWo * uomFactor;
            mbPDF.setCurrentCost(Double.valueOf(currentCost));
            mbPDFList.add(mbPDF);
        }
        return mbPDFList;
    }

    private boolean areNTOrLSItemsPresent(MBHeader mbHeader) {
        if (mbHeader != null && mbHeader.getMbDetails() != null && mbHeader.getMbDetails().size() > 0) {
            for (MBDetails mbdetails : mbHeader.getMbDetails()) {
                if (mbdetails.getWorkOrderActivity() == null || mbdetails.getWorkOrderActivity().getActivity() == null || mbdetails.getWorkOrderActivity().getActivity().getRevisionType() == null) continue;
                return true;
            }
        }
        return false;
    }

    private List<ApprovalDetails> createApprovalDetailsTable(MBHeader mbHeader) {
        try {
            List history = null;
            String code = "";
            ArrayList<ApprovalDetails> approvalDetList = new ArrayList<ApprovalDetails>();
            if (mbHeader.getCurrentState() != null && mbHeader.getCurrentState().getHistory() != null) {
                history = mbHeader.getStateHistory();
            }
            if (history != null) {
                Collections.reverse(history);
                for (StateHistory state : history) {
                    if (state.getValue().equals("NEW") || state.getValue().equals("END")) continue;
                    ApprovalDetails approvalDet = new ApprovalDetails();
                    String nextAction = "";
                    if (state.getNextAction() != null) {
                        nextAction = state.getNextAction();
                    }
                    Long positionId = null;
                    String desgName = null;
                    DeptDesig deptdesig = null;
                    positionId = state.getOwnerPosition().getId();
                    deptdesig = state.getOwnerPosition().getDeptDesig();
                    desgName = deptdesig.getDesignation().getName();
                    PersonalInformation emp = this.employeeService.getEmpForPositionAndDate(state.getCreatedDate(), Integer.valueOf(Integer.parseInt(positionId.toString())));
                    code = state.getValue();
                    EgwStatus status = (EgwStatus)this.getPersistenceService().find("from EgwStatus where moduletype=? and code=?", new Object[]{"MBHeader", code});
                    String statusDesc = status.getDescription();
                    if (!nextAction.equalsIgnoreCase("")) {
                        statusDesc = status.getDescription() + " - " + nextAction;
                    }
                    approvalDet.setStatusDesc(statusDesc);
                    approvalDet.setEmplName(emp.getEmployeeName());
                    approvalDet.setDesgName(desgName);
                    approvalDet.setDate(state.getCreatedDate());
                    approvalDet.setText(state.getComments());
                    approvalDetList.add(approvalDet);
                }
            }
            return approvalDetList;
        }
        catch (Exception e) {
            return null;
        }
    }

    public MBHeader getMBHeader() {
        return (MBHeader)this.measurementBookService.findById((Serializable)this.measurementBookId, false);
    }

    public InputStream getMeasurementBookPDF() {
        return this.measurementBookPDF;
    }

    public Object getModel() {
        return null;
    }

    public void setMeasurementBookId(Long measurementBookId) {
        this.measurementBookId = measurementBookId;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }
}

