/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.commons.CFunction;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.budget.BudgetGroup;

public class AjaxFinancialDetailAction
extends BaseFormAction {
    private static final long serialVersionUID = 7300734573956975326L;
    private static final Logger logger = Logger.getLogger(AjaxFinancialDetailAction.class);
    private BudgetGroupDAO budgetGroupDAO;
    private static final String SUBSCHEMES = "subschemes";
    private static final String SCHEMES = "schemes";
    private static final String BUDGETGROUPS = "budgetgroups";
    private List<SubScheme> subSchemes;
    private List<Scheme> schemes;
    private List<BudgetGroup> budgetGroups;
    private Integer schemeId;
    private Integer fundId;
    private Long functionId;
    private Date estimateDate;
    private String loadBudgetGroupsValidationError = "";

    public Date getEstimateDate() {
        return this.estimateDate;
    }

    public void setEstimateDate(Date estimateDate) {
        this.estimateDate = estimateDate;
    }

    public String loadSchemes() {
        this.schemes = this.getPersistenceService().findAllBy("from org.egov.commons.Scheme sc where sc.isactive=true and sc.fund.id=? and ? between validfrom and validto", new Object[]{this.fundId, this.estimateDate});
        return SCHEMES;
    }

    public String loadSubSchemes() {
        this.subSchemes = this.getPersistenceService().findAllBy("from org.egov.commons.SubScheme where scheme.id=? and ? between validfrom and validto", new Object[]{this.schemeId, this.estimateDate});
        return SUBSCHEMES;
    }

    public String loadBudgetGroups() {
        try {
            if (this.functionId == -1L) {
                this.budgetGroups = this.budgetGroupDAO.getBudgetGroupList();
            } else {
                CFunction function = (CFunction)this.getPersistenceService().find("from org.egov.commons.CFunction where id = ? ", new Object[]{this.functionId});
                if (function == null) {
                    throw new ValidationException(Arrays.asList(new ValidationError("nobudgetforfunction", "Budget head information not available for the chosen function")));
                }
                this.budgetGroups = this.budgetGroupDAO.getBudgetHeadByFunction(function.getCode());
            }
        }
        catch (ValidationException egovEx) {
            logger.error((Object)("Unable to load budget head information>>>" + egovEx.getMessage()));
            this.budgetGroups = new ArrayList();
            this.addActionError("Unable to load budget head information");
            return BUDGETGROUPS;
        }
        catch (Exception e) {
            logger.error((Object)("Budgetunavailable : Unable to load budget head information>>>" + e.getMessage()));
            this.addFieldError("budgetunavailable", "Unable to load budget head information");
        }
        return BUDGETGROUPS;
    }

    public Integer getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Integer schemeId) {
        this.schemeId = schemeId;
    }

    public Integer getFundId() {
        return this.fundId;
    }

    public void setFundId(Integer fundId) {
        this.fundId = fundId;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public List<SubScheme> getSubSchemes() {
        return this.subSchemes;
    }

    public void setSubSchemes(List<SubScheme> subSchemes) {
        this.subSchemes = subSchemes;
    }

    public List<Scheme> getSchemes() {
        return this.schemes;
    }

    public void setSchemes(List<Scheme> schemes) {
        this.schemes = schemes;
    }

    public List<BudgetGroup> getBudgetGroups() {
        return this.budgetGroups;
    }

    public void setBudgetGroups(List<BudgetGroup> budgetGroups) {
        this.budgetGroups = budgetGroups;
    }

    public void setBudgetGroupDAO(BudgetGroupDAO budgetGroupDAO) {
        this.budgetGroupDAO = budgetGroupDAO;
    }

    public BudgetGroupDAO getBudgetGroupDAO() {
        return this.budgetGroupDAO;
    }

    public Object getModel() {
        return null;
    }

    public String getLoadBudgetGroupsValidationError() {
        return this.loadBudgetGroupsValidationError;
    }

    public void setLoadBudgetGroupsValidationError(String loadBudgetGroupsValidationError) {
        this.loadBudgetGroupsValidationError = loadBudgetGroupsValidationError;
    }
}

