/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.exception.NoSuchObjectException;
import org.egov.egf.commons.EgovCommon;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.entity.component.Money;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.dao.DesignationMasterDAO;
import org.egov.pims.service.EisUtilService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.masters.Overhead;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.WorksService;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name="subcategories", location="ajaxEstimate-subcategories.jsp"), @Result(name="overheads", location="ajaxEstimate-overheads.jsp"), @Result(name="usersInDept", location="ajaxEstimate-usersInDept.jsp")})
public class AjaxEstimateAction
extends BaseFormAction {
    private static final long serialVersionUID = 4566034960012106080L;
    private static final Logger logger = Logger.getLogger(AjaxEstimateAction.class);
    public static final String USERS_IN_DEPT = "usersInDept";
    private static final String DESIGN_FOR_EMP = "designForEmp";
    public static final String SUBCATEGORIES = "subcategories";
    public static final String OVERHEADS = "overheads";
    private static final String WORKFLOW_USER_LIST = "workflowUsers";
    private static final String WORKFLOW_DESIG_LIST = "workflowDesignations";
    private static final String CHANGE_DEPARTMENT = "changeDepartment";
    private static final String ESTIMATE_NUMBER_SEARCH_RESULTS = "estimateNoSearchResults";
    private static final String PROJECT_CODE_SEARCH_RESULTS = "projectCodeSearchResults";
    private static final String DRAFT_ESTIMATE_NUMBER_SEARCH_RESULTS = "draftEstimateNoSearchResults";
    private Long executingDepartment;
    private Long empID;
    @Autowired
    private AssignmentService assignmentService;
    private List usersInExecutingDepartment;
    private Assignment assignment;
    private List subCategories;
    private Long category;
    private boolean isSkipDeptChange;
    private Date estDate;
    private List<Overhead> overheads;
    private List<Overhead> validOverheads;
    private Overhead overhead;
    private String uomVal;
    private Double rate;
    private List workflowUsers;
    private Integer departmentId;
    private Integer designationId;
    private Integer wardId;
    private List workflowKDesigList;
    private String scriptName;
    private String stateName;
    private Long estimateId;
    private WorksService worksService;
    private EisUtilService eisService;
    private AbstractEstimateService abstractEstimateService;
    private Money worktotalValue;
    private String query;
    private String wpNumber = "";
    private boolean isVoucherExists = false;
    private EgovCommon egovCommon;
    private List<String> estimateNumberSearchList = new LinkedList();
    private List<String> projectCodeList = new LinkedList();
    private List<String> draftsEstimateNumberSearchList = new LinkedList();
    private String estimateNum = "";
    private boolean isCancelEstCopyExists = false;
    private Integer approverDepartmentId;
    private List<Object> approverList;
    private String employeeCode;
    private Long estimateTemplateId;
    private String estimateIds;
    private String sorCodes = "";
    private Long woId;
    private String woNumber = "";
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    private List<String> estimateNoList = new LinkedList();
    private BigDecimal estimateAmount;
    @Autowired
    private ScriptService scriptService;

    public String execute() {
        return "success";
    }

    public Object getModel() {
        return null;
    }

    public String designationForUser() {
        try {
            this.assignment = this.assignmentService.getPrimaryAssignmentForEmployee(this.empID);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return DESIGN_FOR_EMP;
    }

    public String searchEstimateNumberForYearendAppr() {
        CFinancialYear currentFinYear = this.financialYearHibernateDAO.getFinancialYearByDate(new Date());
        String strquery = "";
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select ae.estimateNumber from AbstractEstimate ae where ae.projectCode.egwStatus.code!='CLOSED' and ae.depositCode is null and ae.egwStatus.code='ADMIN_SANCTIONED' and ae.estimateNumber like  '%'||?||'%'  and NOT EXISTS (select 'true' from  AbstractEstimateAppropriation aea where aea.abstractEstimate.id=ae.id and aea.budgetUsage.releasedAmount=0 and aea.budgetUsage.financialYearId=?) and NOT EXISTS (select 'true' from MBHeader as mbh left outer join mbh.egBillregister egbr where mbh.workOrderEstimate.estimate.id=ae.id and (egbr.billtype='Final Bill' and egbr.billstatus<>'CANCELLED'))  and NOT EXISTS (select 'true' from MultiyearEstimateApprDetail myea where myea.estimate.id=ae.id and myea.multiyearEstimateAppr.status.code<>'CANCELLED' and myea.multiyearEstimateAppr.financialYear.id=?)  ";
            this.estimateNoList = this.getPersistenceService().findAllBy(strquery, new Object[]{this.query.toUpperCase(), Integer.valueOf(currentFinYear.getId().toString()), currentFinYear.getId()});
        }
        return "estimateNumSearchResults";
    }

    @Action(value="/estimate/ajaxEstimate-usersInExecutingDepartment")
    public String usersInExecutingDepartment() {
        try {
            HashMap<String, String> criteriaParams = new HashMap<String, String>();
            if (this.executingDepartment != null && this.executingDepartment != -1L) {
                criteriaParams.put("departmentId", this.executingDepartment.toString());
            }
            if (StringUtils.isNotBlank((String)this.employeeCode)) {
                criteriaParams.put("code", this.employeeCode);
            }
            if (this.executingDepartment == null || this.executingDepartment == -1L) {
                this.usersInExecutingDepartment = Collections.EMPTY_LIST;
            }
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return USERS_IN_DEPT;
    }

    @Action(value="/estimate/ajaxEstimate-subcategories")
    public String subcategories() {
        this.subCategories = this.getPersistenceService().findAllBy("from EgwTypeOfWork where parentid.id=?", new Object[]{this.category});
        return SUBCATEGORIES;
    }

    public String isSkipDepartmentChange() {
        Department department = null;
        if (this.departmentId != null && this.departmentId != -1) {
            department = (Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.departmentId});
        }
        String departmentCodes = this.worksService.getWorksConfigValue("REAPPROPRIATION_DEPARTMENTS");
        this.isSkipDeptChange = true;
        if (department != null && departmentCodes != null) {
            for (String dept : departmentCodes.split(",")) {
                if (!dept.equals(department.getCode())) continue;
                this.isSkipDeptChange = false;
                break;
            }
        }
        return CHANGE_DEPARTMENT;
    }

    @Action(value="/estimate/ajaxEstimate-overheads")
    public String overheads() {
        this.overheads = this.getPersistenceService().findAllByNamedQuery("OVERHEADS_BY_DATE", new Object[]{this.estDate, this.estDate});
        return OVERHEADS;
    }

    @Action(value="/estimate/ajaxEstimate-getUOMFactor")
    public String getUOMFactor() {
        Integer result = 1;
        Map exceptionaSorMap = this.worksService.getExceptionSOR();
        if (exceptionaSorMap.containsKey(this.uomVal)) {
            result = (Integer)exceptionaSorMap.get(this.uomVal);
        }
        Double finalRate = this.rate / (double)result.intValue();
        String outStr = finalRate.toString();
        this.getServletResponse().setContentType("text/xml");
        this.getServletResponse().setHeader("Cache-Control", "no-cache");
        try {
            this.getServletResponse().getWriter().write(outStr);
        }
        catch (IOException ioex) {
            logger.error((Object)"Error while writing to response --from getByResponseAware()");
        }
        return null;
    }

    public String getWorkFlowUsers() {
        if (this.designationId != -1) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (this.departmentId != null && this.departmentId != -1) {
                paramMap.put("departmentId", this.departmentId.toString());
            }
            if (this.wardId != null && this.wardId != -1) {
                paramMap.put("boundaryId", this.wardId.toString());
            }
            paramMap.put("designationId", this.designationId.toString());
            List roleList = this.worksService.getWorksRoles();
            if (roleList != null) {
                paramMap.put("roleList", roleList);
            }
            this.workflowUsers = this.eisService.getEmployeeInfoList(paramMap);
        }
        return WORKFLOW_USER_LIST;
    }

    public String getPositionByPassingDesigId() {
        if (this.designationId != null && this.designationId != -1) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (this.approverDepartmentId != null && this.approverDepartmentId != -1) {
                paramMap.put("departmentId", this.approverDepartmentId.toString());
            }
            paramMap.put("designationId", this.designationId.toString());
            List roleList = this.worksService.getWorksRoles();
            if (roleList != null) {
                paramMap.put("roleList", roleList);
            }
            this.approverList = new ArrayList();
            List empList = this.eisService.getEmployeeInfoList(paramMap);
            for (Object emp : empList) {
                this.approverList.add(emp);
            }
        }
        return "workFlowApprovers";
    }

    public String getDesgByDeptAndType() {
        this.workflowKDesigList = new ArrayList();
        String departmentName = "";
        Department department = null;
        if (this.departmentId != -1) {
            department = (Department)this.getPersistenceService().find("from Department where id=?", new Object[]{this.departmentId});
            departmentName = department.getName();
        }
        Designation designation = null;
        AbstractEstimate abstractEstimate = null;
        if (this.estimateId != null) {
            abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        }
        ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"state", this.stateName, "department", departmentName, "wfItem", abstractEstimate});
        List list = (List)this.scriptService.executeScript(this.scriptName, scriptContext);
        for (String desgName : list) {
            if (desgName.trim().length() == 0) continue;
            try {
                designation = new DesignationMasterDAO().getDesignationByDesignationName(desgName);
                this.workflowKDesigList.add(designation);
            }
            catch (NoSuchObjectException e) {
                logger.error((Object)e);
            }
        }
        return WORKFLOW_DESIG_LIST;
    }

    public String validateEstimateForCancel() {
        this.woNumber = "";
        if (this.woNumber.equals("")) {
            Long projectCodeId;
            List expenditureDetails;
            this.wpNumber = (String)this.getPersistenceService().find("select wpd.worksPackage.wpNumber from WorksPackageDetails wpd where wpd.estimate.id=? and wpd.estimate.egwStatus.code=? and wpd.worksPackage.egwStatus.code<>?", new Object[]{this.estimateId, AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString(), WorksPackage.WorkPacakgeStatus.CANCELLED.toString()});
            if (this.wpNumber == null) {
                this.wpNumber = "";
            }
            if ((expenditureDetails = this.egovCommon.getExpenditureDetailsforProject(projectCodeId = (Long)this.getPersistenceService().find("select ae.projectCode.id from AbstractEstimate ae where ae.id=?", new Object[]{this.estimateId}), new Date())) != null && !expenditureDetails.isEmpty()) {
                this.isVoucherExists = true;
            }
        }
        return "cancelEstimate";
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(ae.estimateNumber) from AbstractEstimate ae where ae.parent is null and UPPER(ae.estimateNumber) like '%'||?||'%'  and ae.egwStatus.code = ? )";
            params.add(this.query.toUpperCase());
            params.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
            this.estimateNumberSearchList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return ESTIMATE_NUMBER_SEARCH_RESULTS;
    }

    public String searchEstimateNumberForDraftEstimates() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct(ae.estimateNumber) from AbstractEstimate ae where ae.parent is null and UPPER(ae.estimateNumber) like '%'||?||'%'  and ae.egwStatus.code = 'NEW' )";
            params.add(this.query.toUpperCase());
            this.draftsEstimateNumberSearchList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return DRAFT_ESTIMATE_NUMBER_SEARCH_RESULTS;
    }

    public String searchProjectCodes() {
        if (!StringUtils.isEmpty((String)this.query)) {
            String strquery = "";
            ArrayList<String> params = new ArrayList<String>();
            strquery = "select distinct(ae.projectCode.code) from AbstractEstimate ae where ae.parent is null and upper(ae.projectCode.code) like '%'||?||'%' and ae.egwStatus.code=? and ae.projectCode.isActive=1";
            params.add(this.query.toUpperCase());
            params.add(AbstractEstimate.EstimateStatus.ADMIN_SANCTIONED.toString());
            this.projectCodeList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return PROJECT_CODE_SEARCH_RESULTS;
    }

    public String validateCancelledEstForCopy() {
        String estNo = this.estimateNum.substring(0, this.estimateNum.length() - 2);
        String cancelledEst = (String)this.getPersistenceService().find("select est.estimateNumber from AbstractEstimate est where est.estimateNumber= ?", new Object[]{estNo});
        if (cancelledEst != null) {
            this.isCancelEstCopyExists = true;
        }
        return "copyCancelledEst";
    }

    public HttpServletResponse getServletResponse() {
        return ServletActionContext.getResponse();
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List getUsersInExecutingDepartment() {
        return this.usersInExecutingDepartment;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setExecutingDepartment(Long executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public void setCategory(Long category) {
        this.category = category;
    }

    public List getSubCategories() {
        return this.subCategories;
    }

    public List<Overhead> getOverheads() {
        return this.overheads;
    }

    public void setOverheads(List<Overhead> overheads) {
        this.overheads = overheads;
    }

    public Date getEstDate() {
        return this.estDate;
    }

    public void setEstDate(Date estDate) {
        this.estDate = estDate;
    }

    public Overhead getOverhead() {
        return this.overhead;
    }

    public void setOverhead(Overhead overhead) {
        this.overhead = overhead;
    }

    public List<Overhead> getValidOverheads() {
        return this.validOverheads;
    }

    public void setValidOverheads(List<Overhead> validOverheads) {
        this.validOverheads = validOverheads;
    }

    public Long getEmpID() {
        return this.empID;
    }

    public void setEmpID(Long empID) {
        this.empID = empID;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    public String getUomVal() {
        return this.uomVal;
    }

    public void setUomVal(String uomVal) {
        this.uomVal = uomVal;
    }

    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public List getWorkflowUsers() {
        return this.workflowUsers;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public EisUtilService getEisService() {
        return this.eisService;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public List getWorkflowKDesigList() {
        return this.workflowKDesigList;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getStateName() {
        return this.stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public Integer getWardId() {
        return this.wardId;
    }

    public void setWardId(Integer wardId) {
        this.wardId = wardId;
    }

    public Money getWorktotalValue() {
        return this.worktotalValue;
    }

    public void setWorktotalValue(Money worktotalValue) {
        this.worktotalValue = worktotalValue;
    }

    public boolean getIsSkipDeptChange() {
        return this.isSkipDeptChange;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getWpNumber() {
        return this.wpNumber;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public boolean getIsVoucherExists() {
        return this.isVoucherExists;
    }

    public List<String> getEstimateNumberSearchList() {
        return this.estimateNumberSearchList;
    }

    public List<String> getProjectCodeList() {
        return this.projectCodeList;
    }

    public List<String> getDraftsEstimateNumberSearchList() {
        return this.draftsEstimateNumberSearchList;
    }

    public void setDraftsEstimateNumberSearchList(List<String> draftsEstimateNumberSearchList) {
        this.draftsEstimateNumberSearchList = draftsEstimateNumberSearchList;
    }

    public String getEstimateNum() {
        return this.estimateNum;
    }

    public void setEstimateNum(String estimateNum) {
        this.estimateNum = estimateNum;
    }

    public boolean getIsCancelEstCopyExists() {
        return this.isCancelEstCopyExists;
    }

    public Integer getApproverDepartmentId() {
        return this.approverDepartmentId;
    }

    public void setApproverDepartmentId(Integer approverDepartmentId) {
        this.approverDepartmentId = approverDepartmentId;
    }

    public List<? extends Object> getApproverList() {
        return this.approverList;
    }

    public String getEmployeeCode() {
        return this.employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }

    public String getSorCodes() {
        return this.sorCodes;
    }

    public void setSorCodes(String sorCodes) {
        this.sorCodes = sorCodes;
    }

    public Long getEstimateTemplateId() {
        return this.estimateTemplateId;
    }

    public void setEstimateTemplateId(Long estimateTemplateId) {
        this.estimateTemplateId = estimateTemplateId;
    }

    public Long getWoId() {
        return this.woId;
    }

    public void setWoId(Long woId) {
        this.woId = woId;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public String getEstimateIds() {
        return this.estimateIds;
    }

    public void setEstimateIds(String estimateIds) {
        this.estimateIds = estimateIds;
    }

    public String getWoNumber() {
        return this.woNumber;
    }

    public void setWoNumber(String woNumber) {
        this.woNumber = woNumber;
    }

    public List<String> getEstimateNoList() {
        return this.estimateNoList;
    }

    public BigDecimal getEstimateAmount() {
        return this.estimateAmount;
    }

    public void setEstimateAmount(BigDecimal estimateAmount) {
        this.estimateAmount = estimateAmount;
    }
}

