/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractoradvance;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.masters.Contractor;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.hibernate.FlushMode;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name="search", location="searchContractorAdvanceRequisition-search.jsp")
public class SearchContractorAdvanceRequisitionAction
extends SearchFormAction {
    private static final long serialVersionUID = -2101507785101129271L;
    private static final Logger LOGGER = Logger.getLogger(SearchContractorAdvanceRequisitionAction.class);
    public static final String SEARCH = "search";
    private Integer arfStatus;
    private String estimateNumber;
    private Date advanceRequisitionFromDate;
    private Date advanceRequisitionToDate;
    private Long contractorId;
    private String workOrderNumber;
    private Integer executingDepartmentId = -1;
    private Integer drawingOfficerId;
    public static final Locale LOCALE = new Locale("en", "IN");
    public static final SimpleDateFormat DDMMYYYYFORMATS = new SimpleDateFormat("dd/MM/yyyy", LOCALE);
    private WorksService worksService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private PersistenceService<Contractor, Long> contractorService;
    private ContractorAdvanceService contractorAdvanceService;

    public Object getModel() {
        return null;
    }

    public void prepare() {
        super.prepare();
        this.addDropdownData("statusList", this.contractorAdvanceService.getAllContractorAdvanceRequisitionStatus());
        this.addDropdownData("executingDepartmentList", this.departmentService.getAllDepartments());
        List drawingOfficerList = this.contractorAdvanceService.getAllDrawingOfficerFromARF();
        if (drawingOfficerList != null) {
            this.addDropdownData("drawingOfficerList", drawingOfficerList);
        } else {
            this.addDropdownData("drawingOfficerList", Collections.emptyList());
        }
    }

    @Action(value="/contractoradvance/searchContractorAdvanceRequisition-beforeSearch")
    public String beforeSearch() {
        return SEARCH;
    }

    private Map getQuery() {
        StringBuffer query = new StringBuffer(700);
        ArrayList<Object> paramList = new ArrayList<Object>();
        HashMap<String, Object> queryAndParams = new HashMap<String, Object>();
        query.append("from ContractorAdvanceRequisition arf where arf.status.code <> ? ");
        paramList.add(ContractorAdvanceRequisition.ContractorAdvanceRequisitionStatus.NEW.toString());
        if (this.arfStatus != null && this.arfStatus != -1) {
            query.append(" and arf.status.id = ?");
            paramList.add(this.arfStatus);
        }
        if (StringUtils.isNotBlank((String)this.estimateNumber)) {
            query.append(" and UPPER(arf.workOrderEstimate.estimate.estimateNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.estimateNumber).toUpperCase());
        }
        if (this.advanceRequisitionFromDate != null && this.advanceRequisitionToDate != null && this.getFieldErrors().isEmpty()) {
            query.append(" and arf.advanceRequisitionDate between ? and ? ");
            paramList.add(this.advanceRequisitionFromDate);
            paramList.add(this.advanceRequisitionToDate);
        }
        if (this.contractorId != 0L && this.contractorId != -1L) {
            query.append(" and arf.workOrderEstimate.workOrder.contractor.id = ? ");
            paramList.add(this.contractorId);
        }
        if (this.executingDepartmentId != 0 && this.executingDepartmentId != -1) {
            query.append(" and arf.workOrderEstimate.estimate.executingDepartment.id = ? ");
            paramList.add(this.executingDepartmentId);
        }
        if (StringUtils.isNotBlank((String)this.workOrderNumber)) {
            query.append(" and UPPER(arf.workOrderEstimate.workOrder.workOrderNumber) like '%'||?||'%'");
            paramList.add(StringUtils.trim((String)this.workOrderNumber).toUpperCase());
        }
        if (this.drawingOfficerId != null && this.drawingOfficerId != 0 && this.drawingOfficerId != -1) {
            query.append(" and arf.drawingOfficer.id = ?");
            paramList.add(this.drawingOfficerId);
        }
        query.append(" order by arf.advanceRequisitionDate");
        queryAndParams.put("query", query.toString());
        queryAndParams.put("params", paramList);
        return queryAndParams;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        String query = null;
        String countQuery = null;
        Map queryAndParms = null;
        List paramList = new ArrayList();
        queryAndParms = this.getQuery();
        paramList = (List)queryAndParms.get("params");
        query = (String)queryAndParms.get("query");
        countQuery = "select count(distinct arf.id) " + query;
        query = "select distinct arf " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String search() {
        return SEARCH;
    }

    public String searchList() {
        this.getPersistenceService().getSession().setDefaultReadOnly(true);
        this.getPersistenceService().getSession().setFlushMode(FlushMode.MANUAL);
        boolean isError = false;
        if (this.advanceRequisitionFromDate != null && this.advanceRequisitionToDate == null) {
            this.addFieldError("advanceRequisitionToDate", this.getText("search.advanceRequisitionToDate.null"));
            isError = true;
        }
        if (this.advanceRequisitionToDate != null && this.advanceRequisitionFromDate == null) {
            this.addFieldError("startdate", this.getText("search.advanceRequisitionFromDate.null"));
            isError = true;
        }
        if (!DateUtils.compareDates((Date)this.advanceRequisitionToDate, (Date)this.advanceRequisitionFromDate)) {
            this.addFieldError("advanceRequisitionToDate", this.getText("advanceRequisitionFromDate.greaterthan.advanceRequisitionToDate"));
            isError = true;
        }
        if (isError) {
            return SEARCH;
        }
        this.setPageSize(30);
        super.search();
        if (this.searchResult != null && this.searchResult.getList() != null && !this.searchResult.getList().isEmpty()) {
            this.setOwnerName();
        }
        return SEARCH;
    }

    private void setOwnerName() {
        LinkedList<ContractorAdvanceRequisition> arfList = new LinkedList<ContractorAdvanceRequisition>();
        for (Object row : this.searchResult.getList()) {
            ContractorAdvanceRequisition arf = (ContractorAdvanceRequisition)row;
            PersonalInformation emp = this.employeeService.getEmployeeforPosition(arf.getCurrentState().getOwnerPosition());
            if (emp != null) {
                arf.setOwnerName(emp.getUserMaster().getName());
            }
            arfList.add(arf);
        }
        this.searchResult.getList().clear();
        this.searchResult.getList().addAll(arfList);
    }

    public List<String> getActionsList() {
        String actions = this.worksService.getWorksConfigValue("ARF_SHOW_ACTIONS");
        if (actions != null) {
            return Arrays.asList(actions.split(","));
        }
        return new ArrayList<String>();
    }

    public Map<String, Object> getContractorsInARF() {
        LinkedHashMap<String, Object> contractorsInARFList = new LinkedHashMap<String, Object>();
        List contractorList = this.contractorService.findAllByNamedQuery("getAllContractorsInARF", new Object[0]);
        if (contractorList != null) {
            for (Contractor contractor : contractorList) {
                contractorsInARFList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsInARFList;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public Date getAdvanceRequisitionFromDate() {
        return this.advanceRequisitionFromDate;
    }

    public void setAdvanceRequisitionFromDate(Date advanceRequisitionFromDate) {
        this.advanceRequisitionFromDate = advanceRequisitionFromDate;
    }

    public Date getAdvanceRequisitionToDate() {
        return this.advanceRequisitionToDate;
    }

    public void setAdvanceRequisitionToDate(Date advanceRequisitionToDate) {
        this.advanceRequisitionToDate = advanceRequisitionToDate;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public Integer getExecutingDepartmentId() {
        return this.executingDepartmentId;
    }

    public void setExecutingDepartmentId(Integer executingDepartmentId) {
        this.executingDepartmentId = executingDepartmentId;
    }

    public Integer getDrawingOfficerId() {
        return this.drawingOfficerId;
    }

    public void setDrawingOfficerId(Integer drawingOfficerId) {
        this.drawingOfficerId = drawingOfficerId;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public Integer getArfStatus() {
        return this.arfStatus;
    }

    public void setArfStatus(Integer arfStatus) {
        this.arfStatus = arfStatus;
    }

    public void setContractorService(PersistenceService<Contractor, Long> contractorService) {
        this.contractorService = contractorService;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }
}

