/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractorBill;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.measurementbook.MBForCancelledBill;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.web.actions.contractorBill.ContractorBillPDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name="success", type="stream", location="egBillRegisterPDF", params={"inputName", "egBillRegisterPDF", "contentType", "application/pdf", "contentDisposition", "no-cache"})
public class ContractorBillPDFAction
extends BaseFormAction {
    private static final long serialVersionUID = -4416572537527288800L;
    private static final Logger logger = Logger.getLogger(ContractorBillPDFAction.class);
    private Long egbillRegisterId;
    private InputStream egBillRegisterPDF;
    @Autowired
    private EmployeeServiceOld employeeService;
    private ContractorBillService contractorBillService;
    private WorksService worksService;
    private Boundary boundary = null;
    private ContractorAdvanceService contractorAdvanceService;

    public String execute() {
        if (this.egbillRegisterId != null) {
            ContractorBillRegister egBillregister = this.getEgBillregister();
            MBHeader mBHeader = new MBHeader();
            MBForCancelledBill mbCancelBillObj = new MBForCancelledBill();
            if (egBillregister.getBillstatus().equals("CANCELLED")) {
                mbCancelBillObj = (MBForCancelledBill)this.persistenceService.find("from MBForCancelledBill mbHeader where mbHeader.egBillregister.id = ?", new Object[]{this.egbillRegisterId});
                mBHeader = mbCancelBillObj.getMbHeader();
            } else {
                mBHeader = (MBHeader)this.getPersistenceService().find("from MBHeader mbHeader where mbHeader.egBillregister.id = ?", new Object[]{this.egbillRegisterId});
            }
            AbstractEstimate estimate = mBHeader.getWorkOrderEstimate().getEstimate();
            this.boundary = this.getTopLevelBoundary(estimate.getWard());
            Map pdfLabel = this.getPdfReportLabel();
            ByteArrayOutputStream out = new ByteArrayOutputStream(102400);
            ContractorBillPDFGenerator pdfGenerator = new ContractorBillPDFGenerator(egBillregister, mBHeader, (OutputStream)out, pdfLabel, this.contractorBillService);
            pdfGenerator.setPersistenceService(this.getPersistenceService());
            pdfGenerator.setEmployeeService(this.employeeService);
            pdfGenerator.setWorksService(this.worksService);
            pdfGenerator.setContractorAdvanceService(this.contractorAdvanceService);
            try {
                pdfGenerator.generatePDF();
            }
            catch (ApplicationException e) {
                logger.debug((Object)("exception " + (Object)((Object)e)));
            }
            this.egBillRegisterPDF = new ByteArrayInputStream(out.toByteArray());
        }
        return "success";
    }

    private ContractorBillRegister getEgBillregister() {
        return (ContractorBillRegister)this.getPersistenceService().find("from ContractorBillRegister egBillregister where id = ?", new Object[]{this.egbillRegisterId});
    }

    protected Boundary getTopLevelBoundary(Boundary boundary) {
        Boundary b;
        for (b = boundary; b != null && b.getParent() != null; b = b.getParent()) {
        }
        return b;
    }

    public void setEgbillRegisterId(Long egbillRegisterId) {
        this.egbillRegisterId = egbillRegisterId;
    }

    public InputStream getEgBillRegisterPDF() {
        return this.egBillRegisterPDF;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public Map<String, String> getPdfReportLabel() {
        HashMap<String, String> pdfLabel = new HashMap<String, String>();
        pdfLabel.put("contractorbill.pdf.leftheader", "Form No.CON 51");
        pdfLabel.put("contractorbill.pdf.mainheader", this.boundary == null ? "" : this.boundary.getName() + "\n   Contractor Bill");
        pdfLabel.put("contractorbill.pdf.rightheader", "User Department: ");
        pdfLabel.put("contractorbill.pdf.contractoraddress", "Contractor Name and Address:- ");
        pdfLabel.put("contractorbill.pdf.billno", "Bill number: ");
        pdfLabel.put("contractorbill.pdf.dateofbill", "Date of Bill Creation: ");
        pdfLabel.put("contractorbill.pdf.typeofbill", "Part / Final Bill: ");
        pdfLabel.put("contractorbill.pdf.workdescription", "Work Description: ");
        pdfLabel.put("contractorbill.pdf.workcommencedon", "Work Commenced on: ");
        pdfLabel.put("contractorbill.pdf.workcompleteon", "Work Completed on: ");
        pdfLabel.put("contractorbill.pdf.projectcode", "Project Code");
        pdfLabel.put("contractorbill.pdf.assetcode", "Asset Code and Description");
        pdfLabel.put("contractorbill.pdf.Mbno", "M Book \n No");
        pdfLabel.put("contractorbill.pdf.pages", "Pages");
        pdfLabel.put("contractorbill.pdf.from", "From");
        pdfLabel.put("contractorbill.pdf.to", "To");
        pdfLabel.put("contractorbill.pdf.estimateno", "Estimate Number: ");
        pdfLabel.put("contractorbill.pdf.estimateamt", "Estimate Amount: ");
        pdfLabel.put("contractorbill.pdf.todate", "To Date ");
        pdfLabel.put("contractorbill.pdf.lastbill", "Since Last Bill ");
        pdfLabel.put("contractorbill.pdf.valueofworkdone", "Value of Work Done ");
        pdfLabel.put("contractorbill.pdf.netamount", "Net amount payable (Rupees (in words)) ");
        pdfLabel.put("contractorbill.pdf.preparedby", "Approved By:");
        pdfLabel.put("contractorbill.pdf.checkedby", "Checked By:");
        pdfLabel.put("contractorbill.pdf.approvaldetails", "Approval Details");
        pdfLabel.put("contractorbill.pdf.aprvalstep", "Approval Step");
        pdfLabel.put("contractorbill.pdf.name", "Name");
        pdfLabel.put("contractorbill.pdf.designation", "Designation");
        pdfLabel.put("contractorbill.pdf.aprvdon", "Approved On");
        pdfLabel.put("contractorbill.pdf.remarks", "Remarks");
        pdfLabel.put("contractorbill.pdf.deductions", "Deductions");
        pdfLabel.put("contractorbill.pdf.contractorbill", "CONTRACTOR BILL");
        pdfLabel.put("contractorbill.pdf.certificate", "CERTIFICATE");
        pdfLabel.put("contractorbill.pdf.certificatecontent1", "1. Certified that the claim is correct, that necessary measurments have been made by me on \n_________________________________ and the work has been satisfactorily performed vide pages \n__________________________________ Measurement Book No.  __________________________________");
        pdfLabel.put("contractorbill.pdf.juniorengineer", "Junior Engineer");
        pdfLabel.put("contractorbill.pdf.date", "Date");
        pdfLabel.put("contractorbill.pdf.certificatecontent2", "2. Certified that the work was / materials were duly check measured by me \non _______________________________\n");
        pdfLabel.put("contractorbill.pdf.certificatecontent3", "3. Certified that the work has been completed, in accordance with the plan and estimate in a \nsubstantial and satisfactory manner");
        pdfLabel.put("contractorbill.pdf.certificatecontent4", "4. Certified that the contractor has employed Technical Assistant as required in the Agreement");
        pdfLabel.put("contractorbill.pdf.certificatecontent5", "5. Certified that the debris has been removed and that the carriage way work and water table has completed");
        pdfLabel.put("contractorbill.pdf.certificatecontent6", "The Certificate mentioned against Sl.No. _________________________________________ are \napplicable to this bill and the certificates mentioned against Sl.No._________________________________________________ \n_______________________________  are deleted");
        pdfLabel.put("contractorbill.pdf.exeasstengineer", "Exe. Engineer /Asst. Exe. Engineer");
        return pdfLabel;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Object getModel() {
        return null;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }
}

