/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.uploadsor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.egov.common.entity.UOM;
import org.egov.commons.service.UOMService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.master.service.ScheduleCategoryService;
import org.egov.works.master.service.ScheduleOfRateService;
import org.egov.works.master.service.UploadSORService;
import org.egov.works.models.masters.ScheduleCategory;
import org.egov.works.models.masters.ScheduleOfRate;
import org.egov.works.uploadsor.UploadSOR;
import org.egov.works.uploadsor.UploadScheduleOfRate;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/uploadsor"})
public class UploadSORController {
    private boolean errorInMasterData = false;
    private String originalFileStoreId;
    private String outPutFileStoreId;
    private String loadSorRateOriginalFileName;
    private File inputFile;
    private String timeStamp;
    @Autowired
    private ScheduleOfRateService scheduleOfRateService;
    @Autowired
    private ScheduleCategoryService scheduleCategoryService;
    @Autowired
    private UOMService uomService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    protected FileStoreService fileStoreService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    protected UploadSORService uploadSORService;

    @RequestMapping(value={"/common-form"}, method={RequestMethod.GET})
    public String showCommonForm(@ModelAttribute(value="uploadSORRates") UploadSOR uploadSOR, Model model) throws ApplicationException {
        return "uploadSor";
    }

    @RequestMapping(value={"/form"}, method={RequestMethod.GET})
    public String showForm(@ModelAttribute(value="uploadSORRates") UploadSOR uploadSOR, Model model) throws ApplicationException {
        model.addAttribute("originalFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_original"));
        model.addAttribute("outPutFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_output"));
        return "uploadSor-form";
    }

    @RequestMapping(value={"/form"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="uploadSOR") UploadSOR uploadSOR, RedirectAttributes redirectAttributes, Model model, BindingResult errors) throws ApplicationException, IOException {
        try {
            File convFile;
            this.errorInMasterData = false;
            this.inputFile = convFile = new File(uploadSOR.getFile().getOriginalFilename());
            uploadSOR.getFile().transferTo(convFile);
            FileInputStream inputFile = new FileInputStream(convFile);
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)inputFile);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            wb.getNumberOfSheets();
            this.timeStamp = new Timestamp(new Date().getTime()).toString().replace(".", "_");
            HSSFSheet sheet = wb.getSheetAt(0);
            List uploadSORRatesList = this.uploadSORService.loadToList(sheet);
            this.validateDuplicateData(uploadSORRatesList);
            uploadSORRatesList = this.uploadSORService.removeEmptyRows(uploadSORRatesList);
            this.validateMandatoryFeilds(uploadSORRatesList);
            this.loadSorRateOriginalFileName = this.uploadSORService.prepareOriginalFileName("sor_original", "sor_output", this.timeStamp, uploadSOR.getFile().getOriginalFilename(), errors);
            FileStoreMapper originalFileStore = this.fileStoreService.store(uploadSOR.getFile().getInputStream(), this.loadSorRateOriginalFileName, uploadSOR.getFile().getContentType(), "WMS");
            this.persistenceService.persist((Object)originalFileStore);
            this.originalFileStoreId = originalFileStore.getFileStoreId();
            if (this.errorInMasterData) {
                inputFile.close();
                this.outPutFileStoreId = this.uploadSORService.prepareOutPutFileWithErrors("sor_original", "sor_output", this.inputFile, uploadSORRatesList, uploadSOR, errors);
                errors.reject("error.while.validating.data", "error.while.validating.data");
                model.addAttribute("originalFileStoreId", (Object)this.originalFileStoreId);
                model.addAttribute("outPutFileStoreId", (Object)this.outPutFileStoreId);
                return "uploadSor-result";
            }
            uploadSORRatesList = this.scheduleOfRateService.createScheduleOfRate(uploadSORRatesList);
            inputFile.close();
            this.outPutFileStoreId = this.uploadSORService.prepareOutPutFileWithFinalStatus("sor_original", "sor_output", this.inputFile, uploadSORRatesList, uploadSOR, errors);
            model.addAttribute("message", (Object)this.messageSource.getMessage("msg.load.sor.rates.sucessful", null, null));
        }
        catch (ValidationException e) {
            model.addAttribute("originalFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_original"));
            model.addAttribute("outPutFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_output"));
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            model.addAttribute("originalFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_original"));
            model.addAttribute("outPutFiles", (Object)this.worksUtils.getLatestSorRateUploadFiles("sor_output"));
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
        model.addAttribute("originalFileStoreId", (Object)this.originalFileStoreId);
        model.addAttribute("outPutFileStoreId", (Object)this.outPutFileStoreId);
        return "uploadSor-result";
    }

    private void validateMandatoryFeilds(List<UploadScheduleOfRate> uploadSORRatesList) {
        ArrayList<UploadScheduleOfRate> tempList = new ArrayList<UploadScheduleOfRate>();
        try {
            String error = "";
            HashMap<String, ScheduleOfRate> sorMap = new HashMap<String, ScheduleOfRate>();
            HashMap<String, ScheduleCategory> sorCategoryMap = new HashMap<String, ScheduleCategory>();
            HashMap<String, UOM> uomMap = new HashMap<String, UOM>();
            List sorList = this.scheduleOfRateService.getAllScheduleOfRates();
            List sorCategoryList = this.scheduleCategoryService.getAllScheduleCategories();
            List uomList = this.uomService.findAll();
            for (ScheduleOfRate sor : sorList) {
                sorMap.put(sor.getCode().toLowerCase(), sor);
            }
            for (ScheduleCategory scheduleCategory : sorCategoryList) {
                sorCategoryMap.put(scheduleCategory.getCode().toLowerCase(), scheduleCategory);
            }
            for (UOM uom : uomList) {
                uomMap.put(uom.getUom().toLowerCase(), uom);
            }
            for (UploadScheduleOfRate obj : uploadSORRatesList) {
                error = "";
                if (obj.getSorCode() != null && !obj.getSorCode().equalsIgnoreCase("")) {
                    if (sorMap.get(obj.getSorCode().toLowerCase()) == null) {
                        if (this.uploadSORService.isContainsWhitespace(obj.getSorCode()).booleanValue()) {
                            error = error + " " + this.messageSource.getMessage("error.whitespace.is.not.allowed.in.sorcode", null, null);
                        }
                    } else {
                        obj.setScheduleOfRate((ScheduleOfRate)sorMap.get(obj.getSorCode().toLowerCase()));
                    }
                } else {
                    error = error + " " + this.messageSource.getMessage("error.sorcode.is.required", null, null) + ",";
                }
                if (obj.getSorCode() != null && obj.getSorCode().length() > 255) {
                    error = error + " " + this.messageSource.getMessage("error.sor.code.length", null, null) + ",";
                }
                if (obj.getSorCategoryCode() == null || obj.getSorCategoryCode().equalsIgnoreCase("")) {
                    error = error + " " + this.messageSource.getMessage("error.schedulecategory.code.is.required", null, null) + ",";
                } else if (obj.getSorCategoryCode() != null && !obj.getSorCategoryCode().equalsIgnoreCase("") && sorCategoryMap.get(obj.getSorCategoryCode().toLowerCase()) == null) {
                    error = error + " " + this.messageSource.getMessage("error.schedulecategory.is.not.exist", null, null) + obj.getSorCategoryCode() + ",";
                } else {
                    obj.setScheduleCategory((ScheduleCategory)sorCategoryMap.get(obj.getSorCategoryCode().toLowerCase()));
                }
                if (obj.getSorDescription() == null || obj.getSorDescription().equalsIgnoreCase("")) {
                    error = error + " " + this.messageSource.getMessage("error.sordescription.is.required", null, null) + ",";
                }
                if (this.uploadSORService.isSpecialCharacterExist(obj.getSorDescription()) || this.uploadSORService.isNewLineOrTabExist(obj.getSorDescription()).booleanValue()) {
                    error = error + " " + this.messageSource.getMessage("error.special.characters.is.not.allowed.in.sor.description", null, null) + ",";
                }
                if (obj.getSorDescription() != null && obj.getSorDescription().length() > 4000) {
                    error = error + " " + this.messageSource.getMessage("error.sor.description.length", null, null) + ",";
                }
                if (obj.getUomCode() == null || obj.getUomCode().equalsIgnoreCase("")) {
                    error = error + " " + this.messageSource.getMessage("error.uom.is.required", null, null) + ",";
                } else if (obj.getUomCode() != null && !obj.getUomCode().equalsIgnoreCase("") && uomMap.get(obj.getUomCode().toLowerCase()) == null) {
                    error = error + " " + this.messageSource.getMessage("error.uom.is.not.exist", null, null) + obj.getUomCode() + ",";
                } else {
                    obj.setUom((UOM)uomMap.get(obj.getUomCode().toLowerCase()));
                }
                if (obj.getRate() == null) {
                    error = error + " " + this.messageSource.getMessage("error.rate.is.required", null, null) + ",";
                } else if (obj.getRate().compareTo(BigDecimal.ZERO) == -1 || obj.getRate().compareTo(BigDecimal.ZERO) == 0) {
                    error = error + " " + this.messageSource.getMessage("error.negative.values.not.allowed.in.rate", null, null) + obj.getRate() + ",";
                } else if (!obj.getRate().toString().matches("[0-9]+([,.][0-9]{1,2})?")) {
                    error = error + " " + this.messageSource.getMessage("error.more.then.two.decimal.places.not.allowed.rate", null, null) + obj.getRate() + ",";
                }
                if (obj.getFromDate() == null) {
                    error = error + " " + this.messageSource.getMessage("error.fromdate.is.required", null, null) + ",";
                }
                if (obj.getFromDate() != null && obj.getToDate() != null && obj.getFromDate().compareTo(obj.getToDate()) > 0) {
                    error = error + " " + this.messageSource.getMessage("error.fromdate.cannot.be.grater.then.todate", null, null) + ",";
                }
                if (obj.getScheduleOfRate() != null && obj.getScheduleCategory() != null && obj.getScheduleOfRate().getScheduleCategory().getCode().equalsIgnoreCase(obj.getScheduleCategory().getCode())) {
                    error = error + " " + this.messageSource.getMessage("error.sorcode.already.exists", null, null) + ",";
                }
                obj.setErrorReason(obj.getErrorReason() != null ? obj.getErrorReason() : "" + error);
                if (!error.equalsIgnoreCase("")) {
                    this.errorInMasterData = true;
                }
                tempList.add(obj);
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }

    private void validateDuplicateData(List<UploadScheduleOfRate> uploadSORRatesList) {
        try {
            HashMap<String, UploadScheduleOfRate> uploadSORRateMap = new HashMap<String, UploadScheduleOfRate>();
            for (UploadScheduleOfRate obj : uploadSORRatesList) {
                if (obj.getSorCode() != null && obj.getSorCategoryCode() != null && !obj.getSorCode().equalsIgnoreCase("") && !obj.getSorCategoryCode().equalsIgnoreCase("")) {
                    if (uploadSORRateMap.get(obj.getSorCode() + "-" + obj.getSorCategoryCode()) == null) {
                        uploadSORRateMap.put(obj.getSorCode() + "-" + obj.getSorCategoryCode(), obj);
                        continue;
                    }
                    obj.setErrorReason(obj.getErrorReason() != null ? obj.getErrorReason() : "" + this.messageSource.getMessage("error.duplicate.record", null, null));
                    this.errorInMasterData = true;
                    continue;
                }
                if (obj.getSorCode() != null && !obj.getSorCode().equalsIgnoreCase("") || obj.getSorCategoryCode() != null && !obj.getSorCategoryCode().equalsIgnoreCase("") || obj.getSorDescription() != null && !obj.getSorDescription().equalsIgnoreCase("") || obj.getUomCode() != null && !obj.getUomCode().equalsIgnoreCase("") || obj.getRate() != null || obj.getFromDate() != null || obj.getToDate() != null || obj.getMarketRate() != null || obj.getMarketFromDate() != null || obj.getMarketToDate() != null) continue;
                obj.setErrorReason(this.messageSource.getMessage("error.empty.record", null, null));
            }
        }
        catch (ValidationException e) {
            throw new ValidationException(Arrays.asList(new ValidationError(((ValidationError)e.getErrors().get(0)).getMessage(), ((ValidationError)e.getErrors().get(0)).getMessage())));
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError(e.getMessage(), e.getMessage())));
        }
    }
}

