/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateAppropriation;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateAppropriationService;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class CreateRevisionEstimateController
extends GenericWorkFlowController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private LineEstimateAppropriationService lineEstimateAppropriationService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showForm(@ModelAttribute(value="revisionEstimate") RevisionAbstractEstimate revisionEstimate, @RequestParam Long workOrderEstimateId, Model model) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        revisionEstimate.setParent(workOrderEstimate.getEstimate());
        this.revisionEstimateService.loadViewData(revisionEstimate, workOrderEstimate, model);
        WorkflowContainer workflowContainer = new WorkflowContainer();
        this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
        ArrayList<String> validActions = new ArrayList<String>();
        validActions.add("Save");
        validActions.add(WorksConstants.FORWARD_ACTION.toString());
        if (revisionEstimate.getState() != null && revisionEstimate.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)revisionEstimate.getState().getNextAction());
        }
        model.addAttribute("validActionList", validActions);
        model.addAttribute("mode", null);
        return "revisionEstimate-form";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String save(@ModelAttribute RevisionAbstractEstimate revisionEstimate, RedirectAttributes redirectAttributes, Model model, BindingResult bindErrors, HttpServletRequest request, @RequestParam String workFlowAction) {
        RevisionAbstractEstimate savedRevisionEstimate;
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        JsonObject jsonObject = new JsonObject();
        this.revisionEstimateService.validateREInDrafts(workOrderEstimate.getEstimate().getId(), jsonObject, bindErrors);
        this.revisionEstimateService.validateREInWorkFlow(workOrderEstimate.getEstimate().getId(), jsonObject, bindErrors);
        this.revisionEstimateService.validateChangeQuantityActivities(revisionEstimate, bindErrors);
        if (bindErrors.hasErrors()) {
            this.revisionEstimateService.loadViewData(revisionEstimate, workOrderEstimate, model);
            WorkflowContainer workflowContainer = new WorkflowContainer();
            this.prepareWorkflow(model, (StateAware)revisionEstimate, workflowContainer);
            ArrayList<String> validActions = new ArrayList<String>();
            validActions.add("Save");
            validActions.add(WorksConstants.FORWARD_ACTION.toString());
            if (revisionEstimate.getState() != null && revisionEstimate.getState().getNextAction() != null) {
                model.addAttribute("nextAction", (Object)revisionEstimate.getState().getNextAction());
            }
            model.addAttribute("validActionList", validActions);
            model.addAttribute("mode", null);
            model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
            model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("approvedByValue", (Object)request.getParameter("approvedBy"));
            return "revisionEstimate-form";
        }
        if (revisionEstimate.getState() == null) {
            if (WorksConstants.FORWARD_ACTION.equals(workFlowAction)) {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.CREATED.toString()));
            } else {
                revisionEstimate.setEgwStatus(this.worksUtils.getStatusByModuleAndCode("RevisionAbstractEstimate", AbstractEstimate.EstimateStatus.NEW.toString()));
            }
        }
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.validateBudgetAmount(revisionEstimate.getParent().getLineEstimateDetails().getLineEstimate(), bindErrors);
        }
        try {
            savedRevisionEstimate = this.revisionEstimateService.createRevisionEstimate(revisionEstimate, approvalPosition, approvalComment, null, workFlowAction);
        }
        catch (ValidationException e) {
            String errorMessage = this.messageSource.getMessage("error.budgetappropriation.insufficient.amount", (Object[])new String[0], null);
            model.addAttribute("message", (Object)errorMessage);
            return "revisionEstimate-success";
        }
        if (AbstractEstimate.EstimateStatus.NEW.toString().equals(savedRevisionEstimate.getEgwStatus().getCode())) {
            return "redirect:/revisionestimate/update/" + savedRevisionEstimate.getId() + "?mode=save";
        }
        return "redirect:/revisionestimate/revisionestimate-success?revisionEstimate=" + savedRevisionEstimate.getId() + "&approvalPosition=" + approvalPosition;
    }

    private void validateBudgetAmount(LineEstimate lineEstimate, BindingResult errors) {
        block4: {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            budgetheadid.add(lineEstimate.getBudgetHead().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(lineEstimate.getExecutingDepartment().getId().toString())), lineEstimate.getFunction().getId(), null, lineEstimate.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getScheme().getId().toString())), lineEstimate.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(lineEstimate.getFund().getId().toString())));
                BigDecimal totalEstimateAmount = BigDecimal.ZERO;
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    totalEstimateAmount = led.getEstimateAmount().add(totalEstimateAmount);
                }
                if (BudgetControlType.BudgetCheckOption.MANDATORY.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && budgetAvailable.compareTo(totalEstimateAmount) == -1) {
                    errors.reject("error.budgetappropriation.insufficient.amount", null);
                }
            }
            catch (ValidationException e) {
                Iterator iterator = e.getErrors().iterator();
                if (!iterator.hasNext()) break block4;
                ValidationError error = (ValidationError)iterator.next();
                throw new ApplicationRuntimeException(error.getKey());
            }
        }
    }

    @RequestMapping(value={"/revisionestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute RevisionAbstractEstimate revisionEstimate, @RequestParam(value="revisionEstimate") Long id, @RequestParam(value="approvalPosition") Long approvalPosition, HttpServletRequest request, Model model) {
        if (id != null) {
            revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(id);
        }
        String pathVars = this.worksUtils.getPathVars(revisionEstimate.getEgwStatus(), revisionEstimate.getState(), revisionEstimate.getId(), approvalPosition);
        String[] keyNameArray = pathVars.split(",");
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1 && keyNameArray[0] != null) {
                id = Long.parseLong(keyNameArray[0]);
            } else if (keyNameArray.length == 3) {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                if (keyNameArray[0] != null) {
                    id = Long.parseLong(keyNameArray[0]);
                }
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        String message = this.getMessageByStatus(revisionEstimate, approverName, nextDesign);
        model.addAttribute("message", (Object)message);
        if (RevisionAbstractEstimate.RevisionEstimateStatus.BUDGET_SANCTIONED.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            LineEstimateAppropriation lea = this.lineEstimateAppropriationService.findLatestByLineEstimateDetails_EstimateNumber(revisionEstimate.getParent().getEstimateNumber());
            model.addAttribute("basMessage", (Object)this.messageSource.getMessage("msg.revisionestimate.budgetsanction.success", (Object[])new String[]{revisionEstimate.getEstimateNumber(), lea.getBudgetUsage().getAppropriationnumber()}, null));
        }
        return new ModelAndView("revisionEstimate-success", "revisionEstimate", (Object)revisionEstimate);
    }

    private String getMessageByStatus(RevisionAbstractEstimate revisionEstimate, String approverName, String nextDesign) {
        String message = "";
        if (RevisionAbstractEstimate.RevisionEstimateStatus.NEW.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.saved", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CREATED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !"Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.created", (Object[])new String[]{approverName, nextDesign, revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.RESUBMITTED.toString().equals(revisionEstimate.getEgwStatus().getCode()) && !"Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.resubmitted", (Object[])new String[]{approverName, nextDesign, revisionEstimate.getEstimateNumber()}, null);
        } else if (revisionEstimate.getState() != null && "Rejected".equals(revisionEstimate.getState().getValue())) {
            message = this.messageSource.getMessage("msg.revisionestimate.rejected", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CANCELLED.toString().equals(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.cancelled", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.APPROVED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.approved", (Object[])new String[]{revisionEstimate.getEstimateNumber()}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.TECH_SANCTIONED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.technicalsanction", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.CHECKED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.checked", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        } else if (RevisionAbstractEstimate.RevisionEstimateStatus.BUDGET_SANCTIONED.toString().equalsIgnoreCase(revisionEstimate.getEgwStatus().getCode())) {
            message = this.messageSource.getMessage("msg.revisionestimate.budgetsanction", (Object[])new String[]{revisionEstimate.getEstimateNumber(), approverName, nextDesign}, null);
        }
        return message;
    }
}

