/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.revisionestimate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.revisionestimate.entity.RevisionAbstractEstimate;
import org.egov.works.revisionestimate.entity.SearchRevisionEstimate;
import org.egov.works.revisionestimate.service.RevisionEstimateService;
import org.egov.works.web.adaptor.RevisionEstimateJsonAdaptor;
import org.egov.works.web.adaptor.SearchActivityJsonAdaptor;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/revisionestimate"})
public class AjaxRevisionEstimateController {
    @Autowired
    private RevisionEstimateService revisionEstimateService;
    @Autowired
    private SearchActivityJsonAdaptor searchActivityJsonAdaptor;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/getrevisionestimatesbynumber"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> findAbstractEstimateNumbersForAbstractEstimate(@RequestParam String revisionEstimateNumber) {
        return this.revisionEstimateService.getRevisionEstimateByEstimateNumberLike(revisionEstimateNumber);
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchRevisionEstimates(@ModelAttribute SearchRevisionEstimate searchRevisionEstimate, Model model) {
        List searchRevisionEstimates = this.revisionEstimateService.searchRevisionEstimates(searchRevisionEstimate);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)searchRevisionEstimates, SearchRevisionEstimate.class, RevisionEstimateJsonAdaptor.class) + "}";
        return result;
    }

    @RequestMapping(value={"/ajax-searchactivities"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchActivities(HttpServletRequest request) {
        Long workOrderEstimateId = Long.parseLong(request.getParameter("workOrderEstimateId"));
        String description = request.getParameter("description");
        String itemCode = request.getParameter("itemCode");
        String sorType = request.getParameter("sorType");
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        List activities = this.revisionEstimateService.searchActivities(workOrderEstimate.getEstimate().getId(), sorType);
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        if (description != null && !description.equals("")) {
            for (Activity act : activities) {
                if ((act.getSchedule() == null || !act.getSchedule().getDescription().toLowerCase().contains(description.toLowerCase())) && (act.getNonSor() == null || !act.getNonSor().getDescription().toLowerCase().contains(description.toLowerCase()))) continue;
                activityList.add(act);
            }
        }
        if (!activityList.isEmpty()) {
            activities.clear();
            activities.addAll(activityList);
        }
        if (itemCode != null && !itemCode.equals("")) {
            activityList.clear();
            for (Activity act : activities) {
                if (act.getSchedule() == null || !act.getSchedule().getCode().toLowerCase().contains(itemCode.toLowerCase())) continue;
                activityList.add(act);
            }
        }
        if (!activityList.isEmpty()) {
            activities.clear();
            activities.addAll(activityList);
        }
        List updatedActivities = this.mergeChangedQuantities(new ArrayList(activities));
        String result = "{ \"data\":" + this.toSearchActivityResultJson((Object)updatedActivities) + "}";
        return result;
    }

    private List<Activity> mergeChangedQuantities(List<Activity> activities) {
        ArrayList<Activity> updatedActivities = new ArrayList<Activity>();
        for (Activity activity : activities) {
            if (activity.getParent() != null) continue;
            updatedActivities.add(activity);
        }
        return updatedActivities;
    }

    public Object toSearchActivityResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Activity.class, (Object)this.searchActivityJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxsearchretocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> searchREToCancel(String estimateNumber) {
        return this.revisionEstimateService.findRENumbersToCancel(estimateNumber);
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchRevisionEstimatesToCancel(@ModelAttribute SearchRevisionEstimate searchRevisionEstimate, Model model) {
        List revisionEstimates = this.revisionEstimateService.searchRevisionEstimatesToCancel(searchRevisionEstimate);
        String result = "{ \"data\":" + WebUtils.toJSON((Collection)revisionEstimates, SearchRevisionEstimate.class, RevisionEstimateJsonAdaptor.class) + "}";
        return result;
    }

    @RequestMapping(value={"/ajax-checkifdependantObjectscreated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkIfBillsCreated(@RequestParam Long reId) {
        String mbRefNumbers;
        String message = "";
        RevisionAbstractEstimate revisionEstimate = this.revisionEstimateService.getRevisionEstimateById(reId);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByAbstractEstimateId(revisionEstimate.getParent().getId());
        String revisionEstimates = this.revisionEstimateService.getRevisionEstimatesGreaterThanCurrent(revisionEstimate.getParent().getId(), revisionEstimate.getCreatedDate());
        message = !revisionEstimates.equals("") ? this.messageSource.getMessage("error.reexists.greaterthancreateddate", (Object[])new String[]{revisionEstimates}, null) : (!(mbRefNumbers = this.revisionEstimateService.checkIfMBCreatedForRENonTenderedLumpSum(revisionEstimate, workOrderEstimate)).equals("") ? this.messageSource.getMessage("error.re.mb.created", (Object[])new String[]{mbRefNumbers}, null) : this.revisionEstimateService.checkIfMBCreatedForREChangedQuantity(revisionEstimate, workOrderEstimate));
        return message;
    }

    @RequestMapping(value={"/validatere/{workOrderEstimateId}"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String validateRevisionEstimate(@PathVariable Long workOrderEstimateId, HttpServletRequest request, HttpServletResponse response) {
        JsonObject jsonObject = new JsonObject();
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateById(workOrderEstimateId);
        this.revisionEstimateService.validateREInDrafts(workOrderEstimate.getEstimate().getId(), jsonObject, null);
        this.revisionEstimateService.validateREInWorkFlow(workOrderEstimate.getEstimate().getId(), jsonObject, null);
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        return null;
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            throw new ApplicationRuntimeException("error.validate.re");
        }
    }
}

