/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.egov.works.abstractestimate.entity.BudgetFolioDetail;
import org.egov.works.reports.entity.EstimateAppropriationRegisterSearchRequest;
import org.egov.works.reports.service.EstimateAppropriationRegisterService;
import org.egov.works.web.adaptor.EstimateAppropriationRegisterJSONAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class AjaxEstimateAppropriationRegisterController {
    @Autowired
    private EstimateAppropriationRegisterService estimateAppropriationRegisterService;
    @Autowired
    private EstimateAppropriationRegisterJSONAdaptor estimateAppropriationRegisterJSONAdaptor;

    @RequestMapping(value={"/ajax-estimateappropriationregister"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchEstimateAppropriationRegister(Model model, @ModelAttribute EstimateAppropriationRegisterSearchRequest estimateAppropriationRegisterSearchRequest) {
        Map approvedBudgetFolioDetailsMap = this.estimateAppropriationRegisterService.searchEstimateAppropriationRegister(estimateAppropriationRegisterSearchRequest);
        ArrayList approvedBudgetFolioDetails = (ArrayList)approvedBudgetFolioDetailsMap.get("budgetFolioList");
        List calculatedValuesList = (List)approvedBudgetFolioDetailsMap.get("calculatedValues");
        if (calculatedValuesList != null) {
            Double latestCumulative = (Double)calculatedValuesList.get(0);
            BigDecimal latestBalance = (BigDecimal)calculatedValuesList.get(1);
            for (BudgetFolioDetail bfd : approvedBudgetFolioDetails) {
                bfd.setCumulativeExpensesIncurred(latestCumulative);
                bfd.setActualBalanceAvailable(Double.valueOf(latestBalance.doubleValue()));
            }
        }
        if (approvedBudgetFolioDetails == null) {
            approvedBudgetFolioDetails = new ArrayList();
        }
        String result = "{ \"data\":" + this.toSearchEstimateAppropriationRegisterJson(approvedBudgetFolioDetails) + "}";
        return result;
    }

    public Object toSearchEstimateAppropriationRegisterJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(BudgetFolioDetail.class, (Object)this.estimateAppropriationRegisterJSONAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

