/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderMeasurementSheet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/measurementbook"})
public class UpdateMBController
extends GenericWorkFlowController {
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    protected AssignmentService assignmentService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private MeasurementSheetService measurementSheetService;

    @ModelAttribute
    public MBHeader getMBHeader(@PathVariable String mbHeaderId) {
        MBHeader mbHeader = this.mbHeaderService.getMBHeaderById(Long.valueOf(Long.parseLong(mbHeaderId)));
        return mbHeader;
    }

    @RequestMapping(value={"/update/{mbHeaderId}"}, method={RequestMethod.GET})
    public String updateMBHeader(Model model, @PathVariable String mbHeaderId, HttpServletRequest request, @RequestParam(value="mode", required=false) String mode) throws ApplicationException {
        MBHeader mbHeader = this.getMBHeader(mbHeaderId);
        Iterator iterator = mbHeader.getMbDetails().iterator();
        while (iterator.hasNext()) {
            MBDetails details;
            Double prevCumulativeQuantity = this.mbHeaderService.getPreviousCumulativeQuantity((details = (MBDetails)iterator.next()).getMbHeader().getId(), details.getWorkOrderActivity().getId());
            details.setPrevCumlvQuantity(prevCumulativeQuantity != null ? prevCumulativeQuantity : 0.0);
            for (WorkOrderMeasurementSheet woms : details.getWorkOrderActivity().getWorkOrderMeasurementSheets()) {
                Double prevMBMSCumulativeQuantity = this.mbHeaderService.getMeasurementsPreviousCumulativeQuantity(details.getMbHeader().getId(), woms.getId());
                woms.setCumulativeQuantity(prevMBMSCumulativeQuantity != null ? new BigDecimal(prevCumulativeQuantity) : new BigDecimal(0));
            }
        }
        this.splitSorAndNonSorMBDetails(mbHeader);
        if (mode != null && mode.equalsIgnoreCase("Save")) {
            model.addAttribute("message", (Object)this.messageSource.getMessage("msg.mbheader.saved", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
        }
        return this.loadViewData(model, request, mbHeader);
    }

    private void splitSorAndNonSorMBDetails(MBHeader mbHeader) {
        mbHeader.setSorMbDetails((List)mbHeader.getSORMBDetails());
        mbHeader.setNonSorMbDetails((List)mbHeader.getNonSORMBDetails());
        mbHeader.setNonTenderedMbDetails((List)mbHeader.getNonTenderedMBDetails());
        mbHeader.setLumpSumMbDetails((List)mbHeader.getLumpSumMBDetails());
    }

    @RequestMapping(value={"/save/{mbHeaderId}"}, method={RequestMethod.POST})
    @ResponseBody
    public String save(@ModelAttribute(value="mbHeader") MBHeader mbHeader, @RequestParam(value="file") MultipartFile[] files, Model model, BindingResult errors, HttpServletRequest request, BindingResult resultBinder, HttpServletResponse response, @RequestParam(value="removedDetailIds") String removedDetailIds) throws ApplicationException, IOException {
        Long approvalPosition = 0L;
        String approvalComment = "";
        String workFlowAction = "";
        String mode = "";
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        JsonObject jsonObject = new JsonObject();
        this.mbHeaderService.validateMBHeader(mbHeader, jsonObject, resultBinder, mode);
        if (jsonObject.toString().length() > 2) {
            this.sendAJAXResponse(jsonObject.toString(), response);
            return "";
        }
        MBHeader updatedMBHeader = this.getMbHeaderDocuments(mbHeader);
        updatedMBHeader = this.mbHeaderService.update(updatedMBHeader, approvalPosition, approvalComment, workFlowAction, removedDetailIds, files);
        this.mbHeaderService.fillWorkflowData(jsonObject, request, updatedMBHeader);
        if (workFlowAction.equalsIgnoreCase("Save")) {
            jsonObject.addProperty("message", this.messageSource.getMessage("msg.mbheader.saved", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
        } else if (workFlowAction.equalsIgnoreCase("Cancel")) {
            jsonObject.addProperty("message", this.messageSource.getMessage("msg.mbheader.cancelled", (Object[])new String[]{mbHeader.getMbRefNo()}, null));
        } else {
            String pathVars = this.worksUtils.getPathVars(mbHeader.getEgwStatus(), mbHeader.getState(), mbHeader.getId(), approvalPosition);
            String[] keyNameArray = pathVars.split(",");
            String approverName = "";
            String nextDesign = "";
            if (keyNameArray.length != 0 && keyNameArray.length > 0) {
                if (keyNameArray.length == 3) {
                    approverName = keyNameArray[1];
                } else {
                    approverName = keyNameArray[1];
                    nextDesign = keyNameArray[3];
                }
            }
            jsonObject.addProperty("message", this.messageSource.getMessage("msg.mbheader.created", (Object[])new String[]{approverName, nextDesign, mbHeader.getMbRefNo()}, null));
        }
        return jsonObject.toString();
    }

    protected void sendAJAXResponse(String msg, HttpServletResponse response) {
        try {
            PrintWriter httpResponseWriter = response.getWriter();
            IOUtils.write((String)msg, (Writer)httpResponseWriter);
            IOUtils.closeQuietly((Writer)httpResponseWriter);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/update/{mbHeaderId}"}, method={RequestMethod.POST})
    public String update(@ModelAttribute(value="mbHeader") MBHeader mbHeader, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="removedDetailIds") String removedDetailIds, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        MBHeader updatedMBHeader = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.mbHeaderService.getApprovalPositionByMatrixDesignation(mbHeader, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        JsonObject jsonObject = new JsonObject();
        this.mbHeaderService.validateMBHeader(mbHeader, jsonObject, errors, mode);
        if (errors.hasErrors()) {
            model.addAttribute("removedMBDetailIds", (Object)removedDetailIds);
            return this.loadViewData(model, request, mbHeader);
        }
        if (null != workFlowAction) {
            updatedMBHeader = this.mbHeaderService.update(mbHeader, approvalPosition, approvalComment, workFlowAction, removedDetailIds, files);
        }
        redirectAttributes.addFlashAttribute("mbHeader", updatedMBHeader);
        if (updatedMBHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
            return "redirect:/measurementbook/update/" + updatedMBHeader.getId() + "?mode=save";
        }
        if (approvalPosition == null) {
            return "redirect:/measurementbook/mb-success?mbHeader=" + updatedMBHeader.getId() + "&approvalPosition=";
        }
        return "redirect:/measurementbook/mb-success?mbHeader=" + updatedMBHeader.getId() + "&approvalPosition=" + approvalPosition;
    }

    private String loadViewData(Model model, HttpServletRequest request, MBHeader mbHeader) {
        List previousMBHeaders;
        Double totalMBAmountOfMBs;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Boolean isMBEditable = false;
        model.addAttribute("stateType", (Object)mbHeader.getClass().getSimpleName());
        if (mbHeader.getCurrentState() != null && !mbHeader.getCurrentState().getValue().equals("NEW")) {
            model.addAttribute("currentState", (Object)mbHeader.getCurrentState().getValue());
        }
        if (mbHeader.getState() != null && mbHeader.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)mbHeader.getState().getNextAction());
            model.addAttribute("amountRule", (Object)mbHeader.getMbAmount());
            model.addAttribute("pendingActions", (Object)mbHeader.getState().getNextAction());
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(mbHeader.getMbAmount());
        workflowContainer.setPendingActions(mbHeader.getState().getNextAction());
        this.prepareWorkflow(model, (StateAware)mbHeader, workflowContainer);
        List validActionList = Collections.emptyList();
        validActionList = new ArrayList(this.getValidActions((StateAware)mbHeader, workflowContainer));
        validActionList.add("ContractorMeasurements");
        model.addAttribute("validActionList", validActionList);
        if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
            List validActions = Collections.emptyList();
            validActions = this.customizedWorkFlowService.getNextValidActions(mbHeader.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), "NEW", workflowContainer.getPendingActions(), mbHeader.getCreatedDate());
            model.addAttribute("validActionList", (Object)validActions);
        }
        List values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "MB_QUANTITY_TOLERANCE_LEVEL");
        AppConfigValues value = (AppConfigValues)values.get(0);
        model.addAttribute("quantityTolerance", (Object)value.getValue());
        values = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "SECOND_LEVEL_EDIT_MB");
        value = (AppConfigValues)values.get(0);
        if (value.getValue().equalsIgnoreCase("Yes")) {
            isMBEditable = true;
        }
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(mbHeader.getState(), mbHeader.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        model.addAttribute("exceptionaluoms", (Object)this.worksUtils.getExceptionalUOMS());
        MBHeader updatedMBHeader = this.getMbHeaderDocuments(mbHeader);
        model.addAttribute("documentDetails", (Object)updatedMBHeader.getDocumentDetails());
        model.addAttribute("mbHeader", (Object)updatedMBHeader);
        OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(updatedMBHeader.getWorkOrderEstimate().getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
        if (offlineStatus != null) {
            model.addAttribute("workCommencedDate", (Object)sdf.format(offlineStatus.getStatusDate()));
        }
        if ((totalMBAmountOfMBs = this.mbHeaderService.getTotalMBAmountOfMBs(updatedMBHeader.getId(), updatedMBHeader.getWorkOrderEstimate().getId(), MBHeader.MeasurementBookStatus.CANCELLED.toString())) != null) {
            model.addAttribute("totalMBAmountOfMBs", (Object)(totalMBAmountOfMBs - updatedMBHeader.getMbAmount().doubleValue()));
        }
        if (!(previousMBHeaders = this.mbHeaderService.getPreviousMBHeaders(mbHeader.getId(), mbHeader.getWorkOrderEstimate().getId())).isEmpty()) {
            model.addAttribute("previousMBDate", (Object)sdf.format(((MBHeader)previousMBHeaders.get(previousMBHeaders.size() - 1)).getMbDate()));
        } else {
            model.addAttribute("previousMBDate", (Object)"");
        }
        model.addAttribute("isMeasurementsExist", (Object)this.measurementSheetService.existsByEstimate(mbHeader.getWorkOrderEstimate().getEstimate().getId()));
        if (!mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString()) && !updatedMBHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.REJECTED.toString()) && isMBEditable.booleanValue()) {
            model.addAttribute("isMBHeaderEditable", (Object)"false");
        } else {
            model.addAttribute("isMBHeaderEditable", (Object)"true");
        }
        if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString())) {
            model.addAttribute("showHistory", (Object)"false");
        } else {
            model.addAttribute("showHistory", (Object)"true");
        }
        model.addAttribute("nameOfWork", (Object)updatedMBHeader.getWorkOrderEstimate().getEstimate().getName());
        model.addAttribute("loaNumber", (Object)updatedMBHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber());
        model.addAttribute("loaAmount", (Object)updatedMBHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderAmount());
        if (mbHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.NEW.toString()) || updatedMBHeader.getEgwStatus().getCode().equals(MBHeader.MeasurementBookStatus.REJECTED.toString()) || isMBEditable.booleanValue()) {
            model.addAttribute("mode", (Object)"edit");
            return "mbHeader-form";
        }
        model.addAttribute("mode", (Object)"workflowView");
        return "mbheader-view";
    }

    private MBHeader getMbHeaderDocuments(MBHeader mbHeader) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(mbHeader.getId(), "MBHeader");
        mbHeader.setDocumentDetails(documentDetailsList);
        return mbHeader;
    }
}

