/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.mb;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.mb.entity.MBDetails;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.mb.service.MBMeasurementSheetService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/measurementbook"})
public class MeasurementBookPDFController {
    @Autowired
    private MBHeaderService mBHeaderService;
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private MBMeasurementSheetService mBMeasurementSheetService;
    public static final String MEASUREMENTBOOKPDF = "MeasurementBookPDF";
    private final Map<String, Object> reportParams = new HashMap();
    private ReportRequest reportInput = null;
    private ReportOutput reportOutput = null;

    @RequestMapping(value={"/measurementbookPDF/{mbheaderId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateContractorBillPDF(HttpServletRequest request, @PathVariable(value="mbheaderId") Long mbheaderId, HttpSession session) throws IOException {
        MBHeader mBHeader = this.mBHeaderService.getMBHeaderById(mbheaderId);
        return this.generateReport(mBHeader, request, session);
    }

    private ResponseEntity<byte[]> generateReport(MBHeader mBHeader, HttpServletRequest request, HttpSession session) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        if (mBHeader != null) {
            this.reportParams.put("workflowdetails", this.worksUtils.getWorkFlowHistory(mBHeader.getState(), mBHeader.getStateHistory()));
            this.reportParams.put("mBHeader", mBHeader);
            if (mBHeader.getWorkOrderEstimate().getWorkOrder().getTenderFinalizedPercentage() > 0.0) {
                this.reportParams.put("tenderFinalizedPerc", "+" + mBHeader.getWorkOrderEstimate().getWorkOrder().getTenderFinalizedPercentage());
            } else {
                this.reportParams.put("tenderFinalizedPerc", String.valueOf(mBHeader.getWorkOrderEstimate().getWorkOrder().getTenderFinalizedPercentage()));
            }
            List measurements = this.mBMeasurementSheetService.findMeasurementsForMB(mBHeader.getId());
            this.reportParams.put("measurementSize", measurements.size());
            if (measurements != null && !measurements.isEmpty()) {
                this.reportParams.put("measurementDetails", this.mBHeaderService.getMeasurementsForMB(mBHeader));
            }
        }
        String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
        this.reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
        String cityName = (String)request.getSession().getAttribute("citymunicipalityname");
        this.reportParams.put("cityName", cityName);
        this.reportParams.put("currDate", sdf.format(new Date()));
        this.reportParams.put("tenderItems", this.calculateCumulaticeQuantiy(mBHeader));
        this.reportInput = new ReportRequest(MEASUREMENTBOOKPDF, (Object)mBHeader, this.reportParams);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=MeasurementBook_" + mBHeader.getMbRefNo() + ".pdf");
        this.reportOutput = this.reportService.createReport(this.reportInput);
        return new ResponseEntity((Object)this.reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private List<MBDetails> calculateCumulaticeQuantiy(MBHeader mBHeader) {
        for (MBDetails mBDetail : mBHeader.getMbDetails()) {
            Double prevCumulativeAmount;
            if (mBDetail == null || (prevCumulativeAmount = this.mBHeaderService.getPreviousCumulativeQuantity(mBHeader.getId(), mBDetail.getWorkOrderActivity().getId())) == null) continue;
            mBDetail.setPrevCumlvQuantity(prevCumulativeAmount.doubleValue());
        }
        return mBHeader.getMbDetails();
    }
}

