/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class ViewLetterOfAcceptanceController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private MeasurementSheetService measurementSheetService;

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String viewLOA(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(workOrder.getEstimateNumber());
        WorkOrder newWorkOrder = this.getWorkOrderDocuments(workOrder);
        model.addAttribute("workOrder", (Object)newWorkOrder);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("mode", (Object)"view");
        model.addAttribute("documentDetails", (Object)newWorkOrder.getDocumentDetails());
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(workOrder.getState(), workOrder.getStateHistory()));
        return "letterOfAcceptance-view";
    }

    private WorkOrder getWorkOrderDocuments(WorkOrder workOrder) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }
}

