/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.abstractestimate.service.MeasurementSheetService;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class UpdateLetterOfAcceptanceController
extends GenericWorkFlowController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private MeasurementSheetService measurementSheetService;

    @ModelAttribute
    public WorkOrder getWorkOrder(@PathVariable String id) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        return workOrder;
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.GET})
    public String beforeUpdate(Model model, @PathVariable String id, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(id));
        AbstractEstimate abstractEstimate = ((WorkOrderEstimate)workOrder.getWorkOrderEstimates().get(0)).getEstimate();
        if (workOrder.getEgwStatus().getCode().equals("REJECTED")) {
            return "redirect:/letterofacceptance/newform?estimateNumber=" + abstractEstimate.getEstimateNumber() + "&mode=edit";
        }
        model.addAttribute("stateType", (Object)workOrder.getClass().getSimpleName());
        if (workOrder.getCurrentState() != null && !workOrder.getCurrentState().getValue().equalsIgnoreCase("NEW")) {
            model.addAttribute("currentState", (Object)workOrder.getCurrentState().getValue());
        }
        if (workOrder.getState() != null && workOrder.getState().getNextAction() != null) {
            model.addAttribute("nextAction", (Object)workOrder.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)workOrder.getState().getNextAction());
        }
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAmountRule(new BigDecimal(workOrder.getWorkOrderAmount()));
        workflowContainer.setPendingActions(workOrder.getState().getNextAction());
        this.prepareWorkflow(model, (StateAware)workOrder, workflowContainer);
        List validActions = Collections.emptyList();
        validActions = this.customizedWorkFlowService.getNextValidActions(workOrder.getStateType(), workflowContainer.getWorkFlowDepartment(), workflowContainer.getAmountRule(), workflowContainer.getAdditionalRule(), workOrder.getState().getValue(), workflowContainer.getPendingActions(), workOrder.getCreatedDate());
        model.addAttribute("validActionList", (Object)validActions);
        model.addAttribute("mode", (Object)"workflowView");
        WorkOrder newWorkOrder = this.letterOfAcceptanceService.getWorkOrderDocuments(workOrder);
        model.addAttribute("documentDetails", (Object)newWorkOrder.getDocumentDetails());
        model.addAttribute("workOrder", (Object)newWorkOrder);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(workOrder.getState(), workOrder.getStateHistory()));
        model.addAttribute("amountRule", (Object)workOrder.getWorkOrderAmount());
        return "letterOfAcceptance-view";
    }

    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST})
    public String forward(@PathVariable String id, Model model, @RequestParam String workFlowAction, HttpServletRequest request) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(id));
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComment") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        WorkOrder savedWorkOrder = this.letterOfAcceptanceService.forward(workOrder, approvalPosition, approvalComment, null, workFlowAction);
        String pathVars = this.worksUtils.getPathVars(savedWorkOrder.getEgwStatus(), savedWorkOrder.getState(), savedWorkOrder.getId(), approvalPosition);
        return "redirect:/letterofacceptance/letterofacceptance-success?pathVars=" + pathVars;
    }

    @RequestMapping(value={"/modify/{id}"}, method={RequestMethod.GET})
    public String viewLOA(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(workOrder.getEstimateNumber());
        WorkOrder newWorkOrder = this.letterOfAcceptanceService.getWorkOrderDocuments(workOrder);
        model.addAttribute("documentDetails", (Object)newWorkOrder.getDocumentDetails());
        model.addAttribute("workOrder", (Object)newWorkOrder);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("measurementsPresent", (Object)this.measurementSheetService.existsByEstimate(abstractEstimate.getId()));
        model.addAttribute("loggedInUser", (Object)this.securityUtils.getCurrentUser().getName());
        model.addAttribute("mode", (Object)"modify");
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(workOrder.getState(), workOrder.getStateHistory()));
        return "letterOfAcceptance-modify";
    }

    @RequestMapping(value={"/modify/{id}"}, method={RequestMethod.POST})
    public String modify(@ModelAttribute(value="workOrder") WorkOrder workOrder, Model model, BindingResult resultBinder, HttpServletRequest request) throws ApplicationException {
        List workOrderNumbers = this.letterOfAcceptanceService.getApprovedWorkOrdersForCreateContractorBill(workOrder.getWorkOrderNumber());
        if (workOrderNumbers.isEmpty()) {
            resultBinder.rejectValue("", "error.modify.loa.finalbill.exists");
        }
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(workOrder.getEstimateNumber());
        Double revisedWorkOrderAmount = Double.valueOf(request.getParameter("revisedWorkOrderAmount"));
        Double revisedValue = Double.valueOf(request.getParameter("revisedValue"));
        Double balanceAmount = 0.0;
        Double grossBillAmount = 0.0;
        DecimalFormat df = new DecimalFormat("0.00");
        grossBillAmount = this.letterOfAcceptanceService.getGrossBillAmountOfBillsCreated(workOrder.getWorkOrderNumber(), "APPROVED", ContractorBillRegister.BillStatus.CANCELLED.toString());
        if (grossBillAmount == null) {
            grossBillAmount = 0.0;
        }
        if (revisedWorkOrderAmount >= 0.0 && workOrder.getPercentageSign().equals("-")) {
            balanceAmount = abstractEstimate != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isSpillOverFlag() ? Double.valueOf(workOrder.getWorkOrderAmount() - grossBillAmount - revisedValue - abstractEstimate.getLineEstimateDetails().getGrossAmountBilled().doubleValue()) : Double.valueOf(workOrder.getWorkOrderAmount() - grossBillAmount - revisedValue);
            if (balanceAmount < 0.0) {
                if (abstractEstimate != null && abstractEstimate.getLineEstimateDetails().getLineEstimate().isSpillOverFlag()) {
                    grossBillAmount = grossBillAmount + abstractEstimate.getLineEstimateDetails().getGrossAmountBilled().doubleValue();
                }
                resultBinder.rejectValue("", "error.modify.loa.appropriation.amount", (Object[])new String[]{df.format(grossBillAmount).toString(), df.format(revisedWorkOrderAmount).toString()}, null);
            }
        } else if (revisedWorkOrderAmount >= 0.0 && workOrder.getPercentageSign().equals("+")) {
            balanceAmount = revisedWorkOrderAmount - workOrder.getWorkOrderAmount();
        }
        if (revisedWorkOrderAmount == 0.0) {
            resultBinder.rejectValue("", "error.modify.loa.agreement.amount");
        }
        if (resultBinder.hasErrors()) {
            model.addAttribute("abstractEstimate", (Object)abstractEstimate);
            model.addAttribute("mode", (Object)"modify");
            model.addAttribute("revisedValue", (Object)request.getParameter("revisedValue"));
            return "letterOfAcceptance-modify";
        }
        WorkOrder savedWorkOrder = null;
        try {
            LineEstimateDetails lineEstimateDetails = abstractEstimate.getLineEstimateDetails();
            savedWorkOrder = this.letterOfAcceptanceService.update(workOrder, lineEstimateDetails, revisedValue, revisedWorkOrderAmount);
        }
        catch (ValidationException e) {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            BigDecimal budgetAvailable = null;
            if (abstractEstimate != null) {
                FinancialDetail financialDetail = (FinancialDetail)abstractEstimate.getFinancialDetails().get(0);
                budgetheadid.add(financialDetail.getBudgetGroup().getId());
                budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.worksUtils.getFinancialYearByDate(new Date()).getId(), Integer.valueOf(Integer.parseInt(abstractEstimate.getExecutingDepartment().getId().toString())), financialDetail.getFunction().getId(), null, financialDetail.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getScheme().getId().toString())), financialDetail.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(financialDetail.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(financialDetail.getFund().getId().toString())));
            }
            String errorMessage = this.messageSource.getMessage("error.budgetappropriation.amount", (Object[])new String[]{budgetAvailable.toString(), df.format(balanceAmount).toString()}, null);
            model.addAttribute("message", (Object)errorMessage);
            return "lineestimate-success";
        }
        return "redirect:/letterofacceptance/loa-success?loaNumber=" + savedWorkOrder.getWorkOrderNumber() + "&isModify=true";
    }
}

