/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.util.ArrayList;
import java.util.List;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptanceForRE;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.workorder.entity.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/searchletterofacceptance"})
public class LetterOfAcceptanceSearchController {
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;

    @RequestMapping(value={"/searchform"}, method={RequestMethod.GET})
    public String showSearchLineEstimateForm(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("WorkOrder");
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.ACCEPTANCE_LETTER_ACKNOWLEDGED.toString()) || egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.ACCEPTANCE_LETTER_ISSUED.toString()) || egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.AGREEMENT_ORDER_SIGNED.toString()) || egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.WORK_ORDER_ACKNOWLEDGED.toString()) || egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.WORK_COMMENCED.toString()) || egwStatus.getCode().equalsIgnoreCase(WorkOrder.OfflineStatuses.SITE_HANDED_OVER.toString())) continue;
            newEgwStatuses.add(egwStatus);
        }
        model.addAttribute("egwStatus", newEgwStatuses);
        return "searchletterofacceptance-search";
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("departments", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("egwStatus", (Object)this.egwStatusHibernateDAO.getStatusByModule("WorkOrder"));
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
    }

    @RequestMapping(value={"/searchloa-milestone"}, method={RequestMethod.GET})
    public String searchMilestone(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestLetterOfAcceptance.setDepartmentName(((Department)departments.get(0)).getId());
        }
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        return "search-searchmilestone";
    }

    @RequestMapping(value={"/searchformloa-contractorbill"}, method={RequestMethod.GET})
    public String showSearchLOAForContractorBill(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            searchRequestLetterOfAcceptance.setDepartmentName(((Department)departments.get(0)).getId());
        }
        model.addAttribute("departments", (Object)departments);
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        return "searchloatocreatecontractorbill-search";
    }

    @RequestMapping(value={"/searchmodifyform"}, method={RequestMethod.GET})
    public String showSearchLOAModifyForm(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        this.setDropDownValues(model);
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        return "letterofacceptancetomodify-search";
    }

    @RequestMapping(value={"/setloaofflinestatus"}, method={RequestMethod.GET})
    public String showLOAToSetOfflineStatus(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance, Model model) throws ApplicationException {
        List egwStatuses = this.egwStatusHibernateDAO.getStatusByModule("WorkOrder");
        this.setDropDownValues(model);
        ArrayList<EgwStatus> newEgwStatuses = new ArrayList<EgwStatus>();
        for (EgwStatus egwStatus : egwStatuses) {
            if (egwStatus.getCode().equalsIgnoreCase("CREATED") || egwStatus.getCode().equalsIgnoreCase("REJECTED") || egwStatus.getCode().equalsIgnoreCase("cancelled")) continue;
            newEgwStatuses.add(egwStatus);
        }
        model.addAttribute("egwStatus", newEgwStatuses);
        model.addAttribute("searchRequestLetterOfAcceptance", (Object)searchRequestLetterOfAcceptance);
        return "setofflinestatus-search";
    }

    @RequestMapping(value={"/searchloare-form"}, method={RequestMethod.GET})
    public String showSearchLOAForREForm(@ModelAttribute SearchRequestLetterOfAcceptanceForRE searchRequestLetterOfAcceptanceForRE, Model model) throws ApplicationException {
        model.addAttribute("searchRequestLetterOfAcceptanceForRE", (Object)searchRequestLetterOfAcceptanceForRE);
        model.addAttribute("workAssignedUsers", (Object)this.letterOfAcceptanceService.getWorkAssignedUsers());
        return "loatocreatere-search";
    }
}

