/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.workorder.entity.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class ViewEstimatePhotographController {
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;

    @RequestMapping(value={"/view"}, method={RequestMethod.GET})
    public String viewMilestoneTemplate(@RequestParam Long lineEstimateDetailsId, Model model, HttpServletRequest request) throws ApplicationException {
        Long ledId = Long.valueOf(request.getParameter("lineEstimateDetailsId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.BEFORE, ledId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.AFTER, ledId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.DURING, ledId);
        JsonObject photographStages = new JsonObject();
        JsonArray array = new JsonArray();
        for (EstimatePhotographs ep : photographsBefore) {
            JsonObject before = new JsonObject();
            before.addProperty("name", ep.getFileStore().getFileName());
            before.addProperty("type", "image/jpg");
            before.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            before.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)before);
        }
        photographStages.add("before", (JsonElement)array);
        array = new JsonArray();
        for (EstimatePhotographs ep : photographsAfter) {
            JsonObject after = new JsonObject();
            after.addProperty("name", ep.getFileStore().getFileName());
            after.addProperty("type", "image/jpg");
            after.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            after.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)after);
        }
        photographStages.add("after", (JsonElement)array);
        array = new JsonArray();
        for (EstimatePhotographs ep : photographsOnProcess) {
            JsonObject during = new JsonObject();
            during.addProperty("name", ep.getFileStore().getFileName());
            during.addProperty("type", "image/jpg");
            during.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            during.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)during);
        }
        photographStages.add("during", (JsonElement)array);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(ledId);
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("photographStages", (Object)photographStages);
        return "estimatePhotographs-view";
    }
}

