/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.web.adaptor.ViewEstimatePhotographJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class AjaxEstimatePhotographController {
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private ViewEstimatePhotographJsonAdaptor viewEstimatePhotographJsonAdaptor;

    @RequestMapping(value={"/searchestimatephotograph"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchEstimatePhotograph(Model model, @ModelAttribute EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        List searchResultList = this.estimatePhotographService.searchEstimatePhotograph(estimatePhotographSearchRequest);
        String result = "{ \"data\":" + this.toSearchEstimatePhotograph((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimateDetails.class, (Object)this.viewEstimatePhotographJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/getestimatenumbers-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForViewEstimatePhotograph(@RequestParam String estimateNumber) {
        return this.estimatePhotographService.getEstimateNumbersForViewEstimatePhotograph(estimateNumber);
    }

    @RequestMapping(value={"/getwin-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWinForViewEstimatePhotograph(@RequestParam String workIdentificationNumber) {
        return this.estimatePhotographService.getWinForViewEstimatePhotograph(workIdentificationNumber);
    }
}

