/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorportal;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.egov.works.contractorportal.service.ContractorMBHeaderService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/contractorportal/mb"})
public class ViewContractorMBController {
    @Autowired
    private ContractorMBHeaderService contractorMBHeaderService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private EgovCommon egovCommon;
    @Autowired
    private TrackMilestoneService trackMilestoneService;

    @ModelAttribute(value="contractorMB")
    public ContractorMBHeader getContractorMBHeader(@PathVariable String id) {
        ContractorMBHeader contractorMB = this.contractorMBHeaderService.getContractorMBHeaderById(Long.valueOf(Long.parseLong(id)));
        return contractorMB;
    }

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String viewForm(Model model, @PathVariable Long id, HttpServletRequest request) {
        ContractorMBHeader contractorMB = this.contractorMBHeaderService.getContractorMBHeaderById(id);
        ContractorMBHeader newcontractorMB = this.getContractorMBDocuments(contractorMB);
        model.addAttribute("documentDetails", (Object)newcontractorMB.getDocumentDetails());
        model.addAttribute("mode", (Object)"view");
        ArrayList<Long> projectCodeIdList = new ArrayList<Long>();
        projectCodeIdList.add(contractorMB.getWorkOrderEstimate().getEstimate().getLineEstimateDetails().getProjectCode().getId());
        Map result = new HashMap();
        try {
            result = this.egovCommon.getTotalPaymentforProjectCode(projectCodeIdList, new Date());
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        model.addAttribute("totalBillsPaidSoFar", result.get("amount"));
        TrackMilestone trackMilestone = this.trackMilestoneService.getTrackMilestoneTotalPercentage(contractorMB.getWorkOrderEstimate().getId());
        String mileStoneStatus = "";
        mileStoneStatus = trackMilestone == null || trackMilestone.getTotalPercentage().compareTo(BigDecimal.ZERO) < 0 ? "Not Yet Started" : (trackMilestone.getTotalPercentage().compareTo(BigDecimal.ZERO) > 0 && trackMilestone.getTotalPercentage().compareTo(new BigDecimal(100)) < 0 ? "In Progress" : "Completed");
        model.addAttribute("mileStoneStatus", (Object)mileStoneStatus);
        return "contractormb-view";
    }

    private ContractorMBHeader getContractorMBDocuments(ContractorMBHeader contractorMBHeader) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorMBHeader.getId(), "ContractorMBHeader");
        contractorMBHeader.setDocumentDetails(documentDetailsList);
        return contractorMBHeader;
    }

    @RequestMapping(value={"/contractormbs/{id}"}, method={RequestMethod.GET})
    public String ContractorMBs(Model model, @PathVariable Long id, HttpServletRequest request) {
        List contractorMBHeaders = this.contractorMBHeaderService.getContractorMBHeaderByWorkOrderEstimateId(Long.valueOf(id));
        model.addAttribute("contractorMBHeaders", (Object)contractorMBHeaders);
        return "previous-contractormbs";
    }
}

