/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorportal;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.messaging.MessagingService;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.contractorportal.entity.ContractorMBHeader;
import org.egov.works.contractorportal.service.ContractorMBHeaderService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.egov.works.workorder.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/contractorportal/mb"})
public class CreateContractorMBController {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private ContractorMBHeaderService contractorMBHeaderService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private EgovCommon egovCommon;

    @RequestMapping(value={"/search-loaform"}, method={RequestMethod.GET})
    public String showSearchLoaForm() {
        return "contractormb-loasearch";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String showContractorMBForm(@ModelAttribute(value="contractorMBHeader") ContractorMBHeader contractorMBHeader, @RequestParam String loaNumber, Model model) {
        WorkOrder workOrder = this.letterOfAcceptanceService.getApprovedWorkOrder(loaNumber);
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByWorkOrderId(workOrder.getId());
        this.loadViewData(contractorMBHeader, workOrderEstimate, model);
        return "contractormb-form";
    }

    private void loadViewData(ContractorMBHeader contractorMBHeader, WorkOrderEstimate workOrderEstimate, Model model) {
        contractorMBHeader.setWorkOrderEstimate(workOrderEstimate);
        this.contractorMBHeaderService.populateContractorMBDetails(contractorMBHeader);
        model.addAttribute("contractorMB", (Object)contractorMBHeader);
        model.addAttribute("documentDetails", (Object)contractorMBHeader.getDocumentDetails());
        ArrayList<Long> projectCodeIdList = new ArrayList<Long>();
        projectCodeIdList.add(workOrderEstimate.getEstimate().getLineEstimateDetails().getProjectCode().getId());
        Map result = new HashMap();
        try {
            result = this.egovCommon.getTotalPaymentforProjectCode(projectCodeIdList, new Date());
        }
        catch (ApplicationException e) {
            e.printStackTrace();
        }
        model.addAttribute("totalBillsPaidSoFar", result.get("amount"));
        TrackMilestone trackMilestone = this.trackMilestoneService.getTrackMilestoneTotalPercentage(workOrderEstimate.getId());
        String mileStoneStatus = "";
        mileStoneStatus = trackMilestone == null || trackMilestone.getTotalPercentage().compareTo(BigDecimal.ZERO) < 0 ? "Not Yet Started" : (trackMilestone.getTotalPercentage().compareTo(BigDecimal.ZERO) > 0 && trackMilestone.getTotalPercentage().compareTo(new BigDecimal(100)) < 0 ? "In Progress" : "Completed");
        model.addAttribute("mileStoneStatus", (Object)mileStoneStatus);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="contractorMBHeader") ContractorMBHeader contractorMBHeader, Model model, BindingResult errors, HttpServletRequest request, HttpServletResponse response, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        contractorMBHeader.setWorkOrderEstimate(this.workOrderEstimateService.getWorkOrderEstimateById(contractorMBHeader.getWorkOrderEstimate().getId()));
        String errorMessage = this.contractorMBHeaderService.validateContractorMBHeader(contractorMBHeader);
        if (!"".equals(errorMessage)) {
            model.addAttribute("errorMessage", (Object)errorMessage);
            this.loadViewData(contractorMBHeader, contractorMBHeader.getWorkOrderEstimate(), model);
            return "contractormb-form";
        }
        ContractorMBHeader savedContractorMBHeader = this.contractorMBHeaderService.create(contractorMBHeader, files);
        String smsMessage = this.messageSource.getMessage("msg.mb.created.sms", (Object[])new String[]{contractorMBHeader.getWorkOrderEstimate().getWorkOrder().getWorkOrderNumber(), contractorMBHeader.getWorkOrderEstimate().getWorkOrder().getContractor().getName(), contractorMBHeader.getMbAmount().toString()}, null);
        String mobileNumber = contractorMBHeader.getWorkOrderEstimate().getWorkOrder().getEngineerIncharge().getMobileNumber();
        if (StringUtils.isNotBlank((CharSequence)mobileNumber)) {
            this.messagingService.sendSMS(mobileNumber, smsMessage);
        }
        return "redirect:/contractorportal/mb/contractormb-success?contractormb=" + savedContractorMBHeader.getId();
    }

    @RequestMapping(value={"/contractormb-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute ContractorMBHeader contractorMBHeader, @RequestParam(value="contractormb") Long id, HttpServletRequest request, Model model) {
        if (id != null) {
            contractorMBHeader = this.contractorMBHeaderService.getContractorMBHeaderById(id);
        }
        String message = this.messageSource.getMessage("msg.contractor.mbheader.created", (Object[])new String[]{contractorMBHeader.getMbRefNo()}, null);
        model.addAttribute("message", (Object)message);
        return new ModelAndView("contractormb-success", "contractorMBHeader", (Object)contractorMBHeader);
    }
}

