/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.contractorbill;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.eis.web.controller.workflow.GenericWorkFlowController;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.model.bills.EgBilldetails;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.contractorbill.service.ContractorBillRegisterService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.mb.entity.MBHeader;
import org.egov.works.mb.service.MBForCancelledBillService;
import org.egov.works.mb.service.MBHeaderService;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.offlinestatus.service.OfflineStatusService;
import org.egov.works.utils.WorksConstants;
import org.egov.works.utils.WorksUtils;
import org.egov.works.workorder.entity.WorkOrder;
import org.egov.works.workorder.entity.WorkOrderEstimate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/contractorbill"})
public class UpdateContractorBillController
extends GenericWorkFlowController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private ContractorBillRegisterService contractorBillRegisterService;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    @Autowired
    private MBHeaderService mbHeaderService;
    @Autowired
    private MBForCancelledBillService mbForCancelledBillService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private OfflineStatusService offlineStatusService;
    @Autowired
    private MBHeaderService mBHeaderService;

    @ModelAttribute
    public ContractorBillRegister getContractorBillRegister(@PathVariable String contractorBillRegisterId) {
        ContractorBillRegister contractorBillRegister = this.contractorBillRegisterService.getContractorBillById(Long.valueOf(Long.parseLong(contractorBillRegisterId)));
        return contractorBillRegister;
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String updateContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        this.setDropDownValues(model);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
        model.addAttribute("offlinestatusWorkCommencedDate", offlineStatus != null ? offlineStatus.getStatusDate() : "");
        return this.loadViewData(model, request, contractorBillRegister);
    }

    @RequestMapping(value={"/update/{contractorBillRegisterId}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute(value="contractorBillRegister") ContractorBillRegister contractorBillRegister, BindingResult errors, RedirectAttributes redirectAttributes, Model model, HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws ApplicationException, IOException {
        String mode = "";
        String workFlowAction = "";
        ContractorBillRegister updatedContractorBillRegister = null;
        if (request.getParameter("mode") != null) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComment = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (approvalPosition == null || approvalPosition.equals(0L)) {
            approvalPosition = this.contractorBillRegisterService.getApprovalPositionByMatrixDesignation(contractorBillRegister, approvalPosition, null, mode, workFlowAction);
        }
        if ((approvalPosition == null || approvalPosition.equals(0L)) && request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        try {
            if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION)) {
                this.contractorBillRegisterService.checkBudgetAndGenerateBANumber(contractorBillRegister);
            }
        }
        catch (ValidationException e) {
            throw new ApplicationRuntimeException("error.contractorbill.budgetcheck.insufficient.amount");
        }
        if (contractorBillRegister.getStatus().getCode().equals(ContractorBillRegister.BillStatus.REJECTED.toString()) && workFlowAction.equals(WorksConstants.FORWARD_ACTION) && mode.equals("edit")) {
            this.validateInput(contractorBillRegister, contractorBillRegister.getWorkOrderEstimate(), errors, request);
            contractorBillRegister.getEgBilldetailes().clear();
            this.contractorBillRegisterService.mergeDeductionDetails(contractorBillRegister);
            contractorBillRegister = this.addBillDetails(contractorBillRegister, contractorBillRegister.getWorkOrderEstimate(), errors, request);
            contractorBillRegister.setPassedamount(contractorBillRegister.getBillamount());
            if (!this.contractorBillRegisterService.checkForDuplicateAccountCodes(contractorBillRegister)) {
                errors.reject("error.contractorbill.duplicate.accountcodes", "error.contractorbill.duplicate.accountcodes");
            }
            if (!this.contractorBillRegisterService.validateDuplicateRefundAccountCodes(contractorBillRegister)) {
                errors.reject("error.contractorbill.duplicate.refund.accountcodes", "error.contractorbill.duplicate.refund.accountcodes");
            }
            this.contractorBillRegisterService.validateTotalDebitAndCreditAmount(contractorBillRegister, errors);
            this.contractorBillRegisterService.validateRefundAmount(contractorBillRegister, errors);
            this.contractorBillRegisterService.validateMileStonePercentage(contractorBillRegister, errors);
        }
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            return this.loadViewData(model, request, contractorBillRegister);
        }
        if (null != workFlowAction) {
            updatedContractorBillRegister = this.contractorBillRegisterService.updateContractorBillRegister(contractorBillRegister, approvalPosition, approvalComment, null, workFlowAction, mode, files);
        }
        redirectAttributes.addFlashAttribute("contractorBillRegister", updatedContractorBillRegister);
        String pathVars = this.worksUtils.getPathVars(updatedContractorBillRegister.getStatus(), updatedContractorBillRegister.getState(), updatedContractorBillRegister.getId(), approvalPosition);
        return "redirect:/contractorbill/contractorbill-success?pathVars=" + pathVars + "&billNumber=" + updatedContractorBillRegister.getBillnumber();
    }

    private void validateInput(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder, HttpServletRequest request) {
        MBHeader mBHeader;
        BigDecimal totalBillAmountIncludingCurrentBill = contractorBillRegister.getBillamount();
        BigDecimal totalBillAmount = this.contractorBillRegisterService.getTotalBillAmountByWorkOrderAndNotContractorBillRegister(contractorBillRegister.getWorkOrderEstimate(), contractorBillRegister.getId());
        if (totalBillAmount != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(totalBillAmount);
        }
        if (workOrderEstimate.getEstimate().getLineEstimateDetails() != null && workOrderEstimate.getEstimate().getLineEstimateDetails().getLineEstimate().isBillsCreated() && workOrderEstimate.getEstimate().getLineEstimateDetails().getGrossAmountBilled() != null) {
            totalBillAmountIncludingCurrentBill = totalBillAmountIncludingCurrentBill.add(workOrderEstimate.getEstimate().getLineEstimateDetails().getGrossAmountBilled());
        }
        if (totalBillAmountIncludingCurrentBill.doubleValue() > workOrderEstimate.getWorkOrder().getWorkOrderAmount()) {
            resultBinder.reject("error.contractorbill.totalbillamount.exceeds.workorderamount", (Object[])new String[]{String.valueOf(totalBillAmountIncludingCurrentBill), String.valueOf(workOrderEstimate.getWorkOrder().getWorkOrderAmount())}, null);
        }
        if (StringUtils.isBlank((CharSequence)contractorBillRegister.getBilltype())) {
            resultBinder.rejectValue("billtype", "error.billtype.required");
        }
        if (contractorBillRegister.getEgBillregistermis() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate() != null && contractorBillRegister.getEgBillregistermis().getPartyBillDate().before(workOrderEstimate.getWorkOrder().getWorkOrderDate())) {
            resultBinder.rejectValue("egBillregistermis.partyBillDate", "error.validate.partybilldate.lessthan.loadate");
        }
        if (contractorBillRegister.getWorkOrderEstimate() != null && contractorBillRegister.getWorkOrderEstimate().getWorkOrderActivities().isEmpty() && contractorBillRegister.getMbHeader() != null) {
            if (StringUtils.isBlank((CharSequence)contractorBillRegister.getMbHeader().getMbRefNo())) {
                resultBinder.rejectValue("mbHeader.mbRefNo", "error.mbrefno.required");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() == null) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.mbdate.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == null) {
                resultBinder.rejectValue("mbHeader.fromPageNo", "error.frompageno.required");
            }
            if (contractorBillRegister.getMbHeader().getToPageNo() == null) {
                resultBinder.rejectValue("mbHeader.toPageNo", "error.topageno.required");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() == 0 || contractorBillRegister.getMbHeader().getToPageNo() == 0) {
                resultBinder.reject("error.validate.mb.pagenumbers.zero", "error.validate.mb.pagenumbers.zero");
            }
            if (contractorBillRegister.getMbHeader().getFromPageNo() != null && contractorBillRegister.getMbHeader().getToPageNo() != null && contractorBillRegister.getMbHeader().getFromPageNo() > contractorBillRegister.getMbHeader().getToPageNo()) {
                resultBinder.reject("error.validate.mb.frompagenumber.greaterthan.topagenumber", "error.validate.mb.frompagenumber.greaterthan.topagenumber");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getMbHeader().getMbDate().before(workOrderEstimate.getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.validate.mbdate.lessthan.loadate");
            }
            if (contractorBillRegister.getMbHeader().getMbDate() != null && contractorBillRegister.getBilldate().before(contractorBillRegister.getMbHeader().getMbDate())) {
                resultBinder.rejectValue("mbHeader.mbDate", "error.billdate.mbdate");
            }
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAccountCode"))) {
            resultBinder.reject("error.netpayable.accountcode.required", "error.netpayable.accountcode.required");
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("netPayableAmount")) || Double.valueOf(request.getParameter("netPayableAmount").toString()) <= 0.0) {
            resultBinder.reject("error.netpayable.amount.required", "error.netpayable.amount.required");
        }
        if (contractorBillRegister.getBilltype().equals(BillTypes.Final_Bill.toString()) && contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate() == null) {
            resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.required");
        }
        Date currentDate = new Date();
        Date workCompletionDate = contractorBillRegister.getWorkOrderEstimate().getWorkCompletionDate();
        if (workCompletionDate != null) {
            OfflineStatus offlineStatus = this.offlineStatusService.getOfflineStatusByObjectIdAndObjectTypeAndStatus(workOrderEstimate.getWorkOrder().getId(), "WorkOrder", WorkOrder.OfflineStatuses.WORK_COMMENCED.toString().toUpperCase());
            if (workCompletionDate.after(currentDate)) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.futuredate");
            }
            if (offlineStatus != null) {
                if (workCompletionDate.before(offlineStatus.getStatusDate())) {
                    resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workcommenceddate");
                }
            } else if (workCompletionDate.before(contractorBillRegister.getWorkOrderEstimate().getWorkOrder().getWorkOrderDate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.workorderdate");
            }
            if (workCompletionDate.after(contractorBillRegister.getBilldate())) {
                resultBinder.rejectValue("workOrderEstimate.workCompletionDate", "error.workcompletiondate.billdate");
            }
        }
        if ((mBHeader = this.mBHeaderService.getLatestMBHeaderToValidateBillDate(contractorBillRegister.getWorkOrderEstimate().getId(), contractorBillRegister.getBilldate())) != null && contractorBillRegister.getBilldate().before(mBHeader.getMbDate())) {
            resultBinder.rejectValue("mbHeader.mbDate", "error.billdate.mbdate");
        }
    }

    private void setDropDownValues(Model model) {
        List contractorPayableAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Creditors-Contractor Payable");
        List contractorRefundAccountList = this.chartOfAccountsHibernateDAO.getAccountCodeByListOfPurposeName(WorksConstants.CONTRACTOR_REFUND_PURPOSE);
        model.addAttribute("netPayableAccounCodes", (Object)contractorPayableAccountList);
        model.addAttribute("statutoryDeductionAccounCodes", (Object)this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("Contractor Deductions"));
        model.addAttribute("retentionMoneyDeductionAccounCodes", (Object)this.chartOfAccountsHibernateDAO.getAccountCodeByPurposeName("RETENTION_MONEY"));
        model.addAttribute("refundAccounCodes", (Object)contractorRefundAccountList);
        model.addAttribute("billTypes", (Object)BillTypes.values());
    }

    private String loadViewData(Model model, HttpServletRequest request, ContractorBillRegister contractorBillRegister) {
        model.addAttribute("stateType", (Object)contractorBillRegister.getClass().getSimpleName());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        if (contractorBillRegister.getState() != null) {
            model.addAttribute("currentState", (Object)contractorBillRegister.getState().getValue());
            workflowContainer.setPendingActions(contractorBillRegister.getState().getNextAction());
            model.addAttribute("pendingActions", (Object)contractorBillRegister.getState().getNextAction());
            model.addAttribute("amountRule", (Object)contractorBillRegister.getBillamount());
        }
        workflowContainer.setAmountRule(contractorBillRegister.getBillamount());
        this.prepareWorkflow(model, (StateAware)contractorBillRegister, workflowContainer);
        if (contractorBillRegister.getState() != null && contractorBillRegister.getState().getValue().equals("Rejected")) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"view");
        }
        model.addAttribute("billDetailsMap", (Object)this.contractorBillRegisterService.getBillDetailsMap(contractorBillRegister, model));
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(contractorBillRegister.getState(), contractorBillRegister.getStateHistory()));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("approvalDesignation", (Object)request.getParameter("approvalDesignation"));
        model.addAttribute("approvalPosition", (Object)request.getParameter("approvalPosition"));
        model.addAttribute("assetValues", (Object)contractorBillRegister.getWorkOrderEstimate().getAssetValues());
        model.addAttribute("workOrderEstimate", (Object)contractorBillRegister.getWorkOrderEstimate());
        List retentionMoneyPerForPartBillApp = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "Retention money deduction percentage for Part Bill");
        List retentionMoneyPerForFinalBillApp = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "Retention money deduction percentage for Final Bill");
        model.addAttribute("retentionMoneyPerForPartBill", (Object)((AppConfigValues)retentionMoneyPerForPartBillApp.get(0)).getValue());
        model.addAttribute("retentionMoneyPerForFinalBill", (Object)((AppConfigValues)retentionMoneyPerForFinalBillApp.get(0)).getValue());
        ContractorBillRegister newcontractorBillRegister = this.getContractorBillDocuments(contractorBillRegister);
        if (newcontractorBillRegister.getAssetDetailsList() != null && !newcontractorBillRegister.getAssetDetailsList().isEmpty()) {
            model.addAttribute("billAssetValue", newcontractorBillRegister.getAssetDetailsList().get(0));
        }
        model.addAttribute("contractorBillRegister", (Object)newcontractorBillRegister);
        model.addAttribute("documentDetails", (Object)contractorBillRegister.getDocumentDetails());
        List mbHeaders = this.mbHeaderService.getMBHeadersByContractorBill(newcontractorBillRegister);
        if (mbHeaders != null && !mbHeaders.isEmpty()) {
            newcontractorBillRegister.setMbHeader((MBHeader)mbHeaders.get(0));
        }
        if (newcontractorBillRegister.getStatus() != null && newcontractorBillRegister.getStatus().getCode().equalsIgnoreCase("CANCELLED")) {
            model.addAttribute("mbDetails", (Object)this.mbForCancelledBillService.getMBHeadersForCancelledBillListByContractorBillRegister(newcontractorBillRegister));
        } else {
            model.addAttribute("mbDetails", (Object)mbHeaders);
        }
        model.addAttribute("mbHeaders", (Object)mbHeaders);
        return "contractorBill-update";
    }

    private ContractorBillRegister getContractorBillDocuments(ContractorBillRegister contractorBillRegister) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(contractorBillRegister.getId(), "CONTRACTORBILL");
        contractorBillRegister.setDocumentDetails(documentDetailsList);
        return contractorBillRegister;
    }

    @RequestMapping(value={"/view/{contractorBillRegisterId}"}, method={RequestMethod.GET})
    public String viewContractorBillRegister(Model model, @PathVariable String contractorBillRegisterId, HttpServletRequest request) throws ApplicationException {
        ContractorBillRegister contractorBillRegister = this.getContractorBillRegister(contractorBillRegisterId);
        this.loadViewData(model, request, contractorBillRegister);
        model.addAttribute("createdbybydesignation", (Object)this.worksUtils.getUserDesignation(contractorBillRegister.getCreatedBy()));
        model.addAttribute("mode", (Object)"readOnly");
        model.addAttribute("workflowHistory", (Object)this.lineEstimateService.getHistory(contractorBillRegister.getState(), contractorBillRegister.getStateHistory()));
        return "contractorBill-view";
    }

    private ContractorBillRegister addBillDetails(ContractorBillRegister contractorBillRegister, WorkOrderEstimate workOrderEstimate, BindingResult resultBinder, HttpServletRequest request) {
        if (contractorBillRegister.getBillDetailes() == null || contractorBillRegister.getBillDetailes().isEmpty()) {
            resultBinder.reject("error.contractorbill.accountdetails.required", "error.contractorbill.accountdetails.required");
        }
        for (EgBilldetails egBilldetails : contractorBillRegister.getBillDetailes()) {
            if (!contractorBillRegister.getEgBilldetailes().isEmpty() && contractorBillRegister.getEgBilldetailes().size() == 1) {
                for (EgBilldetails refundBill : contractorBillRegister.getRefundBillDetails()) {
                    if (refundBill.getGlcodeid() == null) continue;
                    contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, refundBill, workOrderEstimate, resultBinder, request));
                }
                if (egBilldetails.getGlcodeid() == null) continue;
                contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, workOrderEstimate, resultBinder, request));
                continue;
            }
            if (egBilldetails.getGlcodeid() == null) continue;
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, egBilldetails, workOrderEstimate, resultBinder, request));
        }
        this.contractorBillRegisterService.validateZeroCreditAndDebitAmount(contractorBillRegister, resultBinder);
        String netPayableAccountCodeId = request.getParameter("netPayableAccountCode");
        String netPayableAmount = request.getParameter("netPayableAmount");
        if (StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAccountCodeId) && StringUtils.isNotBlank((CharSequence)netPayableAmount)) {
            EgBilldetails billdetails = new EgBilldetails();
            billdetails.setGlcodeid(new BigDecimal(netPayableAccountCodeId));
            billdetails.setCreditamount(new BigDecimal(netPayableAmount));
            contractorBillRegister.addEgBilldetailes(this.contractorBillRegisterService.getBillDetails(contractorBillRegister, billdetails, workOrderEstimate, resultBinder, request));
        }
        return contractorBillRegister;
    }
}

